/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.velocity;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.velocity.ContextWrangler;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVelocitizer {
    public static final String VELOCITY_LOGGER_NAME = "runtime.log.logsystem.log4j.logger";
    private static final Logger logger = LoggerFactory.getLogger(SimpleVelocitizer.class);
    public static final String ERR_PREFIX = "#ERROR#";

    public static String format(MicroSecondDate date, String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format((Date)date);
    }

    public String evaluate(String template, Channel chan) {
        return this.evaluate(template, ContextWrangler.createContext(chan));
    }

    public String evaluate(String template, EventAccessOperations event) {
        return this.evaluate(template, ContextWrangler.createContext(event));
    }

    public String evaluate(String template, EventAccessOperations event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) {
        return this.evaluate(template, ContextWrangler.createContext(event, channel, original, available, seismograms, cookieJar));
    }

    public String evaluate(String template, VelocityContext ctx) {
        StringWriter writer = new StringWriter();
        try {
            try {
                Velocity.evaluate((Context)ctx, (Writer)writer, (String)"SimpleVelocitizer", (String)template);
            }
            catch (ParseErrorException parseError) {
                return "#ERROR#Invalid Velocity";
            }
            return writer.toString();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return "Unable to evaluate " + template;
        }
    }

    public String evaluate(InputStream template, VelocityContext ctx) {
        StringWriter writer = new StringWriter();
        try {
            try {
                this.evaluate(template, ctx, writer);
            }
            catch (ParseErrorException parseError) {
                return "#ERROR#Invalid Velocity";
            }
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return "Unable to evaluate " + template;
        }
        return writer.toString();
    }

    public void evaluate(InputStream template, VelocityContext ctx, Writer writer) throws ParseErrorException, Exception {
        Velocity.evaluate((Context)ctx, (Writer)writer, (String)"SimpleVelocitizer", (Reader)new InputStreamReader(template));
    }

    public static String cleanUpErrorStringForDisplay(String string) {
        if (string.startsWith(ERR_PREFIX)) {
            return string.substring(ERR_PREFIX.length());
        }
        return string;
    }

    public static void setupVelocityLogger(Properties velocityProps, Logger velocityLogger) {
        velocityProps.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.Log4JLogChute");
        velocityProps.setProperty(VELOCITY_LOGGER_NAME, logger.getName());
    }

    static {
        try {
            Properties props = new Properties();
            SimpleVelocitizer.setupVelocityLogger(props, logger);
            props.setProperty("velocimacro.library", "");
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((String)"Trouble initializing velocity", (Throwable)e);
        }
    }
}

