/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.tour;

import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Empty;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.NotAllowed;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.tour.Tourist;

public class XMLWritingTourist
implements Tourist {
    private Form preAttrForm;
    private StringBuffer result = new StringBuffer();
    private boolean leftLast;
    int depth = 0;
    private Form lastForm;
    private Form waitToLeave;
    public static final int DEFAULT_INT_VALUE = 12;
    public static final String DEFAULT_TEXT_VALUE = "text";
    private String open = "<";
    private String close = ">";

    public XMLWritingTourist() {
        this(false);
    }

    public XMLWritingTourist(boolean escapeBrackets) {
        if (escapeBrackets) {
            this.open = "&lt;";
            this.close = "&gt;";
        }
    }

    @Override
    public void visit(Attribute attr) {
        this.replaceClose("");
        this.write(" " + attr.getName() + "=\"");
        this.preAttrForm = this.lastForm;
    }

    @Override
    public void leave(Attribute attr) {
        this.write("\"" + this.close);
        this.lastForm = this.preAttrForm;
    }

    @Override
    public void visit(Data d) {
        this.lastForm = d;
        if (d.getAnnotation().hasExampleFromAnnotation()) {
            this.write(d.getAnnotation().getExample());
        } else {
            this.write(d.getDatatype().getExampleValue());
        }
    }

    @Override
    public void visit(NamedElement ne) {
        if (!ne.equals(this.lastForm) && this.lastForm != null && !this.leftLast) {
            this.write("\n");
        }
        if (this.waitToLeave == null && ne.getAnnotation().hasExampleFromAnnotation()) {
            String example = ne.getAnnotation().getExample(true);
            this.indentAndWrite(example.replaceAll("\n", "\n" + this.getCurIndent()) + "\n");
            this.waitToLeave = ne;
        } else {
            this.indentAndWrite(this.open + ne.getName() + this.close);
            this.lastForm = ne;
            this.leftLast = false;
        }
        ++this.depth;
    }

    @Override
    public void leave(NamedElement ne) {
        --this.depth;
        if (ne.equals(this.lastForm)) {
            this.replaceClose("/" + this.close + "\n");
        } else {
            this.indentAndWrite(this.open + "/" + ne.getName() + this.close + "\n");
        }
        this.leftLast = true;
        if (ne.equals(this.waitToLeave)) {
            this.waitToLeave = null;
        }
    }

    private void indentAndWrite(String text) {
        this.write(this.getCurIndent() + text);
    }

    private String getCurIndent() {
        StringBuffer indent = new StringBuffer();
        if (this.result.length() > 0 && this.result.charAt(this.result.length() - 1) == '\n') {
            for (int i = 0; i < this.depth; ++i) {
                indent.append("  ");
            }
        }
        return indent.toString();
    }

    private void write(String text) {
        if (this.waitToLeave == null) {
            this.result.append(text);
        }
    }

    private void replaceClose(String with) {
        if (this.waitToLeave == null) {
            this.result.replace(this.result.length() - this.close.length(), this.result.length(), with);
        }
    }

    @Override
    public void visit(Text t) {
        this.lastForm = t;
        if (t.getAnnotation().hasExampleFromAnnotation()) {
            this.write(t.getAnnotation().getExample());
        } else {
            this.write(DEFAULT_TEXT_VALUE);
        }
    }

    @Override
    public void visit(Value v) {
        this.lastForm = v;
        this.write(v.getValue());
    }

    public String getResult() {
        return this.result.toString();
    }

    @Override
    public void visit(Choice choice) {
    }

    @Override
    public void leave(Choice choice) {
    }

    @Override
    public void visit(Empty e) {
    }

    @Override
    public void visit(Group g) {
    }

    @Override
    public void leave(Group g) {
    }

    @Override
    public void visit(Interleave i) {
    }

    @Override
    public void leave(Interleave i) {
    }

    @Override
    public void visit(NotAllowed na) {
    }
}

