/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.validator.tour;

import edu.sc.seis.sod.validator.ModelWalker;
import edu.sc.seis.sod.validator.model.Attribute;
import edu.sc.seis.sod.validator.model.Choice;
import edu.sc.seis.sod.validator.model.Data;
import edu.sc.seis.sod.validator.model.Form;
import edu.sc.seis.sod.validator.model.Group;
import edu.sc.seis.sod.validator.model.Interleave;
import edu.sc.seis.sod.validator.model.MultigenitorForm;
import edu.sc.seis.sod.validator.model.NamedElement;
import edu.sc.seis.sod.validator.model.Text;
import edu.sc.seis.sod.validator.model.Value;
import edu.sc.seis.sod.validator.tour.MinimalVisitGuide;
import edu.sc.seis.sod.validator.tour.TourGuide;
import edu.sc.seis.sod.validator.tour.Tourist;

public class MaximalVisitGuide
implements TourGuide {
    private Form root;

    public MaximalVisitGuide(Form root) {
        this.root = root;
    }

    @Override
    public void lead(Tourist visitor) {
        this.internalLead(visitor, this.root);
    }

    private void internalLead(Tourist visitor, Form curForm) {
        if (!ModelWalker.lineageContainsRefTo(curForm, curForm.getDef(), this.root)) {
            if (curForm instanceof NamedElement) {
                NamedElement cur = (NamedElement)curForm;
                visitor.visit(cur);
                this.internalLead(visitor, cur.getChild());
                visitor.leave(cur);
            } else if (curForm instanceof Choice) {
                Choice c = (Choice)curForm;
                visitor.visit(c);
                this.handleKids(visitor, c);
                visitor.leave(c);
            } else if (curForm instanceof Group) {
                Group g = (Group)curForm;
                visitor.visit(g);
                this.handleKids(visitor, g);
                visitor.leave(g);
            } else if (curForm instanceof Interleave) {
                Interleave g = (Interleave)curForm;
                visitor.visit(g);
                this.handleKids(visitor, g);
                visitor.leave(g);
            } else if (curForm instanceof Value) {
                visitor.visit((Value)curForm);
            } else if (curForm instanceof Data) {
                visitor.visit((Data)curForm);
            } else if (curForm instanceof Text) {
                visitor.visit((Text)curForm);
            } else if (curForm instanceof Attribute) {
                Attribute attr = (Attribute)curForm;
                visitor.visit(attr);
                this.internalLead(visitor, attr.getChild());
                visitor.leave(attr);
            }
        } else {
            MinimalVisitGuide min = new MinimalVisitGuide(curForm);
            min.lead(visitor);
        }
    }

    private void handleKids(Tourist visitor, MultigenitorForm f) {
        Form[] children = f.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.internalLead(visitor, children[i]);
        }
    }
}

