/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.tools;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.StringParser;
import edu.sc.seis.sod.tools.PatternParser;
import java.util.Map;

public class RangeParser
extends PatternParser {
    private String defaultMax;
    public static final String POSITIVE_DECIMAL_NUMBER_RE = "(\\d+\\.?\\d*)";

    public RangeParser(String defaultMax) {
        super("(\\d+\\.?\\d*)-?(\\d+\\.?\\d*)?", new String[]{"min", "max"});
        this.defaultMax = defaultMax;
    }

    @Override
    public Object parse(String arg) throws ParseException {
        Map result = (Map)super.parse(arg);
        if (result.get("max") == null) {
            result.put("max", this.defaultMax);
        }
        return result;
    }

    public static FlaggedOption createParam(String name, String defaultMin, String defaultMax, String helpMessage) {
        return RangeParser.createParam(name, defaultMin, defaultMax, helpMessage, name.charAt(0));
    }

    public static FlaggedOption createParam(String name, String defaultMin, String defaultMax, String helpMessage, char shortFlag) {
        return new FlaggedOption(name, (StringParser)new RangeParser(defaultMax), defaultMin + "-" + defaultMax, false, shortFlag, name, helpMessage);
    }

    @Override
    public String getErrorMessage(String arg) {
        return "A range is formatted like 2.0-7.1, not '" + arg + "'";
    }
}

