/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.event.EventSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.subsetter.origin.RemoveEventDuplicate;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.Object;
import org.w3c.dom.Element;

public class SimilarEvent
extends RemoveEventDuplicate {
    ArrayList<CacheEvent> eventList = new ArrayList();

    public SimilarEvent(Element config) throws ConfigurationException {
        super(config);
        Element sourceElement = SodUtil.getFirstEmbeddedElement(config);
        EventSource source = (EventSource)SodUtil.load(sourceElement, new String[]{"event"});
        while (source.hasNext()) {
            CacheEvent[] events = source.next();
            for (int i = 0; i < events.length; ++i) {
                this.eventList.add(events[i]);
            }
        }
    }

    public SimilarEvent(CacheEvent[] events) {
        for (int i = 0; i < events.length; ++i) {
            this.eventList.add(events[i]);
        }
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, EventAttrImpl eventAttr, OriginImpl preferred_origin) throws Exception {
        for (CacheEvent e : this.getEventsNearTimeAndDepth((Origin)preferred_origin)) {
            if (!e.equals((Object)eventAccess) && !this.isDistanceClose(e, (Origin)preferred_origin)) continue;
            return new Pass(this);
        }
        return new Fail(this);
    }

    @Override
    public List<CacheEvent> getEventsNearTimeAndDepth(Origin preferred_origin) {
        ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
        for (CacheEvent event : this.eventList) {
            if (!this.isTimeOK(event, preferred_origin) || !this.isDepthOK(event, preferred_origin)) continue;
            out.add(event);
        }
        return out;
    }

    private boolean isTimeOK(CacheEvent event, Origin preferred_origin) {
        MicroSecondDate eventTime = new MicroSecondDate(event.getOrigin().getOriginTime());
        MicroSecondDate originTime = new MicroSecondDate(preferred_origin.getOriginTime());
        return eventTime.difference(originTime).lessThanEqual(this.timeVariance);
    }

    private boolean isDepthOK(CacheEvent event, Origin preferred_origin) {
        QuantityImpl eventDepth = (QuantityImpl)event.getOrigin().getLocation().depth;
        QuantityImpl originDepth = (QuantityImpl)preferred_origin.getLocation().depth;
        double difference = eventDepth.subtract(originDepth).getValue(this.depthVariance.get_unit());
        return Math.abs(difference) <= this.depthVariance.getValue();
    }
}

