/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.origin;

import edu.iris.Fissures.event.EventAttrImpl;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.ArmListener;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.UserConfigurationException;
import edu.sc.seis.sod.source.event.MicroSecondTimeRangeSupplier;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.origin.OriginSubsetter;
import java.util.Date;
import java.util.List;

public class NetworkTimeRange
implements OriginSubsetter,
ArmListener,
MicroSecondTimeRangeSupplier {
    private boolean finished;
    private NetworkArm arm;
    private Object finishLock = new Object();
    private MicroSecondTimeRange range;

    public NetworkTimeRange() throws ConfigurationException {
        Start.add(this);
        Start.getRunProps().setAllowDeadNets(true);
    }

    @Override
    public void starting(Arm arm) throws ConfigurationException {
        if (!(arm instanceof NetworkArm)) {
            return;
        }
        this.arm = (NetworkArm)arm;
        this.arm.add(this);
    }

    @Override
    public void started() throws ConfigurationException {
        if (this.arm == null) {
            throw new UserConfigurationException("Using a network time in the event arm requires a network arm");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finished(Arm arm) {
        Object object = this.finishLock;
        synchronized (object) {
            this.finished = true;
            this.finishLock.notify();
        }
    }

    @Override
    public StringTree accept(CacheEvent event, EventAttrImpl eventAttr, OriginImpl origin) {
        return new StringTreeLeaf(this, this.getMSTR().contains(new MicroSecondDate(origin.getOriginTime())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MicroSecondTimeRange getMSTR() {
        if (this.range != null) {
            return this.range;
        }
        Object object = this.finishLock;
        synchronized (object) {
            if (!this.finished) {
                try {
                    this.finishLock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        List<NetworkAttrImpl> nets = this.arm.getSuccessfulNetworks();
        for (NetworkAttrImpl net : nets) {
            StationImpl[] stas = this.arm.getSuccessfulStations(net);
            for (int j = 0; j < stas.length; ++j) {
                List<ChannelImpl> chans = this.arm.getSuccessfulChannels(stas[j]);
                for (ChannelImpl c : chans) {
                    MicroSecondTimeRange chanRange = new MicroSecondTimeRange(c.getEffectiveTime());
                    if (this.range == null) {
                        this.range = chanRange;
                        continue;
                    }
                    if (chanRange.getBeginTime().before((Date)this.range.getBeginTime())) {
                        this.range = new MicroSecondTimeRange(chanRange.getBeginTime(), this.range.getEndTime());
                    }
                    if (!chanRange.getEndTime().after((Date)this.range.getEndTime())) continue;
                    this.range = new MicroSecondTimeRange(this.range.getBeginTime(), chanRange.getEndTime());
                }
            }
        }
        if (this.range == null) {
            this.range = new MicroSecondTimeRange(new MicroSecondDate(), new MicroSecondDate());
        }
        return this.range;
    }
}

