/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.eventStation;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.DistanceRangeSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class DistanceRange
extends DistanceRangeSubsetter
implements EventStationSubsetter {
    private static final Logger logger = LoggerFactory.getLogger(DistanceRange.class);

    public DistanceRange(Element config) throws ConfigurationException {
        super(config);
    }

    @Override
    public StringTree accept(CacheEvent eventAccess, StationImpl station, CookieJar cookieJar) throws Exception {
        OriginImpl origin = eventAccess.getOrigin();
        double actualDistance = SphericalCoords.distance((double)origin.getLocation().latitude, (double)origin.getLocation().longitude, (double)station.getLocation().latitude, (double)station.getLocation().longitude);
        QuantityImpl dist = new QuantityImpl(actualDistance, (Unit)UnitImpl.DEGREE);
        if (dist.greaterThanEqual(this.getMin()) && dist.lessThanEqual(this.getMax())) {
            return new StringTreeLeaf(this, true, "DistanceRange(" + this.getMin() + ", " + this.getMax() + ")");
        }
        return new StringTreeLeaf(this, false, "DistanceRange(" + this.getMin() + ", " + this.getMax() + ")" + dist.toString());
    }
}

