/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.subsetter.channel;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.SeismicHardware;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstrumentationSubsetter
implements ChannelSubsetter {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationSubsetter.class);

    protected SeismicHardware getSeismicHardware(Channel channel, NetworkSource network) throws ChannelNotFound, InvalidResponse {
        ChannelId chanId = channel.get_id();
        return this.getSeismicHardware(network.getInstrumentation(chanId));
    }

    protected abstract SeismicHardware getSeismicHardware(Instrumentation var1);

    protected boolean acceptId(Channel channel, NetworkSource network, int id) {
        try {
            return this.getSeismicHardware((Channel)channel, (NetworkSource)network).id_number == id;
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptManufacturer(Channel channel, NetworkSource network, String manufacturer) {
        try {
            return manufacturer.equals(this.getSeismicHardware((Channel)channel, (NetworkSource)network).manufacturer);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptModel(Channel channel, NetworkSource network, String model) {
        try {
            return model.equals(this.getSeismicHardware((Channel)channel, (NetworkSource)network).model);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    protected boolean acceptSerialNumber(Channel channel, NetworkSource network, String serialNum) {
        try {
            return serialNum.equals(this.getSeismicHardware((Channel)channel, (NetworkSource)network).serial_number);
        }
        catch (ChannelNotFound ex) {
            InstrumentationSubsetter.handleChannelNotFound(ex);
            return false;
        }
        catch (InvalidResponse ex) {
            InstrumentationSubsetter.handle(ex);
            return false;
        }
    }

    public static String getChannelNotFoundMsg() {
        return "Channel not found in network, generally indicates no response for this channel in the server.";
    }

    public static void handleChannelNotFound(ChannelNotFound ex) {
        logger.info(InstrumentationSubsetter.getChannelNotFoundMsg(), (Throwable)ex);
    }

    public static String getInstrumentationInvalidMsg() {
        return "Invalid instrumentation ";
    }

    public static void handle(InvalidResponse e) {
        logger.info(InstrumentationSubsetter.getInstrumentationInvalidMsg(), (Throwable)e);
    }
}

