/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import com.bbn.openmap.event.CenterEvent;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.event.OriginImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.chooser.AvailableStationDataEvent;
import edu.sc.seis.fissuresUtil.chooser.StationDataEvent;
import edu.sc.seis.fissuresUtil.display.EQDataEvent;
import edu.sc.seis.fissuresUtil.display.EQSelectionEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.colorizer.event.DefaultEventColorizer;
import edu.sc.seis.fissuresUtil.map.colorizer.event.EventColorizer;
import edu.sc.seis.fissuresUtil.map.layers.DistanceLayer;
import edu.sc.seis.fissuresUtil.map.layers.EventLayer;
import edu.sc.seis.fissuresUtil.map.layers.StationLayer;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.status.MapPool;
import edu.sc.seis.sod.status.OutputScheduler;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapWaveformStatus
implements Runnable {
    private static final Status success = Status.get(Stage.PROCESSOR, Standing.SUCCESS);
    private Map eventsToBeRendered = Collections.synchronizedMap(new HashMap());
    private MapPool pool;
    private SodDB soddb;
    private static Logger logger = LoggerFactory.getLogger(MapWaveformStatus.class);

    public MapWaveformStatus() throws SQLException {
        this(MapPool.getDefaultPool());
    }

    public MapWaveformStatus(MapPool pool) throws SQLException {
        this.pool = pool;
        this.soddb = SodDB.getSingleton();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int numEventsWaiting = 0;
        CacheEvent[] events = new CacheEvent[]{};
        String[] fileLocs = new String[]{};
        Map map = this.eventsToBeRendered;
        synchronized (map) {
            numEventsWaiting = this.eventsToBeRendered.size();
            if (this.eventsToBeRendered.size() > 0) {
                events = new CacheEvent[this.eventsToBeRendered.size()];
                fileLocs = new String[this.eventsToBeRendered.size()];
                for (CacheEvent cur : this.eventsToBeRendered.keySet()) {
                    events[--numEventsWaiting] = cur;
                    fileLocs[numEventsWaiting] = (String)this.eventsToBeRendered.get(cur);
                }
                this.eventsToBeRendered.clear();
            }
        }
        final OpenMap map2 = this.pool.getMap((EventColorizer)new DefaultEventColorizer());
        try {
            for (int i = 0; i < events.length; ++i) {
                StationLayer sl = map2.getStationLayer();
                sl.honorRepaint(false);
                List<StationImpl> up = this.soddb.getSuccessfulStationsForEvent(events[i]);
                List<StationImpl> down = this.soddb.getStationsForEvent(events[i]);
                Iterator<StationImpl> it = up.iterator();
                while (it.hasNext()) {
                    down.remove(it.next());
                }
                MapWaveformStatus.addStations(sl, (Station[])down.toArray(new StationImpl[0]), 1);
                MapWaveformStatus.addStations(sl, (Station[])up.toArray(new StationImpl[0]), 2);
                sl.honorRepaint(true);
                EventLayer el = map2.getEventLayer();
                DistanceLayer dl = map2.getDistanceLayer();
                EQDataEvent eqEvent = new EQDataEvent((EventAccessOperations[])new ProxyEventAccessOperations[]{events[i]});
                el.eventDataChanged(eqEvent);
                EQSelectionEvent selEvent = new EQSelectionEvent((Object)this, (EventAccessOperations[])new ProxyEventAccessOperations[]{events[i]});
                OriginImpl orig = EventUtil.extractOrigin((EventAccessOperations)events[i]);
                map2.getMapBean().center(new CenterEvent((Object)this, 0.0f, orig.getLocation().longitude));
                dl.eqSelectionChanged(selEvent);
                final String fileLoc = fileLocs[i];
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            map2.writeMapToPNG(fileLoc);
                        }
                        catch (Throwable e) {
                            GlobalExceptionHandler.handle((String)"problem writing map", (Throwable)e);
                        }
                    }
                });
                sl.stationDataCleared();
                el.eventDataCleared();
            }
        }
        catch (Throwable t) {
            GlobalExceptionHandler.handle((String)"Waveform map updater had a problem", (Throwable)t);
        }
        this.pool.returnMap(map2);
    }

    private static void addStations(StationLayer sl, Station[] stations, int status) {
        sl.stationDataChanged(new StationDataEvent(stations));
        for (int j = 0; j < stations.length; ++j) {
            sl.stationAvailabiltyChanged(new AvailableStationDataEvent(stations[j], status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(EventAccessOperations ev, String outputLoc) {
        Map map = this.eventsToBeRendered;
        synchronized (map) {
            if (this.eventsToBeRendered.containsKey(ev)) {
                return false;
            }
            this.eventsToBeRendered.put(ev, outputLoc);
            OutputScheduler.getDefault().schedule(this);
            return true;
        }
    }
}

