/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.status.AllTextTemplate;
import edu.sc.seis.sod.status.StationTemplate;
import edu.sc.seis.sod.status.Template;
import edu.sc.seis.sod.status.eventArm.EventTemplate;
import edu.sc.seis.sod.status.waveformArm.EventStationFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class EventStationGroupTemplate
extends Template
implements EventTemplate {
    private List eventStationFormatters = new ArrayList();
    private boolean success = false;
    private boolean failure = false;
    private static SodDB evStatus = SodDB.getSingleton();

    public EventStationGroupTemplate(Element el) throws ConfigurationException {
        this.parse(el);
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("station")) {
            EventStationFormatter esf = new EventStationFormatter(el);
            this.eventStationFormatters.add(esf);
            return esf;
        }
        if (tag.equals("statusFilter")) {
            if (SodUtil.getNestedText(el).equals("SUCCESS")) {
                this.success = true;
            } else if (SodUtil.getNestedText(el).equals("FAILURE")) {
                this.failure = true;
            }
            return new AllTextTemplate("");
        }
        return this.getCommonTemplate(tag, el);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new StationTemplate(){

            @Override
            public String getResult(Station sta) {
                return text;
            }
        };
    }

    @Override
    public String getResult(CacheEvent ev) {
        try {
            Iterator<StationImpl> staIt = this.success ? evStatus.getSuccessfulStationsForEvent(ev).iterator() : (this.failure ? evStatus.getUnsuccessfulStationsForEvent(ev).iterator() : evStatus.getStationsForEvent(ev).iterator());
            Iterator it = this.eventStationFormatters.iterator();
            while (it.hasNext()) {
                ((EventStationFormatter)it.next()).setEvent(ev);
            }
            StringBuffer buf = new StringBuffer();
            while (staIt.hasNext()) {
                Iterator templateIt = this.templates.iterator();
                while (templateIt.hasNext()) {
                    buf.append(((StationTemplate)templateIt.next()).getResult((Station)staIt.next()));
                }
            }
            return buf.toString();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return "Event formatting threw an exception.  See the errors page for more details.";
        }
    }
}

