/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.waveformArm;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.bag.DistAz;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.status.StationFormatter;
import edu.sc.seis.sod.status.StationTemplate;
import java.text.DecimalFormat;
import org.w3c.dom.Element;

public class EventStationFormatter
extends StationFormatter {
    private CacheEvent ev;
    private static SodDB evStatus = SodDB.getSingleton();

    public EventStationFormatter(Element el) throws ConfigurationException {
        super(el);
    }

    @Override
    public Object getTemplate(String name, Element el) {
        if (name.equals("numSuccess")) {
            return new SuccessfulQuery();
        }
        if (name.equals("numFailed")) {
            return new FailedQuery();
        }
        if (name.equals("numRetry")) {
            return new RetryQuery();
        }
        if (name.equals("distance")) {
            return new Distance();
        }
        if (name.equals("baz")) {
            return new BackAz();
        }
        return super.getTemplate(name, el);
    }

    public void setEvent(CacheEvent ev) {
        this.ev = ev;
    }

    private class RetryQuery
    implements StationTemplate {
        private RetryQuery() {
        }

        @Override
        public String getResult(Station station) {
            return "" + evStatus.getNumRetry(EventStationFormatter.this.ev, (StationImpl)station);
        }
    }

    private class FailedQuery
    implements StationTemplate {
        private FailedQuery() {
        }

        @Override
        public String getResult(Station station) {
            return "" + evStatus.getNumFailed(EventStationFormatter.this.ev, (StationImpl)station);
        }
    }

    private class SuccessfulQuery
    implements StationTemplate {
        private SuccessfulQuery() {
        }

        @Override
        public String getResult(Station station) {
            return "" + evStatus.getNumSuccessful(EventStationFormatter.this.ev, (StationImpl)station);
        }
    }

    private class BackAz
    implements StationTemplate {
        private DecimalFormat df = new DecimalFormat("0.00");

        private BackAz() {
        }

        @Override
        public String getResult(Station station) {
            DistAz dAz = new DistAz(station, (EventAccessOperations)EventStationFormatter.this.ev);
            return this.df.format(dAz.getBaz());
        }
    }

    private class Distance
    implements StationTemplate {
        private DecimalFormat df = new DecimalFormat("0.00");

        private Distance() {
        }

        @Override
        public String getResult(Station station) {
            DistAz dAz = new DistAz(station, (EventAccessOperations)EventStationFormatter.this.ev);
            return this.df.format(dAz.getDelta());
        }
    }
}

