/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.networkArm;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.Site;
import edu.iris.Fissures.IfNetwork.SiteId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.SiteIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.FileWritingTemplate;
import edu.sc.seis.sod.status.NetworkFormatter;
import edu.sc.seis.sod.status.StationFormatter;
import edu.sc.seis.sod.status.TemplateFileLoader;
import edu.sc.seis.sod.status.networkArm.ChannelsInStationTemplate;
import edu.sc.seis.sod.status.networkArm.NetworkMonitor;
import edu.sc.seis.sod.status.networkArm.NetworkStatusTemplate;
import edu.sc.seis.sod.status.networkArm.StationsInNetworkTemplate;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NetworkInfoTemplateGenerator
implements NetworkMonitor {
    private String fileDir;
    private String netsOutputFileName;
    private String stasOutputFileName;
    private String chansOutputFileName;
    private NetworkFormatter netFormatter;
    private StationFormatter staFormatter;
    private NetworkStatusTemplate netTemplate;
    private HashMap stationTemplates = new HashMap();
    private HashMap channelTemplates = new HashMap();
    private Logger logger = LoggerFactory.getLogger(NetworkInfoTemplateGenerator.class);
    private Element netConfig;
    private Element staConfig;
    private Element chanConfig;

    public NetworkInfoTemplateGenerator(Element el) throws Exception {
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element tmpEl;
            if (!(nl.item(i) instanceof Element)) continue;
            Element n = (Element)nl.item(i);
            if (n.getNodeName().equals("netConfig")) {
                this.netConfig = TemplateFileLoader.getTemplate(n);
                tmpEl = SodUtil.getElement(this.netConfig, "filename");
                this.netsOutputFileName = tmpEl.getFirstChild().getNodeValue();
                this.logger.debug("netsOutputFileName = " + this.netsOutputFileName);
                this.netConfig.removeChild(tmpEl);
                continue;
            }
            if (n.getNodeName().equals("stationConfig")) {
                this.staConfig = TemplateFileLoader.getTemplate(n);
                tmpEl = SodUtil.getElement(this.staConfig, "outputLocation");
                this.netFormatter = new NetworkFormatter(tmpEl);
                this.staConfig.removeChild(tmpEl);
                tmpEl = SodUtil.getElement(this.staConfig, "filename");
                this.stasOutputFileName = tmpEl.getFirstChild().getNodeValue();
                this.logger.debug("stasOutputFileName = " + this.stasOutputFileName);
                this.staConfig.removeChild(tmpEl);
                continue;
            }
            if (!n.getNodeName().equals("channelConfig")) continue;
            this.chanConfig = TemplateFileLoader.getTemplate(n);
            tmpEl = SodUtil.getElement(this.chanConfig, "outputLocation");
            this.staFormatter = new StationFormatter(tmpEl);
            this.chanConfig.removeChild(tmpEl);
            tmpEl = SodUtil.getElement(this.chanConfig, "filename");
            this.chansOutputFileName = tmpEl.getFirstChild().getNodeValue();
            this.logger.debug("chansOutputFileName = " + this.chansOutputFileName);
            this.chanConfig.removeChild(tmpEl);
        }
        this.fileDir = FileWritingTemplate.getBaseDirectoryName();
        this.netTemplate = new NetworkStatusTemplate(this.netConfig, this.fileDir, this.netsOutputFileName);
    }

    @Override
    public void change(NetworkAttrImpl net, Status status) {
        try {
            this.netTemplate.change(net, status);
            this.getStationsInNetworkTemplate((NetworkAttr)net);
        }
        catch (ConfigurationException e) {
            String msg = "Got an ConfigurationException changing station status: ";
            msg = msg + NetworkIdUtil.toString((NetworkId)net.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
    }

    @Override
    public void change(Station station, Status status) {
        try {
            StationsInNetworkTemplate snt = this.getStationsInNetworkTemplate(station);
            snt.change(station, status);
            this.getChannelsInStationTemplate(station);
        }
        catch (IOException e) {
            String msg = "Got an IOException changing station status: ";
            msg = msg + StationIdUtil.toString((StationId)station.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
        catch (ConfigurationException e) {
            String msg = "Got an ConfigurationException changing station status: ";
            msg = msg + StationIdUtil.toString((StationId)station.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
    }

    @Override
    public void change(Site site, Status status) {
        try {
            ChannelsInStationTemplate cst = this.getChannelsInStationTemplate(site.getStation());
            cst.change(site, status);
        }
        catch (IOException e) {
            String msg = "Got an IOException changing channel status: ";
            msg = msg + SiteIdUtil.toString((SiteId)site.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
        catch (ConfigurationException e) {
            String msg = "Got an ConfigurationException changing channel status: ";
            msg = msg + SiteIdUtil.toString((SiteId)site.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
    }

    @Override
    public void change(Channel channel, Status status) {
        try {
            ChannelsInStationTemplate cst = this.getChannelsInStationTemplate(channel);
            cst.change(channel, status);
        }
        catch (IOException e) {
            String msg = "Got an IOException changing channel status: ";
            msg = msg + ChannelIdUtil.toString((ChannelId)channel.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
        catch (ConfigurationException e) {
            String msg = "Got an ConfigurationException changing channel status: ";
            msg = msg + ChannelIdUtil.toString((ChannelId)channel.get_id());
            msg = msg + " status=" + status.toString();
            GlobalExceptionHandler.handle((String)msg, (Throwable)e);
        }
    }

    public NetworkStatusTemplate getNetworkStatusTemplate() {
        return this.netTemplate;
    }

    public synchronized StationsInNetworkTemplate getStationsInNetworkTemplate(NetworkAttr net) throws ConfigurationException {
        if (!this.contains(net)) {
            try {
                this.stationTemplates.put(this.getIDString(net), new StationsInNetworkTemplate(this.staConfig, this.fileDir, this.netFormatter.getResult(net) + '/' + this.stasOutputFileName, net));
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((String)"trouble creating StationsInNetworkTemplate", (Throwable)e);
            }
        }
        StationsInNetworkTemplate snt = (StationsInNetworkTemplate)this.stationTemplates.get(this.getIDString(net));
        return snt;
    }

    public StationsInNetworkTemplate getStationsInNetworkTemplate(Station station) throws ConfigurationException {
        return this.getStationsInNetworkTemplate(station.getNetworkAttr());
    }

    public synchronized ChannelsInStationTemplate getChannelsInStationTemplate(Station station) throws IOException, ConfigurationException {
        if (!this.contains(station)) {
            this.channelTemplates.put(this.getIDString(station), new ChannelsInStationTemplate(this.chanConfig, this.fileDir, this.netFormatter.getResult(station.getNetworkAttr()) + '/' + this.staFormatter.getResult(station) + '/' + this.chansOutputFileName, station));
        }
        ChannelsInStationTemplate cst = (ChannelsInStationTemplate)this.channelTemplates.get(this.getIDString(station));
        return cst;
    }

    public ChannelsInStationTemplate getChannelsInStationTemplate(Channel chan) throws IOException, ConfigurationException {
        return this.getChannelsInStationTemplate(chan.getSite().getStation());
    }

    public boolean contains(NetworkAttr net) {
        return this.stationTemplates.containsKey(this.getIDString(net));
    }

    public boolean contains(Station sta) {
        return this.channelTemplates.containsKey(this.getIDString(sta));
    }

    private String getIDString(NetworkAttr netAttr) {
        return NetworkIdUtil.toString((NetworkId)netAttr.get_id());
    }

    private String getIDString(Station sta) {
        return StationIdUtil.toString((StationId)sta.get_id());
    }

    @Override
    public void setArmStatus(String status) {
        this.netTemplate.setArmStatus(status);
    }
}

