/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status.networkArm;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.Site;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.ChannelGroupTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.SiteFormatter;
import edu.sc.seis.sod.status.networkArm.NetworkInfoTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ChannelsInSiteTemplate
extends NetworkInfoTemplate {
    private Site site;
    private List channelListeners = new ArrayList();
    private Logger logger = LoggerFactory.getLogger(ChannelsInSiteTemplate.class);

    public ChannelsInSiteTemplate(Element el, String baseDir, String outputLocation, Site site) throws ConfigurationException, IOException {
        super(baseDir, outputLocation);
        this.site = site;
        this.parse(el);
        this.write();
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("channels")) {
            ChannelGroupTemplate cgt = new ChannelGroupTemplate(el);
            this.channelListeners.add(cgt);
            return cgt;
        }
        if (tag.equals("site")) {
            return new MySiteTemplate(el);
        }
        return super.getTemplate(tag, el);
    }

    public void change(Channel channel, Status status) {
        this.logger.debug("change(channel, status): " + this.site.getStation().getNetworkAttr().get_code() + "." + this.site.getStation().getNetworkAttr().get_code() + "." + this.site.getStation().get_code() + "." + this.site.get_code() + "." + channel.get_code() + ", " + status.toString());
        Iterator it = this.channelListeners.iterator();
        while (it.hasNext()) {
            ((ChannelGroupTemplate)it.next()).change(channel, status);
        }
        this.write();
    }

    private class MySiteTemplate
    implements GenericTemplate {
        SiteFormatter formatter;

        public MySiteTemplate(Element el) throws ConfigurationException {
            this.formatter = new SiteFormatter(el);
        }

        @Override
        public String getResult() {
            return this.formatter.getResult(ChannelsInSiteTemplate.this.site);
        }
    }
}

