/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.status.AllTextTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.StationFormatter;
import edu.sc.seis.sod.status.StationTemplate;
import edu.sc.seis.sod.status.Template;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StationGroupTemplate
extends Template
implements GenericTemplate {
    Map stationMap = new HashMap();
    LinkedList useStanding = new LinkedList();
    LinkedList notUseStanding = new LinkedList();

    public StationGroupTemplate(Element el) throws ConfigurationException {
        this.parse(el);
    }

    @Override
    protected Object getTemplate(String tag, Element el) throws ConfigurationException {
        if (tag.equals("station")) {
            return new StationFormatter(el, this);
        }
        if (tag.equals("statusFilter")) {
            NodeList nl = el.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!(nl.item(i) instanceof Element)) continue;
                Element child = (Element)nl.item(i);
                String name = SodUtil.getNestedText(child);
                try {
                    if (child.getTagName().equals("status")) {
                        this.useStanding.add(Standing.getForName(name));
                        continue;
                    }
                    if (!child.getTagName().equals("notStatus")) continue;
                    this.notUseStanding.add(Standing.getForName(name));
                    continue;
                }
                catch (NoSuchFieldException e) {
                    String msg = "status tag " + name + " is not a valid Standing, please use one of: ";
                    Field[] fields = Standing.class.getFields();
                    for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
                        if (!fields[fieldIndex].getType().equals(Standing.class)) continue;
                        msg = msg + (fieldIndex == 0 ? " " : ", ") + fields[fieldIndex].getName();
                    }
                    throw new ConfigurationException(msg);
                }
            }
            return new AllTextTemplate("");
        }
        return this.getCommonTemplate(tag, el);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new StationTemplate(){

            @Override
            public String getResult(Station sta) {
                return text;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        Map map = this.stationMap;
        synchronized (map) {
            for (Station cur : this.stationMap.keySet()) {
                Status status = (Status)this.stationMap.get(cur);
                if ((this.useStanding.size() != 0 || this.notUseStanding.contains(status.getStanding())) && !this.useStanding.contains(status.getStanding())) continue;
                Iterator templateIt = this.templates.iterator();
                while (templateIt.hasNext()) {
                    buf.append(((StationTemplate)templateIt.next()).getResult(cur));
                }
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(Station sta, Status status) {
        Map map = this.stationMap;
        synchronized (map) {
            this.stationMap.put(sta, status);
        }
    }
}

