/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.status;

import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.status.AllTypeTemplate;
import edu.sc.seis.sod.status.GenericTemplate;
import edu.sc.seis.sod.status.Template;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MenuTemplate
extends Template
implements GenericTemplate {
    private String pathFrom;
    private String fileDir;
    public static final String TEMPLATE_LOC = "jar:edu/sc/seis/sod/data/templates/menu.xml";

    public MenuTemplate(Element el, String pathFrom, String fileDir) throws ConfigurationException {
        this.pathFrom = pathFrom;
        this.fileDir = fileDir;
        this.parse(el);
    }

    @Override
    public Object getTemplate(String tag, Element el) {
        if (tag.equals("relativePath")) {
            return new RelativePath(el, this.pathFrom);
        }
        return this.getCommonTemplate(tag, el);
    }

    @Override
    protected Object textTemplate(final String text) {
        return new AllTypeTemplate(){

            @Override
            public String getResult() {
                return text;
            }
        };
    }

    @Override
    public String getResult() {
        StringBuffer buf = new StringBuffer();
        for (Object cur : this.templates) {
            buf.append(((GenericTemplate)cur).getResult());
        }
        return buf.toString();
    }

    public class RelativePath
    extends AllTypeTemplate {
        private String path;

        public RelativePath(Element el, String pathFrom) {
            Node firstChild = el.getFirstChild();
            String absPathTo = MenuTemplate.this.fileDir + '/' + firstChild.getNodeValue();
            if (el.getFirstChild() instanceof Element) {
                el = (Element)firstChild;
                absPathTo = MenuTemplate.this.fileDir + '/' + ((GenericTemplate)MenuTemplate.this.getCommonTemplate(el.getNodeName(), el)).getResult();
            }
            this.path = SodUtil.getRelativePath(pathFrom, absPathTo, "/");
        }

        @Override
        public String getResult() {
            return this.path;
        }
    }
}

