/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.seismogram;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodElement;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.source.seismogram.WinstonWaveServerSource;
import gov.usgs.winston.server.WWSClient;
import org.w3c.dom.Element;

public class WinstonWaveServer
implements SeismogramSourceLocator,
SodElement {
    private WWSClient ws;
    String host;
    int port;

    public WinstonWaveServer(Element config) {
        this(config, "eeyore.seis.sc.edu");
    }

    public WinstonWaveServer(Element config, String defaultHost) {
        this.host = SodUtil.loadText(config, "host", defaultHost);
        this.port = SodUtil.loadInt(config, "port", 16022);
    }

    public WinstonWaveServer(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public SeismogramSource getSeismogramSource(CacheEvent event, ChannelImpl channel, RequestFilter[] infilters, CookieJar cookieJar) throws Exception {
        return new WinstonWaveServerSource(this.getWaveServer());
    }

    public WWSClient getWaveServer() {
        if (this.ws == null) {
            this.ws = new WWSClient(this.host, this.port);
            if (!this.ws.connect()) {
                System.out.println("Not connected to WWS");
            }
        }
        return this.ws;
    }
}

