/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.IfNetwork.VirtualNetworkHelper;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.cache.CacheNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.VestingNetworkDC;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.BAD_PARAM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class NetworkFinder
extends AbstractNetworkSource {
    protected List<CacheNetworkAccess> recentNetworksCache = null;
    protected List<CacheNetworkAccess> byNameCache = new ArrayList<CacheNetworkAccess>();
    protected VestingNetworkDC netDC;
    private static final Logger logger = LoggerFactory.getLogger(NetworkFinder.class);

    public NetworkFinder(String dns, String name, int retries) {
        super(dns, name, retries);
    }

    public NetworkFinder(Element element) throws Exception {
        super(element);
    }

    public synchronized ProxyNetworkDC getNetworkDC() {
        if (this.netDC == null) {
            this.netDC = new VestingNetworkDC(this.getDNS(), this.getName(), this.getFissuresNamingService(), Start.createRetryStrategy(this.getRetries()));
        }
        return this.netDC;
    }

    @Override
    public CacheNetworkAccess getNetwork(NetworkAttrImpl attr) {
        return this.getNetwork(attr.getId());
    }

    public CacheNetworkAccess getNetwork(NetworkId netId) {
        CacheNetworkAccess net = this.checkCache(netId);
        if (net == null) {
            if (netId.network_code.startsWith("_")) {
                try {
                    List<CacheNetworkAccess> byName = this.getNetworkByName(netId.network_code);
                    if (byName.size() != 0) {
                        this.byNameCache.add(byName.get(0));
                        return byName.get(0);
                    }
                    throw new RuntimeException("Can't get network by name: " + netId.network_code);
                }
                catch (NetworkNotFound e) {
                    throw new RuntimeException("Can't get network from cache or by name: " + netId.network_code);
                }
            }
            throw new RuntimeException("can't find net, should neven happen: " + NetworkIdUtil.toString((NetworkId)netId));
        }
        return net;
    }

    public List<CacheNetworkAccess> getNetworkByName(String name) throws NetworkNotFound {
        ArrayList<CacheNetworkAccess> out = new ArrayList<CacheNetworkAccess>();
        NetworkAccess[] array = this.getNetworkDC().a_finder().retrieve_by_name(name);
        for (int i = 0; i < array.length; ++i) {
            out.add(new CacheNetworkAccess(array[i]));
        }
        return out;
    }

    @Override
    public synchronized List<? extends NetworkAttrImpl> getNetworks() {
        if (this.recentNetworksCache == null) {
            this.getNetworksInternal();
        }
        ArrayList<NetworkAttrImpl> out = new ArrayList<NetworkAttrImpl>();
        for (CacheNetworkAccess netAccess : this.recentNetworksCache) {
            out.add(netAccess.get_attributes());
        }
        return out;
    }

    public synchronized List<CacheNetworkAccess> getNetworksInternal() {
        String[] constrainingCodes = Start.getNetworkArm().getConstrainingNetworkCodes();
        ProxyNetworkDC netDC = this.getNetworkDC();
        netDC.reset();
        ArrayList<CacheNetworkAccess> goodNets = new ArrayList<CacheNetworkAccess>();
        if (constrainingCodes.length > 0) {
            edu.iris.Fissures.IfNetwork.NetworkFinder netFinder = netDC.a_finder();
            for (int i = 0; i < constrainingCodes.length; ++i) {
                CacheNetworkAccess[] found = null;
                try {
                    found = constrainingCodes[i].length() > 2 ? (CacheNetworkAccess[])netFinder.retrieve_by_name(constrainingCodes[i]) : (CacheNetworkAccess[])netFinder.retrieve_by_code(constrainingCodes[i]);
                }
                catch (NetworkNotFound e) {
                    Start.informUserOfBadNetworkAndExit(constrainingCodes[i], e);
                }
                for (int j = 0; j < found.length; ++j) {
                    goodNets.add(found[j]);
                }
            }
        } else {
            NetworkAccess[] tmpNets = netDC.a_finder().retrieve_all();
            for (int i = 0; i < tmpNets.length; ++i) {
                try {
                    VirtualNetworkHelper.narrow((Object)tmpNets[i]);
                    logger.debug("ignoring virtual network " + tmpNets[i].get_attributes().get_code());
                    continue;
                }
                catch (BAD_PARAM bp) {
                    goodNets.add((CacheNetworkAccess)tmpNets[i]);
                }
            }
        }
        this.recentNetworksCache = goodNets;
        return goodNets;
    }

    public List<StationImpl> getStations(NetworkId netId) {
        CacheNetworkAccess net = this.getNetwork(netId);
        StationImpl[] stations = StationImpl.implize((Station[])net.retrieve_stations());
        ArrayList<StationImpl> out = new ArrayList<StationImpl>(stations.length);
        for (int i = 0; i < stations.length; ++i) {
            out.add(stations[i]);
        }
        return out;
    }

    public List<ChannelImpl> getChannels(StationImpl station) {
        if (station == null) {
            throw new NullPointerException("station cannot be null");
        }
        CacheNetworkAccess net = this.getNetwork(station.getNetworkAttrImpl());
        Channel[] tmpChannels = net.retrieve_for_station(station.get_id());
        return this.checkStationTimeOverlap(station, tmpChannels);
    }

    @Override
    public Instrumentation getInstrumentation(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        return this.getNetwork(chanId.network_id).retrieve_instrumentation(chanId, chanId.begin_time);
    }

    @Override
    public QuantityImpl getSensitivity(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        CacheNetworkAccess cna = this.getNetwork(chanId.network_id);
        Sensitivity s = cna.retrieve_sensitivity(chanId, chanId.begin_time);
        return new QuantityImpl((double)s.sensitivity_factor, cna.retrieve_initial_units(chanId, chanId.begin_time));
    }

    protected List<ChannelImpl> checkStationTimeOverlap(StationImpl station, Channel[] inChannels) {
        MicroSecondDate stationBegin = new MicroSecondDate(station.getBeginTime());
        ArrayList<ChannelImpl> chansAtStation = new ArrayList<ChannelImpl>();
        for (int i = 0; i < inChannels.length; ++i) {
            if (new MicroSecondDate(inChannels[i].getSite().getStation().getBeginTime()).equals((Object)stationBegin)) {
                chansAtStation.add((ChannelImpl)inChannels[i]);
                continue;
            }
            logger.info("Channel " + ChannelIdUtil.toString((ChannelId)inChannels[i].get_id()) + " has a station that is not the same as the requested station: req=" + StationIdUtil.toString((StationId)station.get_id()) + "  chan sta=" + StationIdUtil.toString((Station)inChannels[i].getSite().getStation()) + "  " + inChannels[i].getSite().getStation().getBeginTime().date_time + " != " + station.getBeginTime().date_time);
        }
        return chansAtStation;
    }

    protected CacheNetworkAccess checkCache(NetworkId netId) {
        if (this.recentNetworksCache == null) {
            this.getNetworksInternal();
        }
        for (CacheNetworkAccess net : this.recentNetworksCache) {
            if (!NetworkIdUtil.areEqual((NetworkId)netId, (NetworkId)net.get_attributes().getId())) continue;
            return net;
        }
        for (CacheNetworkAccess net : this.byNameCache) {
            if (!NetworkIdUtil.areEqual((NetworkId)netId, (NetworkId)net.get_attributes().getId())) continue;
            return net;
        }
        return null;
    }

    public void reset() {
        this.recentNetworksCache = null;
        this.byNameCache.clear();
    }
}

