/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.network;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.hibernate.ChannelSensitivity;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.source.network.WrappingNetworkSource;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationFromDB
extends WrappingNetworkSource
implements NetworkSource {
    private HashMap<String, QuantityImpl> sensitivityMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationFromDB.class);

    public InstrumentationFromDB(NetworkSource wrapped) {
        super(wrapped);
    }

    @Override
    public Instrumentation getInstrumentation(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        try {
            return this.getInstrumentation(NetworkDB.getSingleton().getChannel(chanId));
        }
        catch (NotFound e) {
            throw new ChannelNotFound(chanId);
        }
    }

    @Override
    public QuantityImpl getSensitivity(ChannelId chanId) throws ChannelNotFound, InvalidResponse {
        try {
            ChannelImpl chan = NetworkDB.getSingleton().getChannel(chanId);
            ChannelSensitivity dbSensitivity = NetworkDB.getSingleton().getSensitivity(chan);
            if (dbSensitivity != null) {
                if (!ChannelSensitivity.isNonChannelSensitivity((ChannelSensitivity)dbSensitivity)) {
                    QuantityImpl out = new QuantityImpl((double)dbSensitivity.getOverallGain(), (Unit)dbSensitivity.getInputUnits());
                    return out;
                }
                throw new ChannelNotFound(chanId);
            }
            QuantityImpl sense = this.getWrapped().getSensitivity(chanId);
            dbSensitivity = new ChannelSensitivity(chan, (float)sense.getValue(), 0.0f, sense.getUnit());
            NetworkDB.getSingleton().putSensitivity(dbSensitivity);
            return sense;
        }
        catch (NotFound e) {
            throw new ChannelNotFound(chanId);
        }
    }

    public Instrumentation getInstrumentation(ChannelImpl chan) throws ChannelNotFound {
        Instrumentation inst = NetworkDB.getSingleton().getInstrumentation(chan);
        if (inst != null && inst.the_response.stages.length == 0) {
            logger.warn("bad instrumentation in db, stages.length==0, regetting. " + ChannelIdUtil.toStringNoDates((Channel)chan));
            NetworkDB.getSingleton().putInstrumentation(chan, null);
            inst = null;
        }
        if (inst == null) {
            try {
                inst = this.getWrapped().getInstrumentation(chan.getId());
                NetworkDB.getSingleton().putInstrumentation(chan, inst);
            }
            catch (ChannelNotFound e) {
                logger.warn("exception", (Throwable)e);
                NetworkDB.getSingleton().putInstrumentation(chan, null);
            }
            catch (InvalidResponse e) {
                logger.warn("exception", (Throwable)e);
                NetworkDB.getSingleton().putInstrumentation(chan, null);
            }
        }
        return inst;
    }
}

