/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source.event;

import edu.iris.Fissures.model.TimeInterval;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.event.EventSource;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.w3c.dom.Element;

public class DelayedEventSource
implements EventSource {
    EventSource wrappedSource;
    TimeInterval delay;
    LinkedList<CacheEvent> delayedEvents = new LinkedList();

    protected DelayedEventSource(TimeInterval delay, EventSource source) {
        this.delay = delay;
        this.wrappedSource = source;
    }

    public DelayedEventSource(Element config) throws ConfigurationException {
        this.delay = SodUtil.loadTimeInterval(SodUtil.getElement(config, "delay"));
        Object o = SodUtil.load(config, "event");
        if (o instanceof EventSource) {
            this.wrappedSource = (EventSource)o;
        }
    }

    @Override
    public String getDescription() {
        return "Delayed (" + this.wrappedSource.getDescription() + ") delayed " + this.delay;
    }

    @Override
    public MicroSecondTimeRange getEventTimeRange() {
        return this.wrappedSource.getEventTimeRange();
    }

    @Override
    public TimeInterval getWaitBeforeNext() {
        return this.wrappedSource.getWaitBeforeNext();
    }

    @Override
    public boolean hasNext() {
        return this.delayedEvents.size() != 0 || this.wrappedSource.hasNext();
    }

    @Override
    public CacheEvent[] next() {
        ArrayList<CacheEvent> out = new ArrayList<CacheEvent>();
        for (CacheEvent cacheEvent : this.delayedEvents) {
            if (!this.checkEvent(cacheEvent)) continue;
            out.add(cacheEvent);
        }
        if (out.size() != 0) {
            return out.toArray(new CacheEvent[0]);
        }
        if (this.wrappedSource.hasNext()) {
            CacheEvent[] wrapEvents = this.wrappedSource.next();
            for (int i = 0; i < wrapEvents.length; ++i) {
                if (this.checkEvent(wrapEvents[i])) {
                    out.add(wrapEvents[i]);
                    continue;
                }
                this.delayedEvents.add(wrapEvents[i]);
            }
        }
        return out.toArray(new CacheEvent[0]);
    }

    public boolean checkEvent(CacheEvent e) {
        return ClockUtil.now().subtract(this.delay).after((Date)e.getOrigin().getTime());
    }
}

