/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.source;

import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.sod.CommonAccess;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public abstract class AbstractSource
implements Source {
    private String name;
    private String dns;
    private int retries = -1;
    private static Logger logger = LoggerFactory.getLogger(AbstractSource.class);

    public AbstractSource(String dns, String name) {
        this(dns, name, -1);
    }

    public AbstractSource(String dns, String name, int retries) {
        this.dns = dns;
        this.name = name;
        retries = -1;
    }

    public AbstractSource(Element config, String defaultName) {
        this.dns = SodUtil.loadText(config, "dns", "edu/iris/dmc");
        this.name = SodUtil.loadText(config, "name", defaultName);
        this.retries = SodUtil.loadInt(config, "retries", -1);
    }

    @Override
    public String getDNS() {
        return this.dns;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getRetries() {
        return this.retries;
    }

    public FissuresNamingService getFissuresNamingService() {
        return CommonAccess.getNameService();
    }
}

