/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.fissuresUtil.bag.IncompatibleSeismograms;
import edu.sc.seis.fissuresUtil.bag.Rotate;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.measure.ListMeasurement;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.measure.ScalarMeasurement;
import edu.sc.seis.sod.measure.SeismogramMeasurement;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.MseedWriter;
import edu.sc.seis.sod.process.waveform.SacWriter;
import edu.sc.seis.sod.process.waveform.vector.AbstractWaveformVectorMeasure;
import edu.sc.seis.sod.process.waveform.vector.IterDecon;
import edu.sc.seis.sod.process.waveform.vector.IterDeconResult;
import edu.sc.seis.sod.process.waveform.vector.ZeroPowerException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class IterDeconReceiverFunction
extends AbstractWaveformVectorMeasure {
    public static float DEFAULT_GWIDTH = 2.5f;
    public static int DEFAULT_MAXBUMPS = 400;
    public static float DEFAULT_TOL = 0.001f;
    protected float gwidth = DEFAULT_GWIDTH;
    protected float tol = DEFAULT_TOL;
    protected int maxBumps = DEFAULT_MAXBUMPS;
    protected String modelName = "prem";
    protected boolean pWave = true;
    protected TimeInterval shift = IterDeconReceiverFunction.getDefaultShift();
    protected TimeInterval pad = IterDeconReceiverFunction.getDefaultShift();
    protected AbstractSeismogramWriter writer;
    public static final TimeInterval DEFAULT_SHIFT = new TimeInterval(10.0, UnitImpl.SECOND);
    boolean overwrite = false;
    TauPUtil taup;
    IterDecon decon;
    static final Logger logger = LoggerFactory.getLogger(IterDeconReceiverFunction.class);

    public IterDeconReceiverFunction(Element config) throws ConfigurationException, TauModelException {
        super(config);
        this.parseIterDeconConfig(config);
        this.taup = TauPUtil.getTauPUtil((String)this.modelName);
        this.decon = new IterDecon(this.maxBumps, true, this.tol, this.gwidth);
    }

    public void parseIterDeconConfig(Element config) throws ConfigurationException {
        Element sacWriterElement;
        Element mseedWriterElement;
        Element asciiWriterElement;
        Element toleranceElement;
        Element bumpsElement;
        Element gElement;
        Element phaseNameElement;
        Element modelElement = SodUtil.getElement(config, "modelName");
        if (modelElement != null) {
            this.modelName = SodUtil.getNestedText(modelElement);
        }
        if ((phaseNameElement = SodUtil.getElement(config, "phaseName")) != null) {
            String phaseName = SodUtil.getNestedText(phaseNameElement);
            this.pWave = phaseName.equals("P");
        }
        if ((gElement = SodUtil.getElement(config, "gaussianWidth")) != null) {
            String gwidthStr = SodUtil.getNestedText(gElement);
            this.gwidth = Float.parseFloat(gwidthStr);
        }
        if ((bumpsElement = SodUtil.getElement(config, "maxBumps")) != null) {
            String bumpsStr = SodUtil.getNestedText(bumpsElement);
            this.maxBumps = Integer.parseInt(bumpsStr);
        }
        if ((toleranceElement = SodUtil.getElement(config, "tolerance")) != null) {
            String toleranceStr = SodUtil.getNestedText(toleranceElement);
            this.tol = Float.parseFloat(toleranceStr);
        }
        if ((asciiWriterElement = SodUtil.getElement(config, "asciiWriter")) != null) {
            SacWriter sac = new SacWriter(asciiWriterElement);
            this.writer = sac;
        }
        if ((mseedWriterElement = SodUtil.getElement(config, "mseedWriter")) != null) {
            MseedWriter mseed = new MseedWriter(mseedWriterElement);
            this.writer = mseed;
        }
        if ((sacWriterElement = SodUtil.getElement(config, "sacWriter")) != null) {
            SacWriter sac = new SacWriter(sacWriterElement);
            this.writer = sac;
        }
    }

    @Override
    Measurement calculate(CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        String[] stringArray;
        ChannelImpl chan = channelGroup.getChannels()[0];
        Origin origin = event.get_preferred_origin();
        ChannelId[] chanIds = new ChannelId[channelGroup.getChannels().length];
        for (int i = 0; i < chanIds.length; ++i) {
            chanIds[i] = channelGroup.getChannels()[i].get_id();
        }
        LocalSeismogramImpl[] singleSeismograms = new LocalSeismogramImpl[3];
        for (int i = 0; i < singleSeismograms.length; ++i) {
            singleSeismograms[i] = seismograms[i][0];
        }
        IterDeconResult[] ans = this.process((EventAccessOperations)event, channelGroup, singleSeismograms);
        if (this.pWave) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ttp";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "tts";
        }
        String[] phaseName = stringArray;
        List pPhases = this.taup.calcTravelTimes(chan.getSite().getStation(), origin, phaseName);
        MicroSecondDate firstP = new MicroSecondDate(origin.getOriginTime());
        firstP = firstP.add(new TimeInterval(((Arrival)pPhases.get(0)).getTime(), UnitImpl.SECOND));
        TimeInterval shift = this.getShift();
        ArrayList<Measurement> measurementList = new ArrayList<Measurement>();
        for (int i = 0; i < ans.length; ++i) {
            float[] predicted = ans[i].getPredicted();
            String chanCode = i == 0 ? "ITR" : "ITT";
            double az = i == 0 ? Rotate.getRadialAzimuth((Location)channelGroup.getStation().getLocation(), (Location)event.getPreferred().getLocation()) : Rotate.getTransverseAzimuth((Location)channelGroup.getStation().getLocation(), (Location)event.getPreferred().getLocation());
            LocalSeismogramImpl rfSeis = this.saveTimeSeries(predicted, "receiver function " + singleSeismograms[0].channel_id.station_code, chanCode, firstP.subtract(shift), singleSeismograms[0], UnitImpl.DIMENSONLESS, new Orientation((float)az, 0.0f), event, channelGroup, original, available, cookieJar);
            String mName = i == 0 ? "radial" : "transverse";
            measurementList.add(new SeismogramMeasurement(mName, rfSeis));
            measurementList.add(new ScalarMeasurement(mName + "_percentMatch", ans[i].getPercentMatch()));
        }
        return new ListMeasurement(this.getName(), measurementList);
    }

    public IterDeconResult[] process(EventAccessOperations event, ChannelGroup channelGroup, LocalSeismogramImpl[] localSeis) throws NoPreferredOrigin, FissuresException, IncompatibleSeismograms, TauModelException, ZeroPowerException {
        return this.process(event, (Channel[])channelGroup.getChannels(), localSeis);
    }

    public IterDeconResult[] process(EventAccessOperations event, Channel[] channel, LocalSeismogramImpl[] localSeis) throws NoPreferredOrigin, IncompatibleSeismograms, FissuresException, TauModelException, ZeroPowerException {
        IterDeconResult ansTangential;
        IterDeconResult ansRadial;
        float[] zdata;
        LocalSeismogramImpl n = null;
        LocalSeismogramImpl e = null;
        LocalSeismogramImpl z = null;
        String foundChanCodes = "";
        for (int i = 0; i < localSeis.length; ++i) {
            if (localSeis[i].channel_id.channel_code.endsWith("N")) {
                n = localSeis[i];
            } else if (localSeis[i].channel_id.channel_code.endsWith("E")) {
                e = localSeis[i];
            }
            if (localSeis[i].channel_id.channel_code.endsWith("Z")) {
                z = localSeis[i];
            }
            foundChanCodes = foundChanCodes + localSeis[i].channel_id.channel_code + " ";
        }
        if (n == null || e == null || z == null) {
            logger.error("problem one seismogram component is null ");
            throw new NullPointerException("problem one seismogram component is null, " + foundChanCodes + " " + " " + (n != null) + " " + (e != null) + " " + (z != null));
        }
        Channel nChan = null;
        Channel eChan = null;
        Channel zChan = null;
        for (int i = 0; i < channel.length; ++i) {
            if (channel[i].get_id().channel_code.endsWith("N")) {
                nChan = channel[i];
            } else if (channel[i].get_id().channel_code.endsWith("E")) {
                eChan = channel[i];
            }
            if (!channel[i].get_id().channel_code.endsWith("Z")) continue;
            zChan = channel[i];
        }
        if (nChan == null || eChan == null || zChan == null) {
            logger.error("problem one channel component is null ");
            throw new NullPointerException("problem one channel component is null,  " + (nChan != null) + " " + (eChan != null) + " " + (zChan != null));
        }
        Location staLoc = zChan.getSite().getStation().getLocation();
        Origin origin = event.get_preferred_origin();
        Location evtLoc = origin.getLocation();
        LocalSeismogramImpl[] rotSeis = Rotate.rotateGCP((LocalSeismogramImpl)e, (Orientation)eChan.getOrientation(), (LocalSeismogramImpl)n, (Orientation)nChan.getOrientation(), (Location)staLoc, (Location)evtLoc, (String)"T", (String)"R");
        float[][] rotated = new float[][]{rotSeis[0].get_as_floats(), rotSeis[1].get_as_floats()};
        if (rotated[0].length != (zdata = z.get_as_floats()).length) {
            logger.error("data is not of same length " + rotated[0].length + " " + zdata.length);
            throw new IncompatibleSeismograms("data is not of same length " + rotated[0].length + " " + zdata.length);
        }
        if (zdata.length == 0) {
            throw new IncompatibleSeismograms("data is of zero length ");
        }
        SamplingImpl samp = SamplingImpl.createSamplingImpl((Sampling)z.sampling_info);
        double period = samp.getPeriod().convertTo(UnitImpl.SECOND).getValue();
        zdata = IterDecon.makePowerTwo(zdata);
        rotated[0] = IterDecon.makePowerTwo(rotated[0]);
        rotated[1] = IterDecon.makePowerTwo(rotated[1]);
        if (this.pWave) {
            ansRadial = this.processComponent(rotated[1], zdata, (float)period, staLoc, origin);
            ansTangential = this.processComponent(rotated[0], zdata, (float)period, staLoc, origin);
        } else {
            ansRadial = this.processComponent(zdata, rotated[1], (float)period, staLoc, origin);
            ansTangential = this.processComponent(zdata, rotated[0], (float)period, staLoc, origin);
        }
        IterDeconResult[] ans = new IterDeconResult[]{ansRadial, ansTangential};
        return ans;
    }

    public IterDeconResult processComponent(float[] component, float[] zdata, float period, Location staLoc, Origin origin) throws TauModelException, ZeroPowerException {
        String[] stringArray;
        if (component.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Component length is " + component.length);
        }
        if (zdata.length == 0) {
            throw new ArrayIndexOutOfBoundsException("Z component length is " + zdata.length);
        }
        IterDeconResult ans = this.decon.process(component, zdata, period);
        float[] predicted = ans.getPredicted();
        logger.info("predicted.length = " + predicted.length);
        if (this.pWave) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "ttp";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "tts";
        }
        String[] phaseName = stringArray;
        List pPhases = this.taup.calcTravelTimes(staLoc, origin, phaseName);
        MicroSecondDate firstP = new MicroSecondDate(origin.getOriginTime());
        logger.debug("origin " + firstP);
        firstP = firstP.add(new TimeInterval(((Arrival)pPhases.get(0)).getTime(), UnitImpl.SECOND));
        logger.debug("firstP " + firstP);
        this.shift = (TimeInterval)this.shift.convertTo(UnitImpl.SECOND);
        if (this.shift.getValue() != 0.0) {
            logger.debug("shifting by " + this.shift + "  before 0=" + predicted[0]);
            predicted = IterDecon.phaseShift(predicted, (float)this.shift.getValue(), period);
            logger.debug("shifting by " + this.shift);
        }
        logger.info("Finished with receiver function processing");
        logger.debug("rec func begin " + firstP.subtract(this.shift));
        ans.predicted = predicted;
        ans.setAlignShift(this.shift);
        return ans;
    }

    public LocalSeismogramImpl saveTimeSeries(float[] data, String name, String chanCode, MicroSecondDate begin, LocalSeismogramImpl refSeismogram, UnitImpl unit, Orientation orientation, CacheEvent event, ChannelGroup channelGroup, RequestFilter[][] original, RequestFilter[][] available, CookieJar cookieJar) throws Exception {
        ChannelId recFuncChanId = new ChannelId(refSeismogram.channel_id.network_id, refSeismogram.channel_id.station_code, refSeismogram.channel_id.site_code, chanCode, refSeismogram.channel_id.begin_time);
        ChannelImpl recFuncChan = new ChannelImpl(recFuncChanId, name, orientation, channelGroup.getChannel1().getSamplingInfo(), channelGroup.getChannel1().getEffectiveTime(), channelGroup.getChannel1().getSite());
        LocalSeismogramImpl predSeis = new LocalSeismogramImpl("recFunc/" + chanCode + "/" + refSeismogram.get_id(), begin.getFissuresTime(), data.length, refSeismogram.sampling_info, (Unit)unit, recFuncChanId, data);
        predSeis.setName(name);
        if (this.writer != null) {
            this.writer.accept(event, recFuncChan, original[0], available[0], new LocalSeismogramImpl[]{predSeis}, cookieJar);
        }
        return predSeis;
    }

    public float getGwidth() {
        return this.gwidth;
    }

    public float getTol() {
        return this.tol;
    }

    public int getMaxBumps() {
        return this.maxBumps;
    }

    public boolean ispWave() {
        return this.pWave;
    }

    public TimeInterval getShift() {
        return this.shift;
    }

    public TimeInterval getPad() {
        return this.pad;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public static TimeInterval getDefaultShift() {
        return DEFAULT_SHIFT;
    }

    public boolean isThreadSafe() {
        return true;
    }
}

