/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform.vector;

import edu.sc.seis.fissuresUtil.freq.Cmplx;
import edu.sc.seis.sod.process.waveform.OregonDspFFT;
import edu.sc.seis.sod.process.waveform.vector.IterDeconResult;
import edu.sc.seis.sod.process.waveform.vector.ZeroPowerException;
import org.apache.log4j.Logger;

public class IterDecon {
    protected int maxBumps;
    protected boolean useAbsVal;
    protected float tol;
    protected float gwidthFactor;
    protected static boolean useNativeFFT = false;
    protected static boolean useOregonDSPFFT = true;
    private static final Logger logger = Logger.getLogger(IterDecon.class);

    public IterDecon(int maxBumps, boolean useAbsVal, float tol, float gwidthFactor) {
        this.maxBumps = maxBumps;
        this.useAbsVal = useAbsVal;
        this.tol = tol;
        this.gwidthFactor = gwidthFactor;
    }

    public IterDeconResult process(float[] numerator, float[] denominator, float dt) throws ZeroPowerException {
        int bump;
        float fPower;
        float[] amps = new float[this.maxBumps];
        int[] shifts = new int[this.maxBumps];
        numerator = IterDecon.makePowerTwo(numerator);
        denominator = IterDecon.makePowerTwo(denominator);
        float[] f = IterDecon.gaussianFilter(numerator, this.gwidthFactor, dt);
        float[] g = IterDecon.gaussianFilter(denominator, this.gwidthFactor, dt);
        float prevPower = fPower = IterDecon.power(f);
        float gPower = IterDecon.power(g);
        if (fPower == 0.0f || gPower == 0.0f) {
            throw new ZeroPowerException("Power of numerator and denominator must be non-zero: num=" + fPower + " denom=" + gPower);
        }
        float[] residual = f;
        float[] predicted = new float[]{};
        float[][] corrSave = new float[this.maxBumps][];
        float improvement = 100.0f;
        for (bump = 0; bump < this.maxBumps && improvement > this.tol; ++bump) {
            float[] corr = IterDecon.correlateNorm(residual, g);
            corrSave[bump] = corr;
            shifts[bump] = this.useAbsVal ? IterDecon.getAbsMaxIndex(corr) : IterDecon.getMaxIndex(corr);
            amps[bump] = corr[shifts[bump]] / dt;
            predicted = IterDecon.buildDecon(amps, shifts, g.length, this.gwidthFactor, dt);
            if (useNativeFFT) {
                throw new RuntimeException("NativeFFT not implemented");
            }
            float[] predConvolve = Cmplx.convolve((float[])predicted, (float[])denominator, (float)dt);
            residual = IterDecon.getResidual(f, predConvolve);
            float residualPower = IterDecon.power(residual);
            improvement = 100.0f * (prevPower - residualPower) / fPower;
            prevPower = residualPower;
        }
        IterDeconResult result = new IterDeconResult(this.maxBumps, this.useAbsVal, this.tol, this.gwidthFactor, numerator, denominator, dt, amps, shifts, residual, predicted, corrSave, IterDecon.buildSpikes(amps, shifts, g.length), prevPower, fPower, bump);
        return result;
    }

    public static float[] correlateNorm(float[] fdata, float[] gdata) {
        float zeroLag = IterDecon.power(gdata);
        if (useNativeFFT) {
            throw new RuntimeException("NativeFFT not implemented");
        }
        float[] corr = Cmplx.correlate((float[])fdata, (float[])gdata);
        float temp = 1.0f / zeroLag;
        int i = 0;
        while (i < corr.length) {
            int n = i++;
            corr[n] = corr[n] * temp;
        }
        return corr;
    }

    static float[] buildSpikes(float[] amps, int[] shifts, int n) {
        float[] p = new float[n];
        for (int i = 0; i < amps.length; ++i) {
            int n2 = shifts[i];
            p[n2] = p[n2] + amps[i];
        }
        return p;
    }

    static float[] buildDecon(float[] amps, int[] shifts, int n, float gwidthFactor, float dt) {
        return IterDecon.gaussianFilter(IterDecon.buildSpikes(amps, shifts, n), gwidthFactor, dt);
    }

    public static float[] getResidual(float[] x, float[] y) {
        float[] r = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            r[i] = x[i] - y[i];
        }
        return r;
    }

    public static int getAbsMaxIndex(float[] data) {
        int minIndex = IterDecon.getMinIndex(data);
        int maxIndex = IterDecon.getMaxIndex(data);
        if (Math.abs(data[minIndex]) > Math.abs(data[maxIndex])) {
            return minIndex;
        }
        return maxIndex;
    }

    public static final int getMinIndex(float[] data) {
        int index = 0;
        for (int i = 1; i < data.length / 2; ++i) {
            if (!(data[i] < data[index])) continue;
            index = i;
        }
        return index;
    }

    public static final int getMaxIndex(float[] data) {
        int index = 0;
        for (int i = 1; i < data.length / 2; ++i) {
            if (!(data[i] > data[index])) continue;
            index = i;
        }
        return index;
    }

    public static final float power(float[] data) {
        float power = 0.0f;
        for (int i = 0; i < data.length; ++i) {
            power += data[i] * data[i];
        }
        return power;
    }

    public static float[] gaussianFilter(float[] x, float gwidthFactor, float dt) {
        if (gwidthFactor == 0.0f) {
            return x;
        }
        float[] forward = IterDecon.forwardFFT(x);
        double df = 1.0f / ((float)forward.length * dt);
        double d_omega = Math.PI * 2 * df;
        double gwidth = 4.0f * gwidthFactor * gwidthFactor;
        double omega = Math.PI / (double)dt;
        double gauss = Math.exp(-omega * omega / gwidth);
        if (useOregonDSPFFT) {
            int n = forward.length / 2;
            forward[n] = (float)((double)forward[n] * gauss);
        } else {
            forward[1] = (float)((double)forward[1] * gauss);
        }
        for (int i = 1; i < forward.length / 2; ++i) {
            int j = i * 2;
            omega = (double)i * d_omega;
            gauss = Math.exp(-omega * omega / gwidth);
            if (useOregonDSPFFT) {
                int n = i;
                forward[n] = (float)((double)forward[n] * gauss);
                int n2 = forward.length - i;
                forward[n2] = (float)((double)forward[n2] * gauss);
                continue;
            }
            int n = j;
            forward[n] = (float)((double)forward[n] * gauss);
            int n3 = j + 1;
            forward[n3] = (float)((double)forward[n3] * gauss);
        }
        forward = IterDecon.inverseFFT(forward);
        return forward;
    }

    public static float[] shortenFFT(float[] tmp) {
        float[] forward = new float[tmp.length / 2];
        System.arraycopy(tmp, 0, forward, 0, forward.length);
        forward[0] = tmp[0];
        forward[1] = tmp[tmp.length / 2];
        return forward;
    }

    public static float[] lengthenFFT(float[] tmp) {
        float[] out = new float[tmp.length * 2];
        for (int i = 1; i < tmp.length / 2; ++i) {
            out[2 * i] = tmp[2 * i];
            out[2 * i + 1] = tmp[2 * i + 1];
            out[out.length - 2 * i] = tmp[2 * i];
            out[out.length - 2 * i + 1] = -1.0f * tmp[2 * i + 1];
        }
        out[0] = tmp[0];
        out[1] = 0.0f;
        out[tmp.length] = tmp[1];
        out[tmp.length + 1] = 0.0f;
        return out;
    }

    public static float[] phaseShift(float[] x, float shift, float dt) {
        float[] forward = IterDecon.forwardFFT(x);
        double df = 1.0f / ((float)forward.length * dt);
        double d_omega = Math.PI * 2 * df;
        double omega = Math.PI / (double)dt;
        if (useOregonDSPFFT) {
            int n = forward.length / 2;
            forward[n] = forward[n] * (float)Math.cos(omega * (double)shift);
        } else {
            forward[1] = forward[1] * (float)Math.cos(omega * (double)shift);
        }
        for (int j = 1; j < forward.length / 2; ++j) {
            double b;
            double a;
            omega = (double)j * d_omega;
            double c = Math.cos(omega * (double)shift);
            double d = Math.sin(omega * (double)shift);
            if (useOregonDSPFFT) {
                a = forward[j];
                b = forward[forward.length - j];
                forward[j] = (float)(a * c - b * d);
                forward[forward.length - j] = (float)(a * d + b * c);
                continue;
            }
            a = forward[2 * j];
            b = forward[2 * j + 1];
            forward[2 * j] = (float)(a * c - b * d);
            forward[2 * j + 1] = (float)(a * d + b * c);
        }
        forward = IterDecon.inverseFFT(forward);
        return forward;
    }

    public static float[] forwardFFT(float[] x) {
        float[] forward = new float[x.length];
        System.arraycopy(x, 0, forward, 0, x.length);
        if (useNativeFFT) {
            throw new RuntimeException("NativeFFT not implemented");
        }
        if (useOregonDSPFFT) {
            forward = OregonDspFFT.forward(x);
            for (int i = 1; i < forward.length / 2; ++i) {
                int n = forward.length - i;
                forward[n] = forward[n] * -1.0f;
            }
        } else {
            float[] javaFFT = new float[forward.length * 2];
            for (int i = 0; i < forward.length; ++i) {
                javaFFT[2 * i] = forward[i];
            }
            forward = IterDecon.shortenFFT(Cmplx.four1Forward((float[])javaFFT));
        }
        return forward;
    }

    public static float[] inverseFFT(float[] x) {
        float[] inverse = new float[x.length];
        System.arraycopy(x, 0, inverse, 0, x.length);
        if (useNativeFFT) {
            throw new RuntimeException("NativeFFT not implemented");
        }
        if (useOregonDSPFFT) {
            for (int i = 1; i < x.length / 2; ++i) {
                int n = x.length - i;
                x[n] = x[n] * -1.0f;
            }
            inverse = OregonDspFFT.inverse(x);
        } else {
            float[] tmp = Cmplx.four1Inverse((float[])IterDecon.lengthenFFT(inverse));
            inverse = new float[tmp.length / 2];
            for (int i = 0; i < tmp.length / 2; ++i) {
                inverse[i] = tmp[2 * i];
            }
        }
        return inverse;
    }

    public static float[] makePowerTwo(float[] data) {
        float[] out = new float[IterDecon.nextPowerTwo(data.length)];
        System.arraycopy(data, 0, out, 0, data.length);
        return out;
    }

    public static int nextPowerTwo(int n) {
        int i;
        for (i = 1; i < n; i *= 2) {
        }
        return i;
    }
}

