/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.Transfer;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.display.configuration.DOMHelper;
import edu.sc.seis.fissuresUtil.sac.FissuresToSac;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.seisFile.sac.SacPoleZero;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;

public class TransferResponse
implements WaveformProcess,
Threadable {
    float lowCut;
    float lowPass;
    float highPass;
    float highCut;
    public static final float DEFAULT_LOW_CUT = 0.005f;
    public static final float DEFAULT_LOW_PASS = 0.01f;
    public static final float DEFAULT_HIGH_PASS = 100000.0f;
    public static final float DEFAULT_HIGH_CUT = 1000000.0f;

    public TransferResponse(Element config) throws ConfigurationException {
        this.lowCut = DOMHelper.extractFloat((Element)config, (String)"lowCut", (float)0.005f);
        this.lowPass = DOMHelper.extractFloat((Element)config, (String)"lowPass", (float)0.01f);
        this.highPass = DOMHelper.extractFloat((Element)config, (String)"highPass", (float)100000.0f);
        this.highCut = DOMHelper.extractFloat((Element)config, (String)"highCut", (float)1000000.0f);
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        try {
            LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
            NetworkSource na = Start.getNetworkArm().getNetworkSource();
            if (seismograms.length > 0) {
                ChannelId chanId = channel.get_id();
                SacPoleZero polezero = TransferResponse.checkResponse(chanId, na);
                Transfer transfer = new Transfer();
                for (int i = 0; i < seismograms.length; ++i) {
                    out[i] = transfer.apply(seismograms[i], polezero, this.lowCut, this.lowPass, this.highPass, this.highCut);
                }
                return new WaveformResult(out, new StringTreeLeaf(this, true));
            }
            return new WaveformResult(true, seismograms, this);
        }
        catch (InvalidResponse e) {
            return new WaveformResult(seismograms, new Fail((Object)this, e.getMessage()));
        }
    }

    public static SacPoleZero checkResponse(ChannelId chanId, NetworkSource na) throws InvalidResponse {
        try {
            Instrumentation inst = na.getInstrumentation(chanId);
            InstrumentationLoader.checkResponse((Response)inst.the_response);
            Filter filter = inst.the_response.stages[0].filters[0];
            if (filter.discriminator().value() != 1) {
                String filterType = " (" + filter.discriminator().value() + ")";
                if (filter.discriminator().value() == 0) {
                    filterType = "Coefficient Response (" + filterType + ")";
                } else if (filter.discriminator().value() == 2) {
                    filterType = "List Response (" + filterType + ")";
                }
                throw new InvalidResponse("Instrumentation is not a of pole-zero type: " + filterType);
            }
            return FissuresToSac.getPoleZero((Response)inst.the_response);
        }
        catch (ChannelNotFound e) {
            throw new InvalidResponse("No instrumentation found", (Throwable)e);
        }
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }
}

