/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.ChannelNotFound;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.sac.InvalidResponse;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.source.network.NetworkSource;
import edu.sc.seis.sod.status.StringTreeLeaf;

public class ResponseGain
implements WaveformProcess,
Threadable {
    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        if (seismograms.length > 0) {
            NetworkSource na = Start.getNetworkArm().getNetworkSource();
            try {
                ChannelId chanId = channel.get_id();
                QuantityImpl sensitivity = na.getSensitivity(chanId);
                if (sensitivity == null) {
                    throw new ChannelNotFound();
                }
                for (int i = 0; i < seismograms.length; ++i) {
                    out[i] = edu.sc.seis.fissuresUtil.bag.ResponseGain.apply((LocalSeismogramImpl)seismograms[i], (float)((float)sensitivity.value), (Unit)sensitivity.the_units);
                }
                return new WaveformResult(out, new StringTreeLeaf(this, true));
            }
            catch (ChannelNotFound e) {
                return new WaveformResult(out, new StringTreeLeaf(this, false, "No instrumentation found for time " + seismograms[0].begin_time.date_time));
            }
            catch (InvalidResponse e) {
                return new WaveformResult(out, new StringTreeLeaf(this, false, "Invalid instrumentation for " + ChannelIdUtil.toString((ChannelId)channel.get_id()) + ": " + e.getMessage()));
            }
        }
        return new WaveformResult(true, seismograms, this);
    }
}

