/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.sod.hibernate.RecordSectionItem;
import edu.sc.seis.sod.process.waveform.RSDistanceRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSectionSpacer {
    protected String PERCENT_COVERAGE = "PercentCoverage";
    private static final Logger logger = LoggerFactory.getLogger(RecordSectionSpacer.class);
    private double minimumDegreesBetweenSeis;
    private double idealDegreesBetweenSeis;

    public RecordSectionSpacer() {
        this(new RSDistanceRange(0.0, 180.0));
    }

    public RecordSectionSpacer(RSDistanceRange range) {
        this(range, 15, 21);
    }

    public RecordSectionSpacer(RSDistanceRange range, int idealSeismograms, int maximumSeismogram) {
        double r = range.getMaxDistance() - range.getMinDistance();
        this.minimumDegreesBetweenSeis = r / (double)(maximumSeismogram - 1);
        this.idealDegreesBetweenSeis = r / (double)(idealSeismograms - 1);
    }

    public List<RecordSectionItem> spaceOut(List<RecordSectionItem> recordSectionList) {
        ArrayList<RecordSectionItem> remaining = new ArrayList<RecordSectionItem>();
        remaining.addAll(recordSectionList);
        Collections.sort(remaining, new Comparator<RecordSectionItem>(){

            @Override
            public int compare(RecordSectionItem o1, RecordSectionItem o2) {
                if (o1.getDegrees() < o2.getDegrees()) {
                    return -1;
                }
                if (o1.getDegrees() > o2.getDegrees()) {
                    return 1;
                }
                return 0;
            }
        });
        ArrayList<RecordSectionItem> accepted = new ArrayList<RecordSectionItem>();
        double nextSlot = 0.0;
        ArrayList<RecordSectionItem> distBin = new ArrayList<RecordSectionItem>();
        for (RecordSectionItem cur : remaining) {
            float dist = cur.getDegrees();
            if ((double)dist < nextSlot - this.idealDegreesBetweenSeis + this.minimumDegreesBetweenSeis) continue;
            if ((double)dist < nextSlot + this.idealDegreesBetweenSeis) {
                distBin.add(cur);
                continue;
            }
            while (distBin.size() > 0 && (double)dist > nextSlot + this.idealDegreesBetweenSeis) {
                RecordSectionItem best = this.bestFromBin(distBin, nextSlot);
                accepted.add(best);
                Iterator binIter = distBin.iterator();
                while (binIter.hasNext()) {
                    RecordSectionItem dss = (RecordSectionItem)binIter.next();
                    if (!((double)dss.getDegrees() < (double)best.getDegrees() + this.minimumDegreesBetweenSeis)) continue;
                    binIter.remove();
                }
                nextSlot = (double)best.getDegrees() + this.idealDegreesBetweenSeis;
            }
            while ((double)dist > nextSlot + this.idealDegreesBetweenSeis) {
                nextSlot += this.idealDegreesBetweenSeis / 2.0;
            }
            distBin.add(cur);
        }
        if (distBin.size() > 0) {
            RecordSectionItem best = this.bestFromBin(distBin, nextSlot);
            accepted.add(best);
        }
        return accepted;
    }

    public double getMinimumDegreesBetweenSeis() {
        return this.minimumDegreesBetweenSeis;
    }

    public double getIdealDegreesBetweenSeis() {
        return this.idealDegreesBetweenSeis;
    }

    protected RecordSectionItem bestFromBin(List<RecordSectionItem> distBin, double nextSlot) {
        RecordSectionItem best = distBin.get(0);
        double bestScore = this.calcScore(best, nextSlot);
        for (RecordSectionItem rsi : distBin) {
            double curScore = this.calcScore(rsi, nextSlot);
            if (!(curScore > bestScore)) continue;
            best = rsi;
            bestScore = curScore;
        }
        return best;
    }

    protected DataSetSeismogram bestFromBin(List<DataSetSeismogram> distBin, double nextSlot, Map<DataSetSeismogram, QuantityImpl> dists) {
        DataSetSeismogram best = distBin.get(0);
        double bestScore = this.calcScore(best, dists.get(best), nextSlot);
        for (DataSetSeismogram dss : distBin) {
            double curScore = this.calcScore(dss, dists.get(dss), nextSlot);
            if (!(curScore > bestScore)) continue;
            best = dss;
            bestScore = curScore;
        }
        return best;
    }

    protected double calcScore(RecordSectionItem rsi, double nextSlot) {
        return this.calcScore(rsi.getDegrees(), rsi.getsToN(), nextSlot);
    }

    protected double calcScore(DataSetSeismogram dss, QuantityImpl dist, double nextSlot) {
        double sToN = 0.0;
        if (dss.getAuxillaryData((Object)"sod_phaseStoN_ttp") != null) {
            sToN = Double.parseDouble((String)dss.getAuxillaryData((Object)"sod_phaseStoN_ttp"));
        }
        double percentCoverage = 1.0;
        if (dss.getAuxillaryData((Object)this.PERCENT_COVERAGE) != null) {
            percentCoverage = Double.parseDouble((String)dss.getAuxillaryData((Object)this.PERCENT_COVERAGE));
        }
        return this.calcScore(dist.getValue(UnitImpl.DEGREE), sToN, nextSlot);
    }

    protected double calcScore(double dist, double sToN, double nextSlot) {
        double distMetric = 1.0 - Math.abs(nextSlot - dist) / this.idealDegreesBetweenSeis;
        return distMetric + distMetric * (sToN - 1.0);
    }
}

