/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.measure.ArrayMeasurement;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.process.waveform.AbstractWaveformMeasure;
import org.w3c.dom.Element;

public class OregonDspFFT
extends AbstractWaveformMeasure {
    public OregonDspFFT(Element config) {
        super(config);
    }

    @Override
    Measurement calculate(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        if (seismograms.length != 1) {
            throw new Exception("Require continuous data, but num seismograms=" + seismograms.length);
        }
        return new ArrayMeasurement(this.getName(), OregonDspFFT.forward(seismograms[0].get_as_floats()));
    }

    public static float[] forward(float[] realData) {
        return edu.sc.seis.fissuresUtil.bag.OregonDspFFT.forward((float[])realData);
    }

    public static float[] inverse(float[] realData) {
        return edu.sc.seis.fissuresUtil.bag.OregonDspFFT.inverse((float[])realData);
    }

    public static float[] correlate(float[] x, float[] y) {
        return edu.sc.seis.fissuresUtil.bag.OregonDspFFT.correlate((float[])x, (float[])y);
    }

    public static float[] convolve(float[] x, float[] y, float delta) {
        return edu.sc.seis.fissuresUtil.bag.OregonDspFFT.convolve((float[])x, (float[])y, (float)delta);
    }
}

