/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.StreamPump;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.Element;

public class LegacyExecute
implements WaveformProcess {
    protected String command;
    protected String prefix = "";
    protected File workingDirectory = null;

    public LegacyExecute(Element config) {
        String workingDirectoryStr;
        Element workElement;
        String cmdString;
        Element cmdElement;
        String dssPrefix;
        Element prefixElement = SodUtil.getElement(config, "prefix");
        if (prefixElement != null && (dssPrefix = SodUtil.getText(prefixElement)) != null && dssPrefix.length() != 0) {
            this.prefix = dssPrefix;
        }
        if ((cmdElement = SodUtil.getElement(config, "command")) != null && (cmdString = SodUtil.getText(cmdElement)) != null && cmdString.length() != 0) {
            this.command = cmdString;
        }
        if ((workElement = SodUtil.getElement(config, "workingDirectory")) != null && (workingDirectoryStr = SodUtil.getText(workElement)) != null && workingDirectoryStr.length() != 0) {
            this.workingDirectory = new File(workingDirectoryStr);
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        System.arraycopy(seismograms, 0, out, 0, out.length);
        String args = this.command;
        for (int i = 0; i < seismograms.length; ++i) {
            args = args + " " + (String)cookieJar.get(AbstractSeismogramWriter.getCookieName(this.prefix, channel.get_id(), i));
        }
        int exitValue = this.process(args);
        return new WaveformResult(out, new StringTreeLeaf(this, exitValue == 0, "exit value=" + exitValue));
    }

    protected int process(String args) throws InterruptedException, IOException {
        if (this.workingDirectory != null) {
            this.workingDirectory.mkdirs();
        }
        Process process = Runtime.getRuntime().exec(args, null, this.workingDirectory);
        StreamPump outPump = new StreamPump(process.getInputStream(), (Writer)new BufferedWriter(new PrintWriter(System.out)));
        StreamPump errPump = new StreamPump(process.getErrorStream(), (Writer)new BufferedWriter(new PrintWriter(System.err)));
        outPump.start();
        errPump.start();
        int exitValue = process.waitFor();
        return exitValue;
    }
}

