/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.bag.ButterworthFilter;
import edu.sc.seis.fissuresUtil.bag.RMean;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Filter
implements WaveformProcess,
Threadable {
    Element config;
    ButterworthFilter filter;
    QuantityImpl lowFreqCorner;
    QuantityImpl highFreqCorner;
    int numPoles = 2;
    int filterType = 1;
    RMean rmean;

    public Filter(Element config) throws ConfigurationException {
        this.config = config;
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if (element.getTagName().equals("lowFreqCorner")) {
                this.lowFreqCorner = SodUtil.loadQuantity(element);
                continue;
            }
            if (element.getTagName().equals("highFreqCorner")) {
                this.highFreqCorner = SodUtil.loadQuantity(element);
                continue;
            }
            if (element.getTagName().equals("numPoles")) {
                this.numPoles = Integer.parseInt(XMLUtil.getText((Element)element));
                continue;
            }
            if (!element.getTagName().equals("filterType")) continue;
            this.filterType = XMLUtil.getText((Element)element).equals("CAUSAL") ? 0 : 1;
        }
        if (this.lowFreqCorner.get_unit().isConvertableTo(UnitImpl.SECOND)) {
            this.lowFreqCorner = this.lowFreqCorner.inverse();
        }
        if (this.highFreqCorner.get_unit().isConvertableTo(UnitImpl.SECOND)) {
            this.highFreqCorner = this.highFreqCorner.inverse();
        }
        this.filter = new ButterworthFilter(this.lowFreqCorner.convertTo(UnitImpl.HERTZ).getValue(), this.highFreqCorner.convertTo(UnitImpl.HERTZ).getValue(), this.numPoles, this.filterType);
    }

    @Override
    public boolean isThreadSafe() {
        return true;
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        LocalSeismogramImpl[] out = new LocalSeismogramImpl[seismograms.length];
        for (int i = 0; i < seismograms.length; ++i) {
            out[i] = this.filter.apply(seismograms[i]);
        }
        return new WaveformResult(out, new StringTreeLeaf(this, true));
    }
}

