/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.hibernate.SeismogramFileRefDB;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.process.waveform.AbstractFileWriter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import java.io.File;
import java.io.Serializable;

public abstract class AbstractSeismogramWriter
extends AbstractFileWriter
implements WaveformProcess {
    protected boolean storeSeismogramsInDB = false;
    public static final String SVN_PARAM = "sod_phaseStoN_ttp";
    static long bytesWritten = 0L;
    public static final String COOKIE_PREFIX = "SeisFile_";

    public AbstractSeismogramWriter(String workingDir, String fileTemplate, String prefix, boolean storeSeismogramsInDB) throws ConfigurationException {
        super(workingDir, fileTemplate, prefix);
        this.storeSeismogramsInDB = storeSeismogramsInDB;
        new PrintlineVelocitizer(new String[]{fileTemplate});
    }

    @Override
    public WaveformResult accept(CacheEvent event, ChannelImpl channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, CookieJar cookieJar) throws Exception {
        if (cookieJar == null) {
            throw new NullPointerException("CookieJar cannot be null");
        }
        if (channel == null) {
            throw new NullPointerException("Channel cannot be null");
        }
        if (seismograms.length > 0) {
            this.removeExisting(event, channel, seismograms[0]);
            for (int i = 0; i < seismograms.length; ++i) {
                String loc = this.generate(event, channel, seismograms[i], i);
                File parent = new File(loc).getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    StringTreeLeaf reason = new StringTreeLeaf(this, false, "Unable to create directory " + parent);
                    return new WaveformResult(seismograms, reason);
                }
                this.write(loc, seismograms[i], channel, event);
                if (this.storeSeismogramsInDB) {
                    SeismogramFileRefDB.getSingleton().saveSeismogramToDatabase(event, channel, (SeismogramAttrImpl)seismograms[i], loc, this.getFileType());
                }
                cookieJar.put(AbstractSeismogramWriter.getCookieName(this.prefix, channel.get_id(), i), (Serializable)((Object)loc));
            }
        }
        return new WaveformResult(true, seismograms, this);
    }

    public abstract SeismogramFileTypes getFileType();

    public abstract void write(String var1, LocalSeismogramImpl var2, ChannelImpl var3, CacheEvent var4) throws Exception;

    public static void addBytesWritten(long bytes) {
        bytesWritten += bytes;
    }

    public static long getBytesWritten() {
        return bytesWritten;
    }

    public static String getCookieName(String prefix, ChannelId channel, int i) {
        return COOKIE_PREFIX + prefix + ChannelIdUtil.toString((ChannelId)channel) + "_" + i;
    }
}

