/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.AbstractEventPair;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.Arm;
import edu.sc.seis.sod.EventArm;
import edu.sc.seis.sod.EventNetworkPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.hibernate.StatefulEventDB;
import edu.sc.seis.sod.status.OutputScheduler;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaveformArm
extends Thread
implements Arm {
    boolean active = true;
    protected static MicroSecondDate lastECP = ClockUtil.now();
    AbstractWaveformRecipe recipe;
    private int processorNum;
    boolean lastWorkWasEvent = false;
    static int processorsWorking = 0;
    static int usedProcessorNum = 0;
    private static double retryPercentage = 0.01;
    private static double ecpPercentage = 1.0E-5;
    private static TimeInterval ECP_WINDOW = new TimeInterval(5.0, UnitImpl.MINUTE);
    private static final Logger logger = LoggerFactory.getLogger(WaveformArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.WaveformArm");

    public WaveformArm(int nextProcessorNum, AbstractWaveformRecipe waveformRecipe) {
        super("WaveformArm " + nextProcessorNum);
        this.recipe = waveformRecipe;
        this.processorNum = nextProcessorNum;
    }

    boolean possibleToContinue() {
        return Start.getEventArm().isActive() && !Start.isArmFailure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        logger.info("Starting WaveformArm");
        while (!Start.getNetworkArm().isInitialStartupFinished()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        try {
            while (true) {
                AbstractEventPair next = WaveformArm.getNext();
                while (next == null && (this.possibleToContinue() || SodDB.getSingleton().isENPTodo() || SodDB.getSingleton().isESPTodo() || SodDB.getSingleton().getNumWorkUnits(Standing.RETRY) != 0 || SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG) != 0 || SodDB.getSingleton().getNumWorkUnits(Standing.INIT) != 0)) {
                    block34: {
                        try {
                            Object object = Start.getEventArm();
                            synchronized (object) {
                                Start.getEventArm().notifyAll();
                            }
                            if (!this.possibleToContinue()) break block34;
                            object = Start.getEventArm().getWaveformArmSync();
                            synchronized (object) {
                                SodDB.rollback();
                                Start.getEventArm().getWaveformArmSync().wait(120000L);
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                    next = WaveformArm.getNext();
                }
                if (next == null) {
                    for (int i = 0; i < 5 && (next = WaveformArm.getNext()) == null; ++i) {
                        Thread.sleep(1000L);
                    }
                }
                if (next != null) {
                    WaveformArm.processorStartWork();
                    try {
                        next.run();
                    }
                    catch (Throwable t) {
                        SodDB.rollback();
                        next.update(t, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
                    }
                } else {
                    logger.debug("No work to do, quiting processing: " + this.possibleToContinue() + " " + (SodDB.getSingleton().getNumWorkUnits(Standing.RETRY) != 0) + " " + (SodDB.getSingleton().getNumWorkUnits(Standing.IN_PROG) != 0));
                    return;
                }
                SodDB.commit();
                WaveformArm.processorFinishWork();
                continue;
                break;
            }
            catch (Throwable t) {
                GlobalExceptionHandler.handle((Throwable)t);
                Start.armFailure(this, t);
                this.active = false;
                OutputScheduler outputScheduler = OutputScheduler.getDefault();
                synchronized (outputScheduler) {
                    OutputScheduler.getDefault().notify();
                }
            }
        }
        finally {
            this.active = false;
            OutputScheduler outputScheduler = OutputScheduler.getDefault();
            synchronized (outputScheduler) {
                OutputScheduler.getDefault().notify();
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected static synchronized AbstractEventPair getNext() {
        EventStationPair esp;
        double retryRandom = Math.random();
        AbstractEventChannelPair ecp = null;
        if (retryRandom < WaveformArm.getRetryPercentage() && (ecp = SodDB.getSingleton().getNextRetryECPFromCache()) != null) {
            return ecp;
        }
        if (retryRandom > ecpPercentage) {
            EventNetworkPair enp;
            if (SodDB.getSingleton().isESPTodo() && (esp = SodDB.getSingleton().getNextESPFromCache()) != null) {
                esp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                esp = (EventStationPair)SodDB.getSession().merge((Object)esp);
                return esp;
            }
            if (SodDB.getSingleton().isENPTodo() && (enp = SodDB.getSingleton().getNextENPFromCache()) != null) {
                enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                enp = (EventNetworkPair)SodDB.getSession().merge((Object)enp);
                return enp;
            }
        }
        if ((retryRandom < ecpPercentage || ClockUtil.now().subtract(lastECP).lessThan((QuantityImpl)ECP_WINDOW)) && (ecp = SodDB.getSingleton().getNextECP()) != null) {
            ecp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
            SodDB.commit();
            ecp = (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
            lastECP = ClockUtil.now();
            return ecp;
        }
        esp = SodDB.getSingleton().getNextESP();
        if (esp != null) {
            esp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
            SodDB.commit();
            SodDB.getSession().update((Object)esp);
            return esp;
        }
        EventNetworkPair enp = SodDB.getSingleton().getNextENP();
        if (enp != null) {
            enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
            SodDB.commit();
            SodDB.getSession().update((Object)enp);
            return enp;
        }
        StatefulEvent ev = StatefulEventDB.getSingleton().getNext(Standing.INIT);
        if (ev != null) {
            WaveformArm.createEventNetworkPairs(ev);
            enp = SodDB.getSingleton().getNextENP();
            if (enp != null) {
                enp.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                SodDB.commit();
                SodDB.getSession().update((Object)enp);
                return enp;
            }
        }
        return SodDB.getSingleton().getNextRetryECPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createEventNetworkPairs(StatefulEvent ev) {
        EventEffectiveTimeOverlap overlap;
        logger.debug("Work on event: " + ev.getDbid() + " " + EventUtil.getEventInfo((EventAccessOperations)ev));
        StatefulEventDB eventDb = StatefulEventDB.getSingleton();
        SodDB sodDb = SodDB.getSingleton();
        ev.setStatus(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
        eventDb.getSession().saveOrUpdate((Object)ev);
        eventDb.commit();
        eventDb.getSession().load((Object)ev, (Serializable)Integer.valueOf(ev.getDbid()));
        try {
            if (ev.get_preferred_origin().getOriginTime() == null) {
                throw new RuntimeException("otime is null " + ev.get_preferred_origin().getLocation());
            }
            overlap = new EventEffectiveTimeOverlap(ev);
        }
        catch (NoPreferredOrigin e) {
            throw new RuntimeException("Should never happen...", e);
        }
        List<NetworkAttrImpl> networks = Start.getNetworkArm().getSuccessfulNetworks();
        if (networks.size() == 0 && !Start.isArmFailure()) {
            throw new RuntimeException("No successful networks!");
        }
        int numENP = 0;
        ArrayList<EventNetworkPair> enpList = new ArrayList<EventNetworkPair>();
        for (NetworkAttrImpl net : networks) {
            if (overlap.overlaps((NetworkAttr)net)) {
                EventNetworkPair p;
                try {
                    p = new EventNetworkPair(ev, NetworkDB.getSingleton().getNetwork(net.getDbid()));
                }
                catch (NotFound e) {
                    throw new RuntimeException("Should never happen, but I guess it just did!", e);
                }
                enpList.add(p);
                ++numENP;
                logger.debug("Put EventNetworkPair: " + p);
                continue;
            }
            failLogger.info("Network " + NetworkIdUtil.toStringNoDates((NetworkAttr)net) + " does not overlap event " + (Object)((Object)ev));
        }
        logger.debug("Insert " + numENP + " EventNetworkPairs for " + (Object)((Object)ev));
        Class<WaveformArm> i$ = WaveformArm.class;
        synchronized (WaveformArm.class) {
            ev.setStatus(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
            for (EventNetworkPair pair : enpList) {
                SodDB.getSession().save((Object)pair);
            }
            eventDb.commit();
            sodDb.offerEventNetworkPairs(enpList);
            // ** MonitorExit[i$] (shouldn't be in output)
            Start.getEventArm().change(ev);
            int numWaiting = eventDb.getNumWaiting();
            if (numWaiting < EventArm.MIN_WAIT_EVENTS) {
                logger.debug("There are less than " + EventArm.MIN_WAIT_EVENTS + " waiting events.  Telling the eventArm to start up again");
                EventArm eventArm = Start.getEventArm();
                synchronized (eventArm) {
                    Start.getEventArm().notifyAll();
                }
            }
            return;
        }
    }

    public int getProcessorNum() {
        return this.processorNum;
    }

    public static int getProcessorsWorking() {
        return processorsWorking;
    }

    static void processorStartWork() {
        ++processorsWorking;
    }

    static void processorFinishWork() {
        --processorsWorking;
    }

    static int nextProcessorNum() {
        return usedProcessorNum++;
    }

    private static double getRetryPercentage() {
        return retryPercentage;
    }
}

