/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.RequestFilterUtil;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.AbstractEventChannelPair;
import edu.sc.seis.sod.AbstractWaveformRecipe;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.CookieJar;
import edu.sc.seis.sod.EventVectorPair;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.Threadable;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.vector.ANDWaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcess;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorProcessWrapper;
import edu.sc.seis.sod.process.waveform.vector.WaveformVectorResult;
import edu.sc.seis.sod.source.seismogram.DataCenterSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSource;
import edu.sc.seis.sod.source.seismogram.SeismogramSourceLocator;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.status.waveformArm.WaveformMonitor;
import edu.sc.seis.sod.subsetter.Subsetter;
import edu.sc.seis.sod.subsetter.availableData.AvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.availableData.vector.ANDAvailableDataWrapper;
import edu.sc.seis.sod.subsetter.availableData.vector.ORAvailableDataWrapper;
import edu.sc.seis.sod.subsetter.availableData.vector.VectorAvailableDataSubsetter;
import edu.sc.seis.sod.subsetter.eventChannel.PassEventChannel;
import edu.sc.seis.sod.subsetter.eventChannel.vector.EventVectorSubsetter;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.subsetter.request.PassRequest;
import edu.sc.seis.sod.subsetter.request.RequestSubsetter;
import edu.sc.seis.sod.subsetter.request.vector.ANDRequestWrapper;
import edu.sc.seis.sod.subsetter.request.vector.VectorRequestSubsetter;
import edu.sc.seis.sod.subsetter.requestGenerator.RequestGenerator;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.RequestGeneratorWrapper;
import edu.sc.seis.sod.subsetter.requestGenerator.vector.VectorRequestGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.LazyInitializationException;
import org.omg.CORBA.SystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MotionVectorArm
extends AbstractWaveformRecipe
implements Subsetter {
    private boolean firstRequest = true;
    private EventVectorSubsetter eventChannelGroup = new PassEventChannel();
    private VectorRequestGenerator requestGenerator;
    private VectorRequestSubsetter request = new PassRequest();
    private static final VectorAvailableDataSubsetter defaultVectorAvailableData = new ORAvailableDataWrapper(defaultAvailableDataSubsetter);
    private VectorAvailableDataSubsetter availData = defaultVectorAvailableData;
    private LinkedList<WaveformVectorProcess> processes = new LinkedList();
    private static final Logger logger = LoggerFactory.getLogger(MotionVectorArm.class);
    private static final Logger failLogger = LoggerFactory.getLogger((String)"Fail.WaveformVector");

    public MotionVectorArm(Element config) throws ConfigurationException {
        this.processConfig(config);
    }

    public void add(WaveformVectorProcess process) {
        this.processes.add(process);
    }

    @Override
    public void add(WaveformProcess proc) {
        this.add(new ANDWaveformProcessWrapper(proc));
    }

    public VectorRequestGenerator getRequestGenerator() {
        return this.requestGenerator;
    }

    public WaveformVectorProcess[] getProcesses() {
        WaveformVectorProcess[] result = new WaveformVectorProcess[this.processes.size()];
        return this.processes.toArray(result);
    }

    public WaveformProcess[] getWaveformProcesses() {
        List waveformProcesses = this.getWaveformProcesses(this.getProcesses());
        return waveformProcesses.toArray(new WaveformProcess[0]);
    }

    public List getWaveformProcesses(WaveformVectorProcess[] procs) {
        ArrayList<WaveformProcess> waveformProcesses = new ArrayList<WaveformProcess>();
        for (int i = 0; i < procs.length; ++i) {
            if (procs[i] instanceof WaveformVectorProcessWrapper) {
                WaveformVectorProcess[] subProcesses = ((WaveformVectorProcessWrapper)procs[i]).getWrappedProcessors();
                waveformProcesses.addAll(this.getWaveformProcesses(subProcesses));
                continue;
            }
            if (!(procs[i] instanceof WaveformProcessWrapper)) continue;
            WaveformProcessWrapper wrapper = (WaveformProcessWrapper)procs[i];
            waveformProcesses.add(wrapper.getWrappedProcess());
        }
        return waveformProcesses;
    }

    @Override
    public void handle(Element el) throws ConfigurationException {
        Object sodObject = SodUtil.load(el, PACKAGES);
        if (sodObject instanceof EventStationSubsetter) {
            this.eventStation = (EventStationSubsetter)sodObject;
        } else if (sodObject instanceof WaveformMonitor) {
            this.addStatusMonitor((WaveformMonitor)sodObject);
        } else if (sodObject instanceof EventVectorSubsetter) {
            this.eventChannelGroup = (EventVectorSubsetter)sodObject;
        } else if (sodObject instanceof VectorRequestGenerator) {
            this.requestGenerator = (VectorRequestGenerator)sodObject;
        } else if (sodObject instanceof RequestGenerator) {
            this.requestGenerator = new RequestGeneratorWrapper((RequestGenerator)sodObject);
        } else if (sodObject instanceof VectorRequestSubsetter) {
            this.request = (VectorRequestSubsetter)sodObject;
        } else if (sodObject instanceof RequestSubsetter) {
            this.request = new ANDRequestWrapper((RequestSubsetter)sodObject);
        } else if (sodObject instanceof SeismogramSourceLocator) {
            this.dcLocator = (SeismogramSourceLocator)sodObject;
        } else if (sodObject instanceof VectorAvailableDataSubsetter) {
            this.availData = (VectorAvailableDataSubsetter)sodObject;
        } else if (sodObject instanceof AvailableDataSubsetter) {
            this.availData = new ANDAvailableDataWrapper((AvailableDataSubsetter)sodObject);
        } else if (sodObject instanceof WaveformVectorProcess) {
            this.add((WaveformVectorProcess)sodObject);
        } else if (sodObject instanceof WaveformProcess) {
            this.add((WaveformProcess)sodObject);
        } else {
            throw new ConfigurationException("Unknown tag in MotionVectorArm config. " + el.getLocalName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMotionVectorArm(EventVectorPair ecp) {
        StringTree passed;
        StatefulEvent eventAccess = ecp.getEvent();
        ChannelGroup channel = ecp.getChannelGroup();
        EventVectorSubsetter eventVectorSubsetter = this.eventChannelGroup;
        synchronized (eventVectorSubsetter) {
            try {
                passed = this.eventChannelGroup.accept(eventAccess, channel, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.EVENT_CHANNEL_SUBSETTER, e);
                return;
            }
        }
        if (passed.isSuccess()) {
            this.processRequestGeneratorSubsetter(ecp);
        } else {
            ecp.update(Status.get(Stage.EVENT_CHANNEL_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp + ": " + passed.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestGeneratorSubsetter(EventVectorPair ecp) {
        RequestFilter[][] infilters;
        VectorRequestGenerator vectorRequestGenerator = this.requestGenerator;
        synchronized (vectorRequestGenerator) {
            try {
                infilters = this.requestGenerator.generateRequest(ecp.getEvent(), ecp.getChannelGroup(), ecp.getCookieJar());
                boolean found = false;
                for (int i = 0; i < infilters.length; ++i) {
                    if (infilters[i].length == 0) continue;
                    found = true;
                }
                if (!found) {
                    logger.info("FAIL no request generated");
                    ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
                    return;
                }
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e);
                return;
            }
        }
        this.processRequestSubsetter(ecp, infilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequestSubsetter(EventVectorPair ecp, RequestFilter[][] infilters) {
        StringTree passed;
        VectorRequestSubsetter vectorRequestSubsetter = this.request;
        synchronized (vectorRequestSubsetter) {
            try {
                passed = this.request.accept(ecp.getEvent(), ecp.getChannelGroup(), infilters, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.REQUEST_SUBSETTER, e);
                return;
            }
        }
        if (this.getProcesses().length == 0 && this.availData.equals(defaultVectorAvailableData)) {
            if (this.firstRequest) {
                this.firstRequest = false;
                logger.info("No seismogram data center has been set, so no data is being requested.  If you're only generating BreqFast requests, this is fine.  Otherwise, it's probably an error.");
            }
            return;
        }
        if (passed.isSuccess()) {
            SeismogramSource dataCenter;
            SeismogramSourceLocator e = this.dcLocator;
            synchronized (e) {
                try {
                    dataCenter = this.dcLocator.getSeismogramSource(ecp.getEvent(), ecp.getChannelGroup().getChannels()[0], infilters[0], ecp.getCookieJar());
                }
                catch (Throwable e2) {
                    MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e2);
                    return;
                }
            }
            RequestFilter[][] outfilters = null;
            if (Start.getRunProps().isSkipAvailableData()) {
                outfilters = infilters;
            } else {
                outfilters = new RequestFilter[ecp.getChannelGroup().getChannels().length][];
                for (int i = 0; i < outfilters.length; ++i) {
                    logger.debug("Trying available_data for " + ChannelIdUtil.toString((ChannelId)infilters[0][0].channel_id) + " from " + infilters[0][0].start_time.date_time + " to " + infilters[0][0].end_time.date_time);
                    logger.debug("before available_data call");
                    try {
                        outfilters[i] = DataCenterSource.toArray(dataCenter.available_data(DataCenterSource.toList(infilters[i])));
                        logger.debug("after successful available_data call");
                    }
                    catch (SystemException e3) {
                        MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e3, dataCenter, MotionVectorArm.requestToString(infilters, null));
                        return;
                    }
                    if (outfilters[i].length != 0) {
                        logger.debug("Got available_data for " + ChannelIdUtil.toString((ChannelId)outfilters[i][0].channel_id) + " from " + outfilters[i][0].start_time.date_time + " to " + outfilters[i][0].end_time.date_time);
                        continue;
                    }
                    logger.debug("No available_data for " + ChannelIdUtil.toString((ChannelId)infilters[i][0].channel_id));
                }
            }
            this.processAvailableDataSubsetter(ecp, dataCenter, infilters, outfilters);
        } else {
            ecp.update(Status.get(Stage.REQUEST_SUBSETTER, Standing.REJECT));
            failLogger.info(ecp.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAvailableDataSubsetter(EventVectorPair ecp, SeismogramSource seismogramSource, RequestFilter[][] infilters, RequestFilter[][] outfilters) {
        StringTree result;
        VectorAvailableDataSubsetter vectorAvailableDataSubsetter = this.availData;
        synchronized (vectorAvailableDataSubsetter) {
            try {
                result = this.availData.accept(ecp.getEvent(), ecp.getChannelGroup(), infilters, outfilters, ecp.getCookieJar());
            }
            catch (Throwable e) {
                MotionVectorArm.handle(ecp, Stage.AVAILABLE_DATA_SUBSETTER, e);
                return;
            }
        }
        if (result.isSuccess()) {
            for (int i = 0; i < infilters.length; ++i) {
                for (int j = 0; j < infilters[i].length; ++j) {
                    logger.debug("Getting seismograms " + ChannelIdUtil.toString((ChannelId)infilters[i][j].channel_id) + " from " + infilters[i][j].start_time.date_time + " to " + infilters[i][j].end_time.date_time);
                }
            }
            MicroSecondDate before = new MicroSecondDate();
            LocalSeismogram[][] localSeismograms = new LocalSeismogram[ecp.getChannelGroup().getChannels().length][0];
            LocalSeismogramImpl[][] tempLocalSeismograms = new LocalSeismogramImpl[ecp.getChannelGroup().getChannels().length][0];
            try {
                localSeismograms = this.getData(ecp, infilters, seismogramSource);
                MicroSecondDate after = new MicroSecondDate();
                logger.info("After getting seismograms, time taken=" + after.subtract(before).convertTo(UnitImpl.SECOND) + "  " + localSeismograms[0].length + ", " + localSeismograms[1].length + ", " + localSeismograms[2].length);
                if (localSeismograms == null) {
                    return;
                }
            }
            catch (SystemException e) {
                MotionVectorArm.handle(ecp, Stage.DATA_RETRIEVAL, e, seismogramSource, MotionVectorArm.requestToString(infilters, outfilters));
                return;
            }
            catch (FissuresException e) {
                MotionVectorArm.handle(ecp, Stage.DATA_RETRIEVAL, e, seismogramSource, MotionVectorArm.requestToString(infilters, outfilters));
                return;
            }
            for (int i = 0; i < localSeismograms.length; ++i) {
                ArrayList<LocalSeismogram> tempForCast = new ArrayList<LocalSeismogram>();
                for (int j = 0; j < localSeismograms[i].length; ++j) {
                    if (localSeismograms[i][j] == null) {
                        ecp.update(Status.get(Stage.DATA_RETRIEVAL, Standing.REJECT));
                        logger.error("Got null in seismogram array for channel " + i + " for " + ecp);
                        return;
                    }
                    ChannelImpl ecpChan = ecp.getChannelGroup().getChannels()[i];
                    if (!ChannelIdUtil.areEqual((ChannelId)localSeismograms[i][j].channel_id, (ChannelId)ecpChan.get_id())) {
                        logger.warn("Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString((ChannelId)ecpChan.get_id()) + " seis=" + ChannelIdUtil.toString((ChannelId)localSeismograms[i][j].channel_id));
                        localSeismograms[i][j].channel_id = ecpChan.get_id();
                    }
                    tempForCast.add(localSeismograms[i][j]);
                }
                tempLocalSeismograms[i] = tempForCast.toArray(new LocalSeismogramImpl[0]);
            }
            this.processSeismograms(ecp, seismogramSource, infilters, outfilters, tempLocalSeismograms);
        } else {
            if (ClockUtil.now().subtract(Start.getRunProps().getSeismogramLatency()).after((Date)ecp.getEvent().getOrigin().getTime())) {
                logger.info("Retry Reject, older than acceptible latency: " + Start.getRunProps().getSeismogramLatency() + " " + ecp);
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else if (ecp.getNumRetries() >= SodDB.getSingleton().getMaxRetries()) {
                logger.info("Retry Reject, at max retries: " + SodDB.getSingleton().getMaxRetries() + " " + ecp);
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.REJECT));
            } else {
                logger.info("Retry Retry, within acceptible latency: " + Start.getRunProps().getSeismogramLatency() + " " + ecp);
                ecp.update(Status.get(Stage.AVAILABLE_DATA_SUBSETTER, Standing.RETRY));
            }
            failLogger.info(ecp + " " + result + " on server " + seismogramSource);
        }
    }

    public void processSeismograms(EventVectorPair ecp, SeismogramSource seismogramSource, RequestFilter[][] infilters, RequestFilter[][] outfilters, LocalSeismogramImpl[][] localSeismograms) {
        WaveformVectorProcess processor = null;
        WaveformVectorResult result = new WaveformVectorResult(localSeismograms, new StringTreeLeaf(this, true));
        Iterator it = this.processes.iterator();
        try {
            while (it.hasNext() && result.isSuccess()) {
                processor = (WaveformVectorProcess)it.next();
                result = MotionVectorArm.runProcessorThreadCheck(processor, ecp.getEvent(), ecp.getChannelGroup(), infilters, outfilters, result.getSeismograms(), ecp.getCookieJar());
            }
            logger.debug("finished with " + ChannelIdUtil.toStringNoDates((ChannelId)ecp.getChannelGroup().getChannels()[0].get_id()) + " success=" + result.isSuccess());
            if (result.isSuccess()) {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.SUCCESS));
            } else {
                ecp.update(Status.get(Stage.PROCESSOR, Standing.REJECT));
                failLogger.info(ecp + " " + result.getReason());
            }
        }
        catch (Throwable e) {
            MotionVectorArm.handle(ecp, Stage.PROCESSOR, e, seismogramSource, MotionVectorArm.requestToString(infilters, outfilters));
            ecp.update(Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
            failLogger.info(ecp + " " + e);
        }
        logger.debug("finished with " + ChannelIdUtil.toStringNoDates((ChannelId)ecp.getChannelGroup().getChannels()[0].get_id()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaveformVectorResult runProcessorThreadCheck(WaveformVectorProcess processor, CacheEvent event, ChannelGroup channel, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        if (processor instanceof Threadable && ((Threadable)((Object)processor)).isThreadSafe()) {
            return MotionVectorArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
        }
        WaveformVectorProcess waveformVectorProcess = processor;
        synchronized (waveformVectorProcess) {
            return MotionVectorArm.internalRunProcessor(processor, event, channel, original, available, seismograms, cookieJar);
        }
    }

    private static WaveformVectorResult internalRunProcessor(WaveformVectorProcess processor, CacheEvent event, ChannelGroup channel, RequestFilter[][] original, RequestFilter[][] available, LocalSeismogramImpl[][] seismograms, CookieJar cookieJar) throws Exception {
        WaveformVectorResult result;
        try {
            result = processor.accept(event, channel, original, available, seismograms, cookieJar);
        }
        catch (FissuresException e) {
            if (e.getCause() instanceof CodecException) {
                result = new WaveformVectorResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
            }
            throw e;
        }
        catch (CodecException e) {
            result = new WaveformVectorResult(seismograms, new Fail((Object)processor, "Unable to decompress data", e));
        }
        return result;
    }

    private LocalSeismogram[][] getData(EventVectorPair ecp, RequestFilter[][] rf, SeismogramSource seismogramSource) throws FissuresException {
        LocalSeismogram[][] localSeismograms = new LocalSeismogram[rf.length][];
        for (int i = 0; i < rf.length; ++i) {
            if (rf[i].length != 0) {
                logger.debug("before retrieve_seismograms");
                localSeismograms[i] = DataCenterSource.toSeisArray(seismogramSource.retrieveData(DataCenterSource.toList(rf[i])));
                logger.debug("after successful retrieve_seismograms " + localSeismograms[i].length);
                if (localSeismograms[i].length <= 0 || ChannelIdUtil.areEqual((ChannelId)localSeismograms[i][0].channel_id, (ChannelId)rf[i][0].channel_id)) continue;
                logger.warn("X Channel id in returned seismogram doesn not match channelid in request. req=" + ChannelIdUtil.toString((ChannelId)rf[i][0].channel_id) + " seis=" + ChannelIdUtil.toString((ChannelId)localSeismograms[i][0].channel_id));
                continue;
            }
            logger.debug("Failed, retrieve data, no requestFilters for component " + i + " continuing with remaining components.");
            localSeismograms[i] = new LocalSeismogram[0];
        }
        return localSeismograms;
    }

    private String statusRequest(String id, ProxySeismogramDC dataCenter) throws FissuresException {
        int retries = 0;
        int MAX_RETRY = 5;
        while (retries < MAX_RETRY) {
            try {
                return dataCenter.request_status(id);
            }
            catch (SystemException e) {
                logger.debug("after failed request_status, retries=" + ++retries);
                if (retries < MAX_RETRY) {
                    logger.info("Caught CORBA exception, retrying..." + retries, (Throwable)e);
                    try {
                        Thread.sleep(1000 * retries);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (retries % 2 != 0) continue;
                    dataCenter.reset();
                    continue;
                }
                throw e;
            }
        }
        throw new RuntimeException("Should never happen");
    }

    private static void handle(EventVectorPair ecp, Stage stage, Throwable t) {
        MotionVectorArm.handle(ecp, stage, t, null, "");
    }

    protected static String requestToString(RequestFilter[][] in, RequestFilter[][] avail) {
        String message = "";
        message = message + "\n in=" + RequestFilterUtil.toString((RequestFilter[][])in);
        message = message + "\n avail=" + RequestFilterUtil.toString((RequestFilter[][])avail);
        return message;
    }

    protected static void handle(AbstractEventChannelPair ecp, Stage stage, Throwable t, SeismogramSource seismogramSource, String requestString) {
        block11: {
            try {
                if (t instanceof OutOfMemoryError) {
                    t.printStackTrace(System.err);
                    logger.error("", t);
                    break block11;
                }
                if (t instanceof SystemException) {
                    ecp.update(Status.get(stage, Standing.CORBA_FAILURE));
                    break block11;
                }
                ecp.update(t, Status.get(stage, Standing.SYSTEM_FAILURE));
                String message = "";
                if (t instanceof FissuresException) {
                    FissuresException f = (FissuresException)t;
                    message = message + f.the_error.error_code + " " + f.the_error.error_description;
                } else if (t instanceof SystemException) {
                    message = "Network or server problem, SOD will continue to retry this item periodically: (" + t.getClass().getName() + ") " + message;
                }
                try {
                    message = message + " " + ecp;
                }
                catch (LazyInitializationException lazy) {
                    message = message + "LazyInitializationException after exception, so I can't print the evp\n";
                }
                message = message + "Source=" + seismogramSource + "\n";
                message = message + "Request=" + requestString + "\n";
                if (t instanceof SystemException) {
                    logger.warn(message, t);
                } else {
                    failLogger.warn(message, t);
                }
            }
            catch (Throwable tt) {
                GlobalExceptionHandler.handle((String)("Caught " + tt + " while handling " + t), (Throwable)t);
            }
        }
    }
}

