/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.sod.AbstractEventPair;
import edu.sc.seis.sod.EventStationPair;
import edu.sc.seis.sod.Stage;
import edu.sc.seis.sod.Standing;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.Status;
import edu.sc.seis.sod.WaveformArm;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.StatefulEvent;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNetworkPair
extends AbstractEventPair {
    private NetworkAttrImpl networkAttr;
    private static final Logger logger = LoggerFactory.getLogger(EventNetworkPair.class);

    protected EventNetworkPair() {
    }

    public EventNetworkPair(StatefulEvent event, NetworkAttrImpl net) {
        this(event, net, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
    }

    public EventNetworkPair(StatefulEvent event, NetworkAttrImpl net, Status status) {
        super(event, status);
        this.setNetwork(net);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<EventStationPair> staPairList = new ArrayList<EventStationPair>();
        try {
            int i;
            EventEffectiveTimeOverlap overlap = new EventEffectiveTimeOverlap(this.getEvent());
            StationImpl[] stations = Start.getNetworkArm().getSuccessfulStations(this.getNetwork());
            logger.debug("Begin EventNetworkPair (" + this.getEvent().getDbid() + ",s " + this.getNetworkDbId() + ") " + this);
            logger.debug(stations.length + " successful stations for " + this);
            for (i = 0; i < stations.length; ++i) {
                logger.debug("Station successful (" + stations[i].getDbid() + ") " + StationIdUtil.toString((Station)stations[i]));
            }
            for (i = 0; i < stations.length; ++i) {
                EventStationPair p;
                if (!overlap.overlaps((Station)stations[i])) {
                    failLogger.info(StationIdUtil.toString((StationId)stations[i].get_id()) + "'s station effective time does not overlap the event time.");
                    continue;
                }
                try {
                    p = new EventStationPair(this.getEvent(), NetworkDB.getSingleton().getStation(stations[i].getDbid()));
                }
                catch (NotFound e) {
                    throw new RuntimeException("Should never happen but I guess it did!", e);
                }
                staPairList.add(p);
            }
            Class<WaveformArm> clazz = WaveformArm.class;
            synchronized (WaveformArm.class) {
                this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
                for (EventStationPair p : staPairList) {
                    SodDB.getSession().save((Object)p);
                }
                SodDB.commit();
                // ** MonitorExit[var4_6] (shouldn't be in output)
                SodDB.getSingleton().offerEventStationPair(staPairList);
            }
        }
        catch (NoPreferredOrigin e) {
            GlobalExceptionHandler.handle((Throwable)e);
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
            failLogger.warn(this.toString(), (Throwable)e);
        }
        finally {
            SodDB.rollback();
        }
        {
            logger.debug("End EventNetworkPair (" + this.getEvent().getDbid() + ",s " + this.getNetworkDbId() + ") " + this);
            return;
        }
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        Start.getWaveformRecipe().setStatus(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventNetworkPair)) {
            return false;
        }
        EventNetworkPair ecp = (EventNetworkPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getNetworkDbId() == this.getNetworkDbId();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getNetworkDbId();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        return "EventNetworkPair: (" + this.getDbid() + ") " + (Object)((Object)this.getEvent()) + " " + NetworkIdUtil.toStringNoDates((NetworkAttr)this.getNetwork()) + " " + this.getStatus();
    }

    public int getNetworkDbId() {
        return this.getNetwork().getDbid();
    }

    public NetworkAttrImpl getNetwork() {
        return this.networkAttr;
    }

    protected void setNetwork(NetworkAttrImpl attr) {
        this.networkAttr = attr;
    }
}

