/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.Orientation;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.NetworkAttrImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.fissuresUtil.bag.OrientationUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.ChannelGroup;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.NetworkArm;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import edu.sc.seis.sod.subsetter.network.NetworkSubsetter;
import edu.sc.seis.sod.subsetter.station.StationSubsetter;
import edu.sc.seis.sod.validator.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ChannelGrouper {
    private static Logger logger = LoggerFactory.getLogger(ChannelGrouper.class);
    private Element[] defaultRules = this.loadRules(defaultConfigFileLoc);
    private Element[] additionalRules;
    private static String defaultConfigFileLoc = "jar:edu/sc/seis/sod/data/grouper.xml";
    private static final String grouperSchemaLoc = "edu/sc/seis/sod/data/grouper.rng";

    public ChannelGrouper() {
        this(null);
    }

    public ChannelGrouper(String configFileLoc) {
        this.additionalRules = this.loadRules(configFileLoc);
    }

    public List<ChannelGroup> group(List<ChannelImpl> channels, List<ChannelImpl> failures) {
        int ruleCount = this.defaultRules.length + this.additionalRules.length;
        Element[] allRules = new Element[ruleCount];
        for (int j = 0; j < this.additionalRules.length; ++j) {
            allRules[j] = this.additionalRules[j];
        }
        for (int k = this.additionalRules.length; k < ruleCount; ++k) {
            allRules[k] = this.defaultRules[k - this.additionalRules.length];
        }
        return this.applyRules(channels, allRules, failures);
    }

    private List<ChannelGroup> applyRules(List<ChannelImpl> channels, Element[] rules, List<ChannelImpl> failures) {
        LinkedList<ChannelGroup> groupableChannels = new LinkedList<ChannelGroup>();
        HashMap<String, List<ChannelImpl>> bandGain = this.groupByBandGain(channels);
        for (String key : bandGain.keySet()) {
            List<ChannelImpl> chn = bandGain.get(key);
            ArrayList<ChannelImpl> failedList = new ArrayList<ChannelImpl>();
            List<ChannelGroup> channelList = this.getGroupableChannels(chn, rules, failedList);
            failures.addAll(failedList);
            if (channelList.size() <= 0) continue;
            groupableChannels.addAll(channelList);
        }
        return groupableChannels;
    }

    private List<ChannelGroup> getGroupableChannels(List<ChannelImpl> chn, Element[] rules, List<ChannelImpl> failedList) {
        ArrayList<ChannelGroup> groupableChannels;
        block15: {
            groupableChannels = new ArrayList<ChannelGroup>();
            try {
                HashMap<String, ChannelImpl> channelMap = new HashMap<String, ChannelImpl>();
                for (ChannelImpl channelImpl : chn) {
                    String key = ChannelIdUtil.toStringNoDates((ChannelId)channelImpl.get_id());
                    key = key.substring(key.length() - 1, key.length());
                    channelMap.put(key, channelImpl);
                }
                if (rules == null) break block15;
                for (int ruleCnt = 0; ruleCnt < rules.length; ++ruleCnt) {
                    NodeList children = rules[ruleCnt].getChildNodes();
                    boolean accept = true;
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node node = children.item(i);
                        if (!accept || !(node instanceof Element)) continue;
                        Element el = (Element)node;
                        if (el.getTagName().equals("threeCharacterRule")) {
                            ChannelGroup successfulChannels;
                            String orientationCodes = SodUtil.getNestedText(el);
                            char[] codes = orientationCodes.trim().toCharArray();
                            ArrayList channelGroup = new ArrayList();
                            for (int codeCount = 0; codeCount < codes.length; ++codeCount) {
                                if (channelMap.get("" + codes[codeCount]) == null) continue;
                                channelGroup.add(channelMap.get("" + codes[codeCount]));
                            }
                            if (channelGroup.size() != 3 || !ChannelGrouper.sanityCheck(successfulChannels = new ChannelGroup(channelGroup.toArray(new ChannelImpl[0])))) continue;
                            groupableChannels.add(successfulChannels);
                            ChannelImpl[] chans = successfulChannels.getChannels();
                            for (int count = 0; count < chans.length; ++count) {
                                chn.remove(chans[count]);
                                channelMap.remove(chans[count]);
                            }
                            continue;
                        }
                        Object subsetter = SodUtil.load(el, NetworkArm.PACKAGES);
                        if (subsetter instanceof NetworkSubsetter) {
                            NetworkId netId = chn.get((int)0).get_id().network_id;
                            List<NetworkAttrImpl> networks = Start.getNetworkArm().getSuccessfulNetworks();
                            NetworkAttrImpl netAttr = null;
                            for (NetworkAttrImpl net : networks) {
                                NetworkSubsetter netSubsetter;
                                if (NetworkIdUtil.areEqual((NetworkId)net.get_id(), (NetworkId)netId)) {
                                    netAttr = net;
                                }
                                if ((netSubsetter = (NetworkSubsetter)subsetter).accept(netAttr).isSuccess()) continue;
                                accept = false;
                            }
                            continue;
                        }
                        if (subsetter instanceof StationSubsetter) {
                            StationSubsetter stationSubsetter;
                            if (!accept || (stationSubsetter = (StationSubsetter)subsetter).accept((StationImpl)chn.get(0).getSite().getStation(), Start.getNetworkArm().getNetworkSource()).isSuccess()) continue;
                            accept = false;
                            continue;
                        }
                        if (!(subsetter instanceof ChannelSubsetter) || !accept) continue;
                        ChannelSubsetter channelSubsetter = (ChannelSubsetter)subsetter;
                        for (ChannelImpl channelImpl : chn) {
                            if (channelSubsetter.accept(channelImpl, Start.getNetworkArm().getNetworkSource()).isSuccess()) continue;
                            accept = false;
                        }
                    }
                }
                if (chn.size() > 0) {
                    failedList.addAll(chn);
                }
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Error while loading Sod element in grouper", (Throwable)e);
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Exception while grouping channels", (Throwable)e);
            }
        }
        return groupableChannels;
    }

    public static boolean sanityCheck(ChannelGroup channelGroup) {
        return ChannelGrouper.haveSameSamplingRate(channelGroup) && ChannelGrouper.areOrthogonal(channelGroup);
    }

    private static boolean areOrthogonal(ChannelGroup channelGroup) {
        ChannelImpl[] chans = channelGroup.getChannels();
        for (int i = 0; i < chans.length; ++i) {
            for (int j = i + 1; j < chans.length; ++j) {
                if (OrientationUtil.areOrthogonal((Orientation)chans[i].getOrientation(), (Orientation)chans[j].getOrientation())) continue;
                logger.info("Fail areOrthogonal (" + i + "," + j + "): " + ChannelIdUtil.toString((ChannelId)chans[i].get_id()) + " " + OrientationUtil.toString((Orientation)chans[i].getOrientation()) + " " + ChannelIdUtil.toString((ChannelId)chans[j].get_id()) + " " + OrientationUtil.toString((Orientation)chans[j].getOrientation()));
                return false;
            }
        }
        return true;
    }

    private static boolean haveSameSamplingRate(ChannelGroup cg) {
        ChannelImpl[] chans = cg.getChannels();
        SamplingImpl sampl = (SamplingImpl)chans[0].getSamplingInfo();
        QuantityImpl freq = sampl.getFrequency();
        UnitImpl baseUnit = freq.getUnit();
        double samplingRate0 = freq.getValue() * (double)sampl.getNumPoints();
        for (int i = 1; i < chans.length; ++i) {
            SamplingImpl sample = (SamplingImpl)chans[i].getSamplingInfo();
            double sampleRate = sample.getFrequency().convertTo(baseUnit).getValue() * (double)sample.getNumPoints();
            if (sampleRate == samplingRate0) continue;
            logger.info("Fail haveSameSamplingRate (" + i + "): " + ChannelIdUtil.toString((ChannelId)chans[i].get_id()) + " " + chans[i].getSamplingInfo() + " " + ChannelIdUtil.toString((ChannelId)chans[0].get_id()) + " " + chans[0].getSamplingInfo());
            return false;
        }
        return true;
    }

    private HashMap<String, List<ChannelImpl>> groupByBandGain(List<ChannelImpl> channels) {
        HashMap<String, List<ChannelImpl>> bandGain = new HashMap<String, List<ChannelImpl>>();
        for (ChannelImpl c : channels) {
            MicroSecondDate msd = new MicroSecondDate(c.get_id().begin_time);
            String key = ChannelIdUtil.toStringNoDates((ChannelId)c.get_id());
            key = key.substring(0, key.length() - 1);
            key = msd + key;
            List<ChannelImpl> chans = bandGain.get(key);
            if (chans == null) {
                chans = new LinkedList<ChannelImpl>();
                bandGain.put(key, chans);
            }
            chans.add(c);
        }
        return bandGain;
    }

    private Element[] loadRules(String configFileLoc) {
        if (configFileLoc == null) {
            return new Element[0];
        }
        Validator validator = new Validator(grouperSchemaLoc);
        Element[] rules = null;
        try {
            if (!validator.validate(this.getRules(configFileLoc))) {
                logger.info("Invalid config file!");
            } else {
                Document doc = Start.createDoc(this.getRules(configFileLoc), configFileLoc);
                NodeList ruleList = doc.getElementsByTagName("rule");
                rules = new Element[ruleList.getLength()];
                for (int i = 0; i < ruleList.getLength(); ++i) {
                    rules[i] = (Element)ruleList.item(i);
                }
            }
        }
        catch (ParserConfigurationException e) {
            GlobalExceptionHandler.handle((String)("Invalid config File " + configFileLoc + " for Channel Grouper"), (Throwable)e);
            return new Element[0];
        }
        catch (SAXException e) {
            GlobalExceptionHandler.handle((String)("Invalid config File " + configFileLoc + " for Channel Grouper"), (Throwable)e);
            return new Element[0];
        }
        catch (IOException e) {
            GlobalExceptionHandler.handle((String)("Config File for Channel Grouper " + configFileLoc + " not found "), (Throwable)e);
            return new Element[0];
        }
        return rules;
    }

    private InputSource getRules(String configFileLoc) throws IOException {
        ClassLoader loader = ChannelGrouper.class.getClassLoader();
        return Start.createInputSource(loader, configFileLoc);
    }
}

