/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.network;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.CoefficientFilter;
import edu.iris.Fissures.IfNetwork.Filter;
import edu.iris.Fissures.IfNetwork.Instrumentation;
import edu.iris.Fissures.IfNetwork.ListFilter;
import edu.iris.Fissures.IfNetwork.PoleZeroFilter;
import edu.iris.Fissures.IfNetwork.Response;
import edu.iris.Fissures.IfNetwork.Sensitivity;
import edu.iris.Fissures.IfNetwork.Stage;
import edu.iris.Fissures.IfNetwork.TransferType;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.UnitImpl;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.TimeZone;

public class ResponsePrint {
    private static HashMap unitNames = new HashMap();

    public static String printResponse(ChannelId chanId, Instrumentation inst) {
        TimeRange effective_time = inst.effective_time;
        Response response = inst.the_response;
        return ResponsePrint.printResponse(chanId, response, effective_time);
    }

    public static String printResponse(ChannelId chanId, Response response, TimeRange effective_time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy,DDD,HH:mm:ss");
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        MicroSecondDate stime = new MicroSecondDate(effective_time.start_time);
        MicroSecondDate etime = new MicroSecondDate(effective_time.end_time);
        Sensitivity sensitivity = response.the_sensitivity;
        StringBuffer r = new StringBuffer();
        r.append("\n#");
        r.append("\n###################################################################################");
        r.append("\n#");
        r.append("\nB050F03     Station:       " + chanId.station_code);
        r.append("\nB050F16     Network:       " + chanId.network_id.network_code);
        r.append("\nB052F03     Location:      " + chanId.site_code);
        r.append("\nB052F04     Channel:       " + chanId.channel_code);
        r.append("\nB052F22     Start date:    " + sdf.format(stime));
        r.append("\nB052F23     End date:      " + sdf.format(etime));
        for (int i = 0; i < response.stages.length; ++i) {
            int stageNum = i + 1;
            Stage stage = response.stages[i];
            if (stage.filters.length <= 0) continue;
            r.append(ResponsePrint.printB53(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB54(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB55(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB57(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB58(chanId, effective_time, stageNum, stage));
        }
        r.append(ResponsePrint.printSensitivity(chanId, sensitivity, effective_time));
        return r.toString();
    }

    public static String printHeader(ChannelId id, TimeRange effective_time) {
        StringBuffer s = new StringBuffer("");
        s.append("#                   |        " + id.network_id.network_code + "  ");
        if (id.station_code.length() == 5) {
            s.append(id.station_code + " ");
        }
        if (id.station_code.length() == 4) {
            s.append(id.station_code + "  ");
        }
        if (id.station_code.length() == 3) {
            s.append(id.station_code + "   ");
        }
        if (id.station_code.length() == 2) {
            s.append(id.station_code + "    ");
        }
        if (id.site_code.length() == 1) {
            s.append(id.site_code + "  ");
        }
        if (id.site_code.length() == 2) {
            s.append(id.site_code + " ");
        }
        s.append(id.channel_code + "           |\n");
        MicroSecondDate stime = new MicroSecondDate(effective_time.start_time);
        MicroSecondDate etime = new MicroSecondDate(effective_time.end_time);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        s.append("#                   |     " + sdf.format(stime));
        s.append(" to " + sdf.format(etime) + "      |\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#\n");
        return s.toString();
    }

    public static String printB53(ChannelId id, TimeRange effective_time, int stageNum, Stage stage) {
        int k;
        Filter filter = stage.filters[0];
        if (filter.discriminator().value() != 1) {
            return "";
        }
        String transferType = "";
        if (stage.type == TransferType.LAPLACE) {
            transferType = "A";
        } else if (stage.type == TransferType.ANALOG) {
            transferType = "B";
        } else if (stage.type == TransferType.COMPOSITE) {
            transferType = "C";
        } else if (stage.type == TransferType.DIGITAL) {
            transferType = "D";
        }
        PoleZeroFilter pz = filter.pole_zero_filter();
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00");
        DecimalFormat ind = new DecimalFormat(" 0");
        StringBuffer s = new StringBuffer("\n#");
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |     Response (Poles and Zeros)    |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B053F03     Transfer function type:            " + transferType);
        s.append("\nB053F04     Stage sequence number:             " + stageNum);
        s.append("\nB053F05     Response in units lookup:          " + ResponsePrint.formatUnit(stage.input_units));
        s.append("\nB053F06     Response out units lookup:         " + ResponsePrint.formatUnit(stage.output_units));
        s.append("\nB053F07     AO normalization factor:           ");
        if (stage.the_normalization.length == 1) {
            s.append(f.format(stage.the_normalization[0].ao_normalization_factor));
        } else {
            s.append("1.0");
        }
        s.append("\nB053F08     Normalization frequency:           ");
        if (stage.the_normalization.length == 1) {
            s.append(f.format(stage.the_normalization[0].normalization_freq));
        } else {
            s.append("1.0");
        }
        s.append("\nB053F09     Number of zeroes:                  " + pz.zeros.length);
        s.append("\nB053F14     Number of poles:                   " + pz.poles.length);
        if (pz.zeros.length > 0) {
            s.append("\n#              Complex zeroes:");
            s.append("\n#               i  real          imag          real_error    imag_error");
            for (k = 0; k < pz.zeros.length; ++k) {
                if (k < 10) {
                    s.append("\nB053F10-13      " + k + "  " + f.format(pz.zeros[k].real) + "  " + f.format(pz.zeros[k].imaginary) + "  " + f.format(pz.zeros[k].real_error) + "  " + f.format(pz.zeros[k].imaginary_error));
                    continue;
                }
                s.append("\nB053F10-13     " + k + "  " + f.format(pz.zeros[k].real) + "  " + f.format(pz.zeros[k].imaginary) + "  " + f.format(pz.zeros[k].real_error) + "  " + f.format(pz.zeros[k].imaginary_error));
            }
        }
        if (pz.poles.length > 0) {
            s.append("\n#              Complex poles:");
            s.append("\n#               i  real          imag          real_error    imag_error");
            for (k = 0; k < pz.poles.length; ++k) {
                if (k < 10) {
                    s.append("\nB053F15-18      " + k + "  " + f.format(pz.poles[k].real) + "  " + f.format(pz.poles[k].imaginary) + "  " + f.format(pz.poles[k].real_error) + "  " + f.format(pz.poles[k].imaginary_error));
                    continue;
                }
                s.append("\nB053F15-18     " + k + "  " + f.format(pz.poles[k].real) + "  " + f.format(pz.poles[k].imaginary) + "  " + f.format(pz.poles[k].real_error) + "  " + f.format(pz.poles[k].imaginary_error));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB54(ChannelId id, TimeRange effective_time, int stageNum, Stage stage) {
        int k;
        Filter filter = stage.filters[0];
        if (filter.discriminator().value() != 0) {
            return "";
        }
        StringBuffer s = new StringBuffer("\n#");
        String transferType = "";
        if (stage.type == TransferType.ANALOG) {
            transferType = "A";
        } else if (stage.type == TransferType.COMPOSITE) {
            transferType = "C";
        } else if (stage.type == TransferType.DIGITAL) {
            transferType = "D";
        }
        CoefficientFilter c = filter.coeff_filter();
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |       Response (Coefficients)     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B054F03     Transfer function type:            " + transferType);
        s.append("\nB054F04     Stage sequence number:             " + stageNum);
        s.append("\nB054F05     Response in units lookup:          " + ResponsePrint.formatUnit(stage.input_units));
        s.append("\nB054F06     Response out units lookup:         " + ResponsePrint.formatUnit(stage.output_units));
        s.append("\nB054F07     Number of numerators:              " + c.numerator.length);
        s.append("\nB054F10     Number of denominators:            " + c.denominator.length);
        s.append("\n#");
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00");
        if (c.numerator.length > 0) {
            s.append("\n#              Numerator coefficients:");
            s.append("\n#               i  coefficient   error");
            for (k = 0; k < c.numerator.length; ++k) {
                if (k < 10) {
                    s.append("\nB054F08-09      " + k + "  " + f.format(c.numerator[k].value) + "  " + f.format(c.numerator[k].error));
                    continue;
                }
                s.append("\nB054F08-09     " + k + "  " + f.format(c.numerator[k].value) + "  " + f.format(c.numerator[k].error));
            }
        }
        if (c.denominator.length > 0) {
            s.append("\n#              Denominator coefficients:");
            s.append("\n#               i  coefficient   error");
            for (k = 0; k < c.denominator.length; ++k) {
                if (k < 10) {
                    s.append("\nB054F11-12      " + k + "  " + f.format(c.denominator[k].value) + "  " + f.format(c.denominator[k].error));
                    continue;
                }
                s.append("\nB054F11-12     " + k + "  " + f.format(c.denominator[k].value) + "  " + f.format(c.denominator[k].error));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB55(ChannelId id, TimeRange effective_time, int stageNum, Stage stage) {
        Filter filter = stage.filters[0];
        if (filter.discriminator().value() != 2) {
            return "";
        }
        StringBuffer s = new StringBuffer("\n#");
        ListFilter c = filter.list_filter();
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |       Response List               |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("\nB055F03     Stage sequence number:             " + stageNum);
        s.append("\nB055F04     Response in units lookup:          " + ResponsePrint.formatUnit(stage.input_units));
        s.append("\nB055F05     Response out units lookup:         " + ResponsePrint.formatUnit(stage.output_units));
        s.append("\nB055F06     Number of responses listed:        " + c.frequency.length);
        s.append("\n#");
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00");
        DecimalFormat ind = new DecimalFormat(" 0");
        if (c.frequency.length > 0) {
            s.append("\n#              i  frequency     amplitude     amplitude err phase angle   phase err");
            for (int k = 0; k < c.frequency.length; ++k) {
                if (k < 10) {
                    s.append("\nB055F07-11      " + k);
                } else {
                    s.append("\nB055F07-11     " + k);
                }
                s.append("  " + f.format(c.frequency[k]));
                s.append("  " + f.format(c.amplitude[k]));
                s.append("  " + f.format(c.amplitude_error[k]));
                s.append("  " + f.format(c.phase[k]));
                s.append("  " + f.format(c.phase_error[k]));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB57(ChannelId id, TimeRange effective_time, int stageNum, Stage stage) {
        if (stage.the_decimation.length == 0) {
            return "";
        }
        DecimalFormat f = new DecimalFormat("+0.0000E00;-0.0000E00");
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |             Decimation            |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B057F03     Stage sequence number:             " + stageNum);
        s.append("\nB057F04     Input sample rate (HZ):            " + f.format(stage.the_decimation[0].input_rate.numPoints));
        s.append("\nB057F05     Decimation factor:                 " + stage.the_decimation[0].factor);
        s.append("\nB057F06     Decimation offset:                 " + stage.the_decimation[0].offset);
        s.append("\nB057F07     Estimated delay (seconds):         " + f.format(stage.the_decimation[0].estimated_delay.value));
        s.append("\nB057F08     Correction applied (seconds):      " + f.format(stage.the_decimation[0].correction_applied.value));
        s.append("\n#");
        return s.toString();
    }

    public static String printB58(ChannelId id, TimeRange effective_time, int stageNum, Stage stage) {
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00");
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |      Channel Sensitivity/Gain     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B058F03     Stage sequence number:             " + stageNum);
        s.append("\nB058F04     Sensitivity:                       " + f.format(stage.the_gain.gain_factor));
        s.append("\nB058F05     Frequency of sensitivity:          " + f.format(stage.the_gain.frequency));
        s.append("\nB058F06     Number of calibrations:            0\n");
        return s.toString();
    }

    public static String printSensitivity(ChannelId id, Instrumentation inst) {
        return ResponsePrint.printSensitivity(id, inst.the_response.the_sensitivity, inst.effective_time);
    }

    public static String printSensitivity(ChannelId id, Sensitivity sensitivity, TimeRange effective_time) {
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |      Channel Sensitivity/Gain     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("#\n");
        s.append("B058F03     Stage sequence number:             0");
        s.append("\nB058F04     Sensitivity:                       " + sensitivity.sensitivity_factor);
        s.append("\nB058F05     Frequency of sensitivity:          " + sensitivity.frequency);
        s.append("\nB058F06     Number of calibrations:            0\n");
        return s.toString();
    }

    public static String printInstEffectiveTime(Instrumentation inst) {
        MicroSecondDate stime = new MicroSecondDate(inst.effective_time.start_time);
        MicroSecondDate etime = new MicroSecondDate(inst.effective_time.end_time);
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSSz");
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        sdf.setTimeZone(gmt);
        StringBuffer s = new StringBuffer("Instrument Effective Time:\n");
        s.append("  Starttime: " + sdf.format(stime) + "\n");
        s.append("  Endtime:   " + sdf.format(etime) + "\n");
        return s.toString();
    }

    public static String formatUnit(Unit unit) {
        if (unit == null) {
            return "null";
        }
        UnitImpl impl = UnitImpl.createUnitImpl(unit);
        for (UnitImpl key : unitNames.keySet()) {
            if (!impl.equals((Object)key)) continue;
            return (String)unitNames.get((Object)key);
        }
        return unit.toString();
    }

    public static void addToNameMap(UnitImpl unit, String name) {
        unitNames.put(unit, name);
    }

    static {
        ResponsePrint.addToNameMap(UnitImpl.VOLT, "V - Volts");
        ResponsePrint.addToNameMap(UnitImpl.COUNT, "COUNTS");
        ResponsePrint.addToNameMap(UnitImpl.METER_PER_SECOND, "M/S - Velocity in Meters/Second");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER, "NM");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER, "MM");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER, "CM");
        ResponsePrint.addToNameMap(UnitImpl.METER, "M");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER_PER_SECOND, "NM/S");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER_PER_SECOND, "MM/S");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER_PER_SECOND, "CM/S");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER_PER_SECOND_PER_SECOND, "NM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND, "MM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER_PER_SECOND_PER_SECOND, "CM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.METER_PER_SECOND_PER_SECOND, "M/S**2");
        ResponsePrint.addToNameMap(UnitImpl.PASCAL, "P");
        ResponsePrint.addToNameMap(UnitImpl.TESLA, "T");
    }
}

