/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UnitImpl
extends Unit {
    protected static int numPrimitives = UnitImpl.getNumPrimitives();
    public static final int YOTTA = 24;
    public static final int ZETTA = 21;
    public static final int EXA = 18;
    public static final int PETA = 15;
    public static final int TERA = 12;
    public static final int GIGA = 9;
    public static final int MEGA = 6;
    public static final int KILO = 3;
    public static final int HECTO = 2;
    public static final int DEKA = 1;
    public static final int NONE = 0;
    public static final int DECI = -1;
    public static final int CENTI = -2;
    public static final int MILLI = -3;
    public static final int MICRO = -6;
    public static final int NANO = -9;
    public static final int PICO = -12;
    public static final int FEMTO = -15;
    public static final int ATTO = -18;
    public static final int ZEPTO = -21;
    public static final int YOCTO = -24;
    public static final UnitImpl METER;
    public static final UnitImpl LENGTH;
    public static final UnitImpl KILOMETER;
    public static final UnitImpl CENTIMETER;
    public static final UnitImpl MILLIMETER;
    public static final UnitImpl MICROMETER;
    public static final UnitImpl MICRON;
    public static final UnitImpl NANOMETER;
    public static final UnitImpl PICOMETER;
    public static final UnitImpl INCH;
    public static final UnitImpl FOOT;
    public static final UnitImpl MILE;
    public static final UnitImpl YARD;
    public static final UnitImpl ROD;
    public static final UnitImpl FURLONG;
    public static final UnitImpl LEAGUE;
    public static final UnitImpl SECOND;
    public static final UnitImpl TIME;
    public static final UnitImpl MINUTE;
    public static final UnitImpl HOUR;
    public static final UnitImpl DAY;
    public static final UnitImpl WEEK;
    public static final UnitImpl FORTNIGHT;
    public static final UnitImpl YEAR;
    public static final UnitImpl LEAP_YEAR;
    public static final UnitImpl GREGORIAN_YEAR;
    public static final UnitImpl MILLISECOND;
    public static final UnitImpl TENTHMILLISECOND;
    public static final UnitImpl MICROSECOND;
    public static final UnitImpl NANOSECOND;
    public static final UnitImpl HERTZ;
    public static final UnitImpl SQUARE_METER;
    public static final UnitImpl AREA;
    public static final UnitImpl SQUARE_CENTIMETER;
    public static final UnitImpl CUBIC_METER;
    public static final UnitImpl VOLUME;
    public static final UnitImpl CUBIC_CENTIMETER;
    public static final UnitImpl LITER;
    public static final UnitImpl GRAM;
    public static final UnitImpl KILOGRAM;
    public static final UnitImpl MASS;
    public static final UnitImpl DENSITY;
    public static final UnitImpl GRAM_PER_CUBIC_CENTIMETER;
    public static final UnitImpl KILOGRAM_PER_CUBIC_METER;
    public static final UnitImpl VELOCITY;
    public static final UnitImpl METER_PER_SECOND;
    public static final UnitImpl KILOMETER_PER_SECOND;
    public static final UnitImpl CENTIMETER_PER_SECOND;
    public static final UnitImpl MILLIMETER_PER_SECOND;
    public static final UnitImpl MICROMETER_PER_SECOND;
    public static final UnitImpl MICRON_PER_SECOND;
    public static final UnitImpl NANOMETER_PER_SECOND;
    public static final UnitImpl METER_PER_SECOND_PER_SECOND;
    public static final UnitImpl ACCELERATION;
    public static final UnitImpl KILOMETER_PER_SECOND_PER_SECOND;
    public static final UnitImpl CENTIMETER_PER_SECOND_PER_SECOND;
    public static final UnitImpl MILLIMETER_PER_SECOND_PER_SECOND;
    public static final UnitImpl MICROMETER_PER_SECOND_PER_SECOND;
    public static final UnitImpl NANOMETER_PER_SECOND_PER_SECOND;
    public static final UnitImpl FORCE;
    public static final UnitImpl NEWTON;
    public static final UnitImpl PASCAL;
    public static final UnitImpl CUBIC_METER_PER_CUBIC_METER;
    public static final UnitImpl METER_PER_METER;
    public static final UnitImpl JOULE;
    public static final UnitImpl ENERGY;
    public static final UnitImpl DYNE;
    public static final UnitImpl AMPERE;
    public static final UnitImpl COULOMB;
    public static final UnitImpl VOLT;
    public static final UnitImpl WEBER;
    public static final UnitImpl TESLA;
    public static final UnitImpl VOLT_PER_METER;
    public static final UnitImpl RADIAN;
    public static final UnitImpl DEGREE;
    public static final UnitImpl COUNT;
    public static final UnitImpl MILLICOUNT;
    public static final UnitImpl MICROCOUNT;
    public static final UnitImpl KILOCOUNT;
    public static final UnitImpl MEGACOUNT;
    public static final UnitImpl DIMENSONLESS;
    public static final UnitImpl DIMENSIONLESS;
    public static final String KELVIN_NAME = "KELVIN";
    public static final UnitImpl KELVIN;
    public static final String CELSIUS_NAME = "CELSIUS";
    public static final UnitImpl CELSIUS;
    public static final String FAHRENHEIT_NAME = "FAHRENHEIT";
    public static final UnitImpl FAHRENHEIT;
    public static final UnitImpl CANDELA;
    public static final UnitImpl MOLE;
    public static final UnitImpl UNKNOWN;
    public static final UnitImpl RADIAN_PER_SECOND;
    protected Integer dbid;
    protected List<UnitImpl> hibernateSubUnitList = null;

    protected UnitImpl() {
    }

    public static Serializable createEmpty() {
        return new UnitImpl();
    }

    protected UnitImpl(int power, String name, double multi, int exponent) {
        this.power = power;
        this.name = name;
        this.multi_factor = multi;
        this.exponent = exponent;
    }

    public UnitImpl(UnitBase baseUnit, int exponent, int power) {
        this(power, "", 1.0, exponent);
        this.the_unit_base = baseUnit;
        this.elements = new Unit[0];
    }

    public UnitImpl(Unit[] subunits, int power, String name, double multi, int exponent) {
        this(power, name, multi, exponent);
        if (subunits == null) {
            throw new IllegalArgumentException("Cannot create composite Unit with null subunits.");
        }
        if (subunits.length == 0) {
            throw new IllegalArgumentException("Cannot create composite Unit with 0 subunits.");
        }
        this.the_unit_base = UnitBase.COMPOSITE;
        this.elements = subunits;
    }

    public UnitImpl(UnitBase base, int power, String name, double multi, int exponent) {
        this(power, name, multi, exponent);
        if (base == null) {
            throw new IllegalArgumentException("Cannot create base Unit with null UnitBase.");
        }
        this.the_unit_base = base;
        this.elements = new Unit[0];
    }

    public static UnitImpl createUnitImpl(Unit inUnit) {
        UnitImpl newUnit;
        if (inUnit instanceof UnitImpl) {
            return (UnitImpl)inUnit;
        }
        if (inUnit.the_unit_base == UnitBase.COMPOSITE) {
            Unit[] newSubUnits = new UnitImpl[inUnit.elements.length];
            for (int i = 0; i < newSubUnits.length; ++i) {
                newSubUnits[i] = UnitImpl.createUnitImpl(inUnit.elements[i]);
            }
            newUnit = new UnitImpl(newSubUnits, inUnit.power, inUnit.name, inUnit.multi_factor, inUnit.exponent);
        } else {
            newUnit = new UnitImpl(inUnit.the_unit_base, inUnit.power, inUnit.name, inUnit.multi_factor, inUnit.exponent);
        }
        return newUnit;
    }

    public int getNumSubUnits() {
        if (this.the_unit_base.equals(UnitBase.COMPOSITE)) {
            return this.elements.length;
        }
        return 0;
    }

    public UnitImpl getSubUnit(int i) {
        return (UnitImpl)this.elements[i];
    }

    public UnitImpl[] getSubUnits() {
        if (this.elements == null || this.elements.length == 0) {
            return new UnitImpl[0];
        }
        UnitImpl[] temp = new UnitImpl[this.elements.length];
        System.arraycopy(this.elements, 0, temp, 0, temp.length);
        return temp;
    }

    protected void setSubUnits(UnitImpl[] u) {
        this.elements = u;
    }

    public boolean isBaseUnit() {
        return this.the_unit_base != UnitBase.COMPOSITE;
    }

    public UnitBase getBaseUnit() {
        return this.the_unit_base;
    }

    public int getBaseUnitInt() {
        return this.getBaseUnit().value();
    }

    protected void setBaseUnitInt(int base) {
        this.the_unit_base = UnitBase.from_int((int)base);
    }

    public static int getNumPrimitives() {
        int numPrimitives = 0;
        try {
            while (true) {
                UnitBase.from_int((int)numPrimitives);
                ++numPrimitives;
            }
        }
        catch (Exception exception) {
            return numPrimitives;
        }
    }

    public UnitImpl getReducedUnit() {
        int[] primitiveExponent = this.getBaseExponents();
        UnitImpl unitTemp = new UnitImpl(UnitBase.from_int((int)0), this.getTotalPower(), "", this.getTotalMultiFactor(), 1);
        UnitImpl unitTotal = new UnitImpl(new Unit[primitiveExponent.length], this.getTotalPower(), "", this.getTotalMultiFactor(), 1);
        int numSubUnits = 0;
        for (int i = 0; i < primitiveExponent.length; ++i) {
            if (primitiveExponent[i] == 0) continue;
            unitTemp.the_unit_base = UnitBase.from_int((int)i);
            unitTemp.exponent = primitiveExponent[i];
            unitTotal.elements[numSubUnits] = unitTemp;
            ++numSubUnits;
            unitTemp = new UnitImpl(UnitBase.from_int((int)0), this.getTotalPower(), "", this.getTotalMultiFactor(), 1);
        }
        if (numSubUnits == 1) {
            unitTotal = (UnitImpl)unitTotal.elements[0];
        }
        return unitTotal;
    }

    public int[] getBaseExponents() {
        int[] baseExponents = new int[numPrimitives];
        if (this.the_unit_base != UnitBase.COMPOSITE) {
            baseExponents[this.the_unit_base.value()] = this.exponent;
            return baseExponents;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            UnitImpl subunit = (UnitImpl)this.elements[i];
            int[] subExponents = subunit.getBaseExponents();
            for (int j = 0; j < baseExponents.length; ++j) {
                int n = j;
                baseExponents[n] = baseExponents[n] + subExponents[j];
            }
        }
        int j = 0;
        while (j < baseExponents.length) {
            int n = j++;
            baseExponents[n] = baseExponents[n] * this.exponent;
        }
        return baseExponents;
    }

    public int getExponent() {
        return this.exponent;
    }

    public int getTotalPower() {
        if (this.the_unit_base != UnitBase.COMPOSITE) {
            return this.getPower() * this.getExponent();
        }
        int power = 0;
        for (int i = 0; i < this.elements.length; ++i) {
            UnitImpl temp = (UnitImpl)this.elements[i];
            power += temp.getTotalPower();
        }
        return (power + this.getPower()) * this.getExponent();
    }

    public int getPower() {
        return this.power;
    }

    public double getTotalMultiFactor() {
        if (this.the_unit_base != UnitBase.COMPOSITE) {
            return this.getMultiFactor();
        }
        double multi = 1.0;
        for (int i = 0; i < this.elements.length; ++i) {
            UnitImpl temp = (UnitImpl)this.elements[i];
            multi *= temp.getTotalMultiFactor();
        }
        return Math.pow(multi * this.getMultiFactor(), this.getExponent());
    }

    public double getMultiFactor() {
        return this.multi_factor;
    }

    public boolean isConvertableTo(UnitImpl otherUnits) {
        int[] ourExponents = this.getBaseExponents();
        int[] otherExponents = otherUnits.getBaseExponents();
        for (int i = 0; i < ourExponents.length; ++i) {
            if (ourExponents[i] == otherExponents[i]) continue;
            return false;
        }
        return true;
    }

    public boolean isNamed() {
        return this.name != null && this.name.length() != 0;
    }

    public static String baseToString(UnitBase b) {
        switch (b.value()) {
            case 0: {
                return "METER";
            }
            case 1: {
                return "GRAM";
            }
            case 2: {
                return "SECOND";
            }
            case 3: {
                return "AMPERE";
            }
            case 4: {
                return KELVIN_NAME;
            }
            case 5: {
                return "MOLE";
            }
            case 6: {
                return "CANDELA";
            }
            case 7: {
                return "COUNT";
            }
        }
        return null;
    }

    public void toLongString() {
        System.out.println("*****" + (Object)((Object)this) + "*****");
        System.out.println("Base Unit: " + this.getBaseUnit());
        System.out.println("Exponents: " + this.getExponent());
        System.out.println("Power: " + this.getPower());
        System.out.println("Multifactor: " + this.getMultiFactor());
        System.out.println("IsBaseUnit: " + this.isBaseUnit());
        System.out.println("NumSubUnits: " + this.getNumSubUnits());
        System.out.println("Subunits: ");
        for (int i = 0; i < this.getNumSubUnits(); ++i) {
            this.getSubUnit(i).toLongString();
        }
    }

    public String toString() {
        if (this.isNamed()) {
            return this.name;
        }
        String s = this.multi_factor != 1.0 ? this.multi_factor + " * " : "";
        s = UnitImpl.getPrefix(this.getPower()) != null ? s + UnitImpl.getPrefix(this.getPower()) : s + "10^" + this.getPower() + " ";
        if (this.the_unit_base == UnitBase.COMPOSITE) {
            if (this.elements.length != 1) {
                s = s + "(";
            }
            String tempS = "";
            for (int i = 0; i < this.elements.length; ++i) {
                UnitImpl tempUnit = (UnitImpl)this.elements[i];
                tempS = tempUnit.isNamed() ? tempUnit.toString() + " " : "(" + tempUnit.toString() + ") ";
                s = s + tempS;
            }
        } else {
            String tempS = UnitImpl.baseToString(this.the_unit_base);
            s = tempS != null && tempS != "" ? s + tempS : s + "UNKNOWN" + this.the_unit_base.value();
        }
        if (this.the_unit_base == UnitBase.COMPOSITE && this.elements.length != 1) {
            s = s + ")";
        }
        if (this.exponent != 1) {
            s = s + "^" + this.exponent;
        }
        return s;
    }

    public int hashCode() {
        int result = 27;
        result = result * 37 + this.getPower();
        result = result * 37 + UnitImpl.getHashValue(this.getMultiFactor());
        result = result * 37 + this.getExponent();
        result = result * 37 + (this.isBaseUnit() ? 0 : 1);
        return result;
    }

    private static int getHashValue(double d) {
        long l = Double.doubleToLongBits(d);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof UnitImpl) {
            UnitImpl u = (UnitImpl)((Object)o);
            if (u.getPower() != this.getPower() || u.getMultiFactor() != this.getMultiFactor() || u.getExponent() != this.getExponent() || u.isBaseUnit() != this.isBaseUnit()) {
                return false;
            }
            if (this.isBaseUnit()) {
                if (this.getBaseUnit() == UnitBase.KELVIN && u.getBaseUnit() == UnitBase.KELVIN) {
                    return this.name != null && this.name.equalsIgnoreCase(u.name);
                }
                return u.getBaseUnit() == this.getBaseUnit();
            }
            if (u.getNumSubUnits() != this.getNumSubUnits()) {
                return false;
            }
            for (int i = 0; i < this.getNumSubUnits(); ++i) {
                if (u.getSubUnit(i).equals((Object)this.getSubUnit(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public UnitImpl inverse() {
        if (this.name == null || this.name.length() == 0) {
            return this.inverse("");
        }
        return this.inverse(this.name + "^-1");
    }

    public UnitImpl inverse(String name) {
        if (this.the_unit_base != UnitBase.COMPOSITE) {
            return new UnitImpl(this.the_unit_base, this.power, name, this.multi_factor, this.exponent * -1);
        }
        return new UnitImpl(this.elements, this.power, name, this.multi_factor, this.exponent * -1);
    }

    public static UnitImpl multiply(double f, UnitImpl u) {
        return UnitImpl.multiply(f, u, "");
    }

    public static UnitImpl multiply(double f, UnitImpl u, String name) {
        Unit[] elements = new Unit[]{u};
        return new UnitImpl(elements, 0, name, f, 1);
    }

    public static UnitImpl multiply(UnitImpl a, UnitImpl b) {
        return UnitImpl.multiply(a, b, "");
    }

    public static UnitImpl multiply(UnitImpl a, UnitImpl b, String name) {
        Unit[] elements = new UnitImpl[]{a, b};
        return new UnitImpl(elements, 0, name, 1.0, 1);
    }

    public static UnitImpl multiply(UnitImpl[] units) {
        return UnitImpl.multiply(units, "");
    }

    public static UnitImpl multiply(UnitImpl[] units, String name) {
        return new UnitImpl(units, 0, name, 1.0, 1);
    }

    public static UnitImpl divide(UnitImpl a, UnitImpl b) {
        return UnitImpl.divide(a, b, "");
    }

    public static UnitImpl divide(UnitImpl a, UnitImpl b, String name) {
        Unit[] elements = new UnitImpl[]{a, b.inverse()};
        return new UnitImpl(elements, 0, name, 1.0, 1);
    }

    public static final String getPrefix(int power) {
        switch (power) {
            case 24: {
                return "yotta";
            }
            case 21: {
                return "zetta";
            }
            case 18: {
                return "exa";
            }
            case 15: {
                return "peta";
            }
            case 12: {
                return "tera";
            }
            case 9: {
                return "giga";
            }
            case 6: {
                return "mega";
            }
            case 3: {
                return "kilo";
            }
            case 2: {
                return "hecto";
            }
            case 1: {
                return "deka";
            }
            case 0: {
                return "";
            }
            case -1: {
                return "deci";
            }
            case -2: {
                return "centi";
            }
            case -3: {
                return "milli";
            }
            case -6: {
                return "micro";
            }
            case -9: {
                return "nano";
            }
            case -12: {
                return "pico";
            }
            case -15: {
                return "femto";
            }
            case -18: {
                return "atto";
            }
            case -21: {
                return "zepto";
            }
            case -24: {
                return "yocto";
            }
        }
        return null;
    }

    public static final UnitImpl getUnitFromString(String unitName) throws NoSuchFieldException {
        try {
            return (UnitImpl)((Object)UnitImpl.class.getField(unitName.toUpperCase()).get(null));
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw new RuntimeException("This was supposed to be unreachable");
    }

    protected void setDbid(Integer dbid) {
        this.dbid = dbid;
    }

    public Integer getDbid() {
        return this.dbid;
    }

    public List<UnitImpl> getSubUnitsList() {
        if (this.hibernateSubUnitList != null) {
            return this.hibernateSubUnitList;
        }
        ArrayList<UnitImpl> out = new ArrayList<UnitImpl>();
        for (int i = 0; i < this.elements.length; ++i) {
            out.add((UnitImpl)this.elements[i]);
        }
        return out;
    }

    protected void setSubUnitsList(List<UnitImpl> list) {
        this.hibernateSubUnitList = list;
        this.elements = new UnitImpl[list.size()];
        this.elements = (UnitImpl[])list.toArray(this.elements);
    }

    static {
        LENGTH = METER = new UnitImpl(UnitBase.METER, 1, 0);
        KILOMETER = new UnitImpl(UnitBase.METER, 1, 3);
        CENTIMETER = new UnitImpl(UnitBase.METER, 1, -2);
        MILLIMETER = new UnitImpl(UnitBase.METER, 1, -3);
        MICRON = MICROMETER = new UnitImpl(UnitBase.METER, 1, -6);
        NANOMETER = new UnitImpl(UnitBase.METER, 1, -9);
        PICOMETER = new UnitImpl(UnitBase.METER, 1, -12);
        INCH = UnitImpl.multiply(2.54, CENTIMETER, "INCH");
        FOOT = UnitImpl.multiply(12.0, INCH, "FOOT");
        MILE = UnitImpl.multiply(5280.0, FOOT, "MILE");
        YARD = UnitImpl.multiply(3.0, FOOT, "YARD");
        ROD = UnitImpl.multiply(5.5, YARD, "ROD");
        FURLONG = UnitImpl.multiply(40.0, ROD, "FURLONG");
        LEAGUE = UnitImpl.multiply(3.0, MILE, "LEAGUE");
        TIME = SECOND = new UnitImpl(UnitBase.SECOND, 1, 0);
        MINUTE = UnitImpl.multiply(60.0, SECOND, "MINUTE");
        HOUR = UnitImpl.multiply(60.0, MINUTE, "HOUR");
        DAY = UnitImpl.multiply(24.0, HOUR, "DAY");
        WEEK = UnitImpl.multiply(7.0, DAY, "WEEK");
        FORTNIGHT = UnitImpl.multiply(14.0, DAY, "FORTNIGHT");
        YEAR = UnitImpl.multiply(365.0, DAY, "YEAR");
        LEAP_YEAR = UnitImpl.multiply(366.0, DAY, "LEAP_YEAR");
        GREGORIAN_YEAR = UnitImpl.multiply(365.2425, DAY, "GREGORIAN_YEAR");
        MILLISECOND = new UnitImpl(UnitBase.SECOND, 1, -3);
        TENTHMILLISECOND = new UnitImpl(UnitBase.SECOND, 1, -4);
        MICROSECOND = new UnitImpl(UnitBase.SECOND, 1, -6);
        NANOSECOND = new UnitImpl(UnitBase.SECOND, 1, -9);
        HERTZ = new UnitImpl(UnitBase.SECOND, -1, 0);
        AREA = SQUARE_METER = new UnitImpl(UnitBase.METER, 2, 0);
        SQUARE_CENTIMETER = new UnitImpl(UnitBase.METER, 2, -2);
        VOLUME = CUBIC_METER = new UnitImpl(UnitBase.METER, 3, 0);
        CUBIC_CENTIMETER = new UnitImpl(UnitBase.METER, 3, -2);
        LITER = new UnitImpl(UnitBase.METER, 3, -1);
        GRAM = new UnitImpl(UnitBase.GRAM, 1, 0);
        MASS = KILOGRAM = new UnitImpl(UnitBase.GRAM, 1, 3);
        DENSITY = UnitImpl.divide(MASS, VOLUME);
        GRAM_PER_CUBIC_CENTIMETER = UnitImpl.divide(GRAM, CUBIC_CENTIMETER);
        KILOGRAM_PER_CUBIC_METER = UnitImpl.divide(KILOGRAM, CUBIC_METER);
        VELOCITY = UnitImpl.divide(LENGTH, TIME);
        METER_PER_SECOND = UnitImpl.divide(METER, SECOND);
        KILOMETER_PER_SECOND = UnitImpl.divide(KILOMETER, SECOND);
        CENTIMETER_PER_SECOND = UnitImpl.divide(CENTIMETER, SECOND);
        MILLIMETER_PER_SECOND = UnitImpl.divide(MILLIMETER, SECOND);
        MICRON_PER_SECOND = MICROMETER_PER_SECOND = UnitImpl.divide(MICROMETER, SECOND);
        NANOMETER_PER_SECOND = UnitImpl.divide(NANOMETER, SECOND);
        METER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(METER, SECOND), SECOND);
        ACCELERATION = UnitImpl.divide(VELOCITY, TIME);
        KILOMETER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(KILOMETER, SECOND), SECOND);
        CENTIMETER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(CENTIMETER, SECOND), SECOND);
        MILLIMETER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(MILLIMETER, SECOND), SECOND);
        MICROMETER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(MICROMETER, SECOND), SECOND);
        NANOMETER_PER_SECOND_PER_SECOND = UnitImpl.divide(UnitImpl.divide(NANOMETER, SECOND), SECOND);
        FORCE = UnitImpl.multiply(MASS, ACCELERATION);
        NEWTON = UnitImpl.multiply(KILOGRAM, METER_PER_SECOND_PER_SECOND, "NEWTON");
        PASCAL = UnitImpl.divide(NEWTON, SQUARE_METER, "PASCAL");
        CUBIC_METER_PER_CUBIC_METER = UnitImpl.divide(CUBIC_METER, CUBIC_METER);
        METER_PER_METER = UnitImpl.divide(METER, METER);
        JOULE = UnitImpl.multiply(NEWTON, METER, "JOULE");
        ENERGY = UnitImpl.multiply(FORCE, LENGTH);
        DYNE = UnitImpl.multiply(UnitImpl.multiply(GRAM, CENTIMETER_PER_SECOND_PER_SECOND), CENTIMETER, "DYNE");
        AMPERE = new UnitImpl(UnitBase.AMPERE, 1, 0);
        COULOMB = UnitImpl.multiply(AMPERE, SECOND, "COULOMB");
        VOLT = UnitImpl.divide(JOULE, COULOMB, "VOLT");
        WEBER = UnitImpl.multiply(VOLT, SECOND, "WEBER");
        TESLA = UnitImpl.divide(WEBER, SQUARE_METER, "TESLA");
        VOLT_PER_METER = UnitImpl.divide(VOLT, METER);
        RADIAN = UnitImpl.divide(LENGTH, LENGTH, "RADIAN");
        DEGREE = UnitImpl.multiply(57.29577951308232, RADIAN, "DEGREE");
        COUNT = new UnitImpl(UnitBase.COUNT, 1, 0);
        MILLICOUNT = new UnitImpl(UnitBase.COUNT, 1, -3);
        MICROCOUNT = new UnitImpl(UnitBase.COUNT, 1, -6);
        KILOCOUNT = new UnitImpl(UnitBase.COUNT, 1, 3);
        MEGACOUNT = new UnitImpl(UnitBase.COUNT, 1, 6);
        DIMENSIONLESS = DIMENSONLESS = UnitImpl.divide(SECOND, SECOND, "");
        KELVIN = new UnitImpl(UnitBase.KELVIN, 1, KELVIN_NAME, 1.0, 1);
        CELSIUS = new UnitImpl(UnitBase.KELVIN, 0, CELSIUS_NAME, 1.0, 1);
        FAHRENHEIT = new UnitImpl(UnitBase.KELVIN, 0, FAHRENHEIT_NAME, 1.8, 1);
        CANDELA = new UnitImpl(UnitBase.CANDELA, 1, 0);
        MOLE = new UnitImpl(UnitBase.MOLE, 1, 0);
        UNKNOWN = UnitImpl.divide(CANDELA, CANDELA, "UNKNOWN");
        RADIAN_PER_SECOND = UnitImpl.divide(RADIAN, SECOND);
    }
}

