/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.BoxArea;
import java.io.Serializable;

public class BoxAreaImpl
extends BoxArea {
    public BoxAreaImpl(float min_latitude, float max_latitude, float min_longitude, float max_longitude) {
        this.min_latitude = min_latitude;
        this.max_latitude = max_latitude;
        this.min_longitude = BoxAreaImpl.sanitize(min_longitude);
        this.max_longitude = BoxAreaImpl.sanitize(max_longitude);
    }

    public static float sanitize(float longitude) {
        if (longitude > 180.0f) {
            longitude -= 360.0f;
        }
        return longitude;
    }

    public static double sanitize(double longitude) {
        if (longitude > 180.0 && longitude <= 360.0) {
            longitude -= 360.0;
        }
        return longitude;
    }

    protected BoxAreaImpl() {
    }

    public static Serializable createEmpty() {
        return new BoxAreaImpl();
    }

    public String toString() {
        return "BoxArea (" + this.min_latitude + "," + this.min_longitude + ") (" + this.max_latitude + "," + this.max_longitude + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BoxArea) {
            BoxArea ba = (BoxArea)o;
            return ba.min_latitude == this.min_latitude && ba.max_latitude == this.max_latitude && ba.min_longitude == this.min_longitude && ba.max_longitude == this.max_longitude;
        }
        return false;
    }

    public int hashCode() {
        int result = 7;
        result = result * 37 + Float.floatToIntBits(this.min_latitude);
        result = result * 37 + Float.floatToIntBits(this.max_latitude);
        result = result * 37 + Float.floatToIntBits(this.min_longitude);
        return result * 37 + Float.floatToIntBits(this.max_longitude);
    }
}

