/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.event;

import edu.iris.Fissures.IfEvent.Magnitude;
import edu.iris.Fissures.IfEvent.Origin;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.Location;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.event.MagnitudeUtil;
import edu.iris.Fissures.model.LocationUtil;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.ParameterRefUtil;
import edu.iris.Fissures.model.UnitImpl;
import java.util.ArrayList;
import java.util.List;

public class OriginImpl
extends Origin {
    private MicroSecondDate time;
    private int dbid;
    protected List hibernateMagList = null;

    protected OriginImpl() {
        this.setParmIds(new ParameterRef[0]);
        this.set_id("");
    }

    public static OriginImpl createEmpty() {
        return new OriginImpl();
    }

    public OriginImpl(String id, String catalog, String contributor, Time origin_time, Location my_location, Magnitude[] magnitudes, ParameterRef[] parm_ids) {
        this.id = id;
        this.setCatalog(catalog);
        this.setContributor(contributor);
        this.setOriginTime(origin_time);
        this.setLocation(my_location);
        this.setMagnitudes(magnitudes);
        this.setParmIds(parm_ids);
    }

    public String get_id() {
        return this.id;
    }

    public boolean equals(Object o) {
        OriginImpl oOrigin;
        if (o == this) {
            return true;
        }
        return o instanceof OriginImpl && this.equalsExceptTime(oOrigin = (OriginImpl)((Object)o)) && oOrigin.getTime().equals(this.getTime());
    }

    public boolean equalsExceptTime(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        return LocationUtil.areEqual(oOrigin.getLocation(), this.getLocation()) && oOrigin.getCatalog().equals(this.getCatalog()) && oOrigin.getContributor().equals(this.getContributor()) && MagnitudeUtil.areEqual(this.getMagnitudes(), oOrigin.getMagnitudes()) && ParameterRefUtil.areEqual(this.getParmIds(), oOrigin.getParmIds());
    }

    public boolean close(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        if (this.equalsExceptTime(oOrigin)) {
            MicroSecondDate myOTime = new MicroSecondDate(this.getOriginTime());
            MicroSecondDate eventOTime = new MicroSecondDate(oOrigin.getOriginTime());
            if (myOTime.subtract((MicroSecondDate)eventOTime).convertTo((UnitImpl)UnitImpl.MICROSECOND).value < 1000.0) {
                return true;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 29;
        result += 89 * result + LocationUtil.hash(this.getLocation());
        result += 89 * result + this.getTime().hashCode();
        result += 89 * result + this.getContributor().hashCode();
        result += 89 * result + this.getCatalog().hashCode();
        result += 89 * result + ParameterRefUtil.hash(this.getParmIds());
        result += 89 * result + MagnitudeUtil.hash(this.getMagnitudes());
        return result;
    }

    public Time getFissuresTime() {
        return this.getOriginTime();
    }

    public MicroSecondDate getTime() {
        if (this.time == null) {
            this.time = new MicroSecondDate(this.getOriginTime());
        }
        return this.time;
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getDbid() {
        return this.dbid;
    }

    protected void set_id(String id) {
        this.id = id == null ? "" + this.getDbid() : id;
    }

    public List getMagnitudeList() {
        if (this.hibernateMagList != null) {
            return this.hibernateMagList;
        }
        ArrayList<Magnitude> out = new ArrayList<Magnitude>();
        for (int i = 0; i < this.getMagnitudes().length; ++i) {
            out.add(this.getMagnitudes()[i]);
        }
        return out;
    }

    protected void setMagnitudeList(List list) {
        this.hibernateMagList = list;
        this.setMagnitudes(new Magnitude[list.size()]);
        this.setMagnitudes(list.toArray(this.getMagnitudes()));
    }
}

