/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.net;

import gov.usgs.net.ReadHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;

public class IPClient
extends Thread {
    private static final int BUFFER_SIZE = 65536;
    private static String host = "localhost";
    private static int port = 16022;
    protected Socket socket;
    protected SocketChannel socketChannel;
    CharsetEncoder encoder = Charset.forName("US-ASCII").newEncoder();
    CharsetDecoder decoder = Charset.forName("US-ASCII").newDecoder();
    protected Selector selector;
    protected ReadHandler readHandler;

    public IPClient() {
        try {
            this.selector = Selector.open();
            this.socketChannel = SocketChannel.open(new InetSocketAddress(host, port));
            this.socketChannel.configureBlocking(false);
            this.socketChannel.register(this.selector, 1);
            this.readHandler = new ReadHandler(){
                ByteBuffer rbb = ByteBuffer.allocate(65536);
                CharBuffer rcb = CharBuffer.allocate(65536);

                public void processRead(SelectionKey key) {
                    SocketChannel socketChannel = (SocketChannel)key.channel();
                    try {
                        this.rbb.clear();
                        socketChannel.read(this.rbb);
                        this.rbb.flip();
                        this.rcb = IPClient.this.decoder.decode(this.rbb);
                        System.out.print(this.rcb.toString());
                    }
                    catch (Exception e) {
                        System.out.println("Connection closed.");
                        System.exit(1);
                    }
                }
            };
            this.start();
            ByteBuffer bb = ByteBuffer.allocate(65536);
            CharBuffer cb = CharBuffer.allocate(65536);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                bb.clear();
                cb.clear();
                String s = in.readLine();
                if (s.startsWith("quit")) break;
                cb.put(s + "\n");
                cb.flip();
                bb.put(this.encoder.encode(cb));
                bb.flip();
                this.socketChannel.write(bb);
            }
            this.socketChannel.close();
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run() {
        while (true) {
            try {
                block3: while (true) {
                    this.selector.select();
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (true) {
                        if (!it.hasNext()) continue block3;
                        SelectionKey selKey = it.next();
                        it.remove();
                        if (!selKey.isReadable()) continue;
                        this.readHandler.processRead(selKey);
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            host = args[0];
            port = Integer.parseInt(args[1]);
        }
        new IPClient();
    }
}

