/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.HandleError;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class Tokenizer
extends PushbackReader {
    StringBuffer b = new StringBuffer(80);
    int lineCount = 0;
    static Object NEWLINE = new Object(){

        public String toString() {
            return "<newline>";
        }
    };
    static Object EOF = new Object(){

        public String toString() {
            return "<EOF>";
        }
    };

    public Tokenizer(Reader in) {
        super(in, 2);
    }

    public boolean isNewline(Object o) {
        return o == NEWLINE;
    }

    public boolean isEOF(Object o) {
        return o == EOF;
    }

    public boolean isAny(int c) {
        return c != -1;
    }

    public boolean isAlpha(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90;
    }

    public boolean isDigit(int c) {
        return c >= 48 && c <= 57;
    }

    public boolean isAlphanumeric(int c) {
        return this.isAlpha(c) || this.isDigit(c);
    }

    public void bpush(int c) {
        this.b.append((char)c);
    }

    public String bclear() {
        String result = this.b.toString();
        this.b.setLength(0);
        int L = result.length();
        char[] chars = new char[L];
        result.getChars(0, L, chars, 0);
        return new String(chars);
    }

    public int next() {
        try {
            int c = this.read();
            if (c == 13) {
                int c1 = this.read();
                if (c1 == 10) {
                    c = 10;
                } else {
                    this.unread(c1);
                    c = 10;
                }
            }
            if (c == 10) {
                ++this.lineCount;
            }
            return c;
        }
        catch (IOException e) {
            throw new HandleError(e);
        }
    }

    public void putback(int c) {
        try {
            if (c != -1) {
                this.unread(c);
            }
        }
        catch (IOException e) {
            throw new HandleError(e);
        }
    }

    public Object error(String s) {
        throw new HandleError("at line " + this.lineCount + ": " + s);
    }
}

