/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileUtils {
    public static String getFilePathToSaveFromUser(String title) {
        JFileChooser chooser = FileUtils.getChooser(title);
        chooser.setDialogTitle(title);
        int state = chooser.showSaveDialog(null);
        String ret = FileUtils.handleResponse(chooser, state);
        return ret;
    }

    public static String getFilePathToOpenFromUser(String title) {
        return FileUtils.getFilePathToOpenFromUser(title, null);
    }

    public static String getFilePathToOpenFromUser(String title, FileFilter ff) {
        JFileChooser chooser = FileUtils.getChooser(title);
        chooser.setDialogTitle(title);
        if (ff != null) {
            chooser.setFileFilter(ff);
        }
        int state = chooser.showOpenDialog(null);
        String ret = FileUtils.handleResponse(chooser, state);
        return ret;
    }

    protected static JFileChooser getChooser(String title) {
        File startingPoint = new File(Environment.get("lastchosendirectory", System.getProperty("user.home")));
        return new JFileChooser(startingPoint);
    }

    protected static String handleResponse(JFileChooser chooser, int state) {
        String ret = null;
        try {
            int dirIndex;
            if (state != 1 && state != -1 && (dirIndex = (ret = chooser.getSelectedFile().getCanonicalPath()).lastIndexOf(File.separator)) >= 0) {
                Environment.set("lastchosendirectory", ret.substring(0, dirIndex));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "Error picking file", 0);
            ioe.printStackTrace();
        }
        return ret;
    }
}

