/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolImageMaker;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;

public class BasicSymbolImageMaker
extends OMComponent
implements SymbolImageMaker {
    protected String dataPath;
    protected Paint background;

    public BasicSymbolImageMaker() {
        this(null);
    }

    public BasicSymbolImageMaker(String dataPath) {
        this.dataPath = dataPath != null ? dataPath : "";
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.setBackground(PropUtils.parseColorFromProperties(props, prefix + "background", "0x00000000"));
        String dataPathString = props.getProperty(prefix + "path");
        if (dataPathString != null) {
            this.setDataPath(dataPathString);
        } else if (Debug.debugging("symbology")) {
            Debug.output(this.getClass().getName() + " data path (" + prefix + "path" + ") not set in properties, might be OK if symbol data stored in jar in classpath.");
        }
    }

    protected URL getFileURL(String code) throws MalformedURLException {
        code = this.massageCode(code);
        code = this.dataPath + (this.dataPath != null && this.dataPath != "" ? "/" : "") + code + this.getFileExtension();
        if (Debug.debugging("symbology")) {
            Debug.output("AbstractSymbolImageMaker: code massaged to " + code);
        }
        URL ret = PropUtils.getResourceOrFileOrURL(code);
        return ret;
    }

    public String getFileExtension() {
        return "";
    }

    protected String massageCode(String code) {
        code = code.replace('*', '-').toLowerCase();
        return code;
    }

    public ImageIcon getIcon(String code, Dimension di) {
        block5: {
            try {
                URL fileURL = this.getFileURL(code);
                if (Debug.debugging("symbology")) {
                    Debug.output("BasicSymbolImageMaker: Trying to create " + fileURL);
                }
                BufferedImage bi = BufferedImageHelper.getBufferedImage(fileURL);
                return new ImageIcon(bi.getScaledInstance((int)di.getWidth(), (int)di.getHeight(), 4));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NullPointerException npe) {
                if (!Debug.debugging("symbology")) break block5;
                Debug.output("BasicSymbolImageMaker: didn't find data for image");
                npe.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setBackground(Paint p) {
        this.background = p;
    }

    public Paint getBackground() {
        return this.background;
    }

    public String getDataPath() {
        return this.dataPath;
    }
}

