/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.roads;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.tools.roads.Intersection;
import com.bbn.openmap.tools.roads.Road;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;

public class Route
implements Cloneable {
    private static float MSEC_PER_HOUR = 3600000.0f;
    private String name = null;
    Road[] roads;
    private boolean startWithFirstIntersection;
    private boolean endWithFirstIntersection;
    Logger logger = Logger.getLogger(this.getClass().getName());

    public static synchronized Route getBestRoute(Intersection from, Intersection to, float bestConvoySpeed, float worstConvoySpeed) {
        Hashtable<Intersection, NodeInfo> marks = new Hashtable<Intersection, NodeInfo>();
        boolean haveRoute = false;
        LatLonPoint toLoc = to.getLocation();
        float toLat = toLoc.getLatitude();
        float toLon = toLoc.getLongitude();
        LatLonPoint fromLoc = from.getLocation();
        float fromLat = fromLoc.getLatitude();
        float fromLon = fromLoc.getLongitude();
        float timeLimitBase = GreatCircle.spherical_distance(toLat, toLon, fromLat, fromLon) / worstConvoySpeed;
        float bestTime = Float.MAX_VALUE;
        float snakeFactor = 1.0f;
        while (snakeFactor < 40.0f) {
            float timeLimit = timeLimitBase * snakeFactor;
            Vector<Intersection> toDo = new Vector<Intersection>();
            toDo.addElement(from);
            marks.clear();
            marks.put(from, new NodeInfo(from, null, 0.0f, 0.0f));
            while (toDo.size() > 0) {
                Vector<Intersection> newToDo = new Vector<Intersection>();
                Enumeration e = toDo.elements();
                while (e.hasMoreElements()) {
                    Intersection thisIntersection = (Intersection)e.nextElement();
                    NodeInfo thisInfo = (NodeInfo)marks.get(thisIntersection);
                    Enumeration e2 = thisIntersection.getRoads();
                    while (e2.hasMoreElements()) {
                        Road road = (Road)e2.nextElement();
                        float roadTime = road.getTraverseHours();
                        float newTime = thisInfo.time + roadTime;
                        if (newTime > timeLimit) continue;
                        Intersection nextIntersection = road.getOtherIntersection(thisIntersection);
                        NodeInfo nextInfo = (NodeInfo)marks.get(nextIntersection);
                        if (nextInfo == null) {
                            LatLonPoint nextLoc = nextIntersection.getLocation();
                            float crowsPathDistance = GreatCircle.spherical_distance(toLat, toLon, nextLoc.getLatitude(), nextLoc.getLongitude());
                            float crowsPathHours = crowsPathDistance / bestConvoySpeed;
                            nextInfo = new NodeInfo(nextIntersection, road, newTime, crowsPathHours);
                            marks.put(nextIntersection, nextInfo);
                            if (newTime + nextInfo.crowsPathHours > bestTime) continue;
                            newToDo.addElement(nextIntersection);
                        } else {
                            if (!(nextInfo.time > newTime)) continue;
                            if (!nextInfo.intersection.equals(nextIntersection)) {
                                System.err.println("huh?  lookup of " + nextIntersection + " gets node info with inter " + nextInfo.intersection);
                            }
                            nextInfo.time = newTime;
                            nextInfo.bestRoad = road;
                            if (newTime + nextInfo.crowsPathHours > bestTime) continue;
                            newToDo.addElement(nextIntersection);
                        }
                        if (nextIntersection != to) continue;
                        bestTime = nextInfo.time;
                        haveRoute = true;
                    }
                }
                toDo = newToDo;
            }
            if (haveRoute) break;
            snakeFactor *= 2.0f;
        }
        Vector<Road> roadVector = new Vector<Road>();
        Route result = null;
        if (haveRoute) {
            boolean i = false;
            NodeInfo info = (NodeInfo)marks.get(to);
            while (result == null) {
                roadVector.addElement(info.bestRoad);
                Intersection prevIntersection = info.bestRoad.getOtherIntersection(info.intersection);
                if (prevIntersection == from) {
                    result = new Route(roadVector, info.bestRoad.getFirstIntersection() == prevIntersection);
                    continue;
                }
                info = (NodeInfo)marks.get(prevIntersection);
            }
        }
        marks = null;
        return result;
    }

    public Route(String name, Road[] roads, boolean startWithFirstIntersection) {
        this.name = name;
        this.roads = roads;
        this.startWithFirstIntersection = startWithFirstIntersection;
    }

    private Route(Vector roadVector, boolean startWithFirstIntersection) {
        int nRoads = roadVector.size();
        this.roads = new Road[nRoads];
        int i = 0;
        while (i < nRoads) {
            this.roads[i] = (Road)roadVector.elementAt(nRoads - 1 - i);
            ++i;
        }
        this.startWithFirstIntersection = startWithFirstIntersection;
    }

    public Object clone() {
        return new Route(null, this.roads, this.startWithFirstIntersection);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public Road[] getRoads() {
        return this.roads;
    }

    public int getBlockedRoadCount() {
        int blockedRoadCount = 0;
        int i = 0;
        while (i < this.roads.length) {
            if (this.roads[i].isBlocked()) {
                ++blockedRoadCount;
            }
            ++i;
        }
        return blockedRoadCount;
    }

    public void unblockBlockedRoads() {
        int i = 0;
        while (i < this.roads.length) {
            if (this.roads[i].isBlocked()) {
                this.roads[i].unblock();
            }
            ++i;
        }
    }

    public Intersection getOriginIntersection() {
        if (this.startWithFirstIntersection) {
            return this.roads[0].getFirstIntersection();
        }
        return this.roads[0].getSecondIntersection();
    }

    public Intersection getDestinationIntersection() {
        Intersection x = this.getOriginIntersection();
        int i = 0;
        while (i < this.roads.length) {
            x = this.roads[i].getOtherIntersection(x);
            ++i;
        }
        return x;
    }

    public long getTravelTime() {
        float hours = 0.0f;
        int i = 0;
        while (i < this.roads.length) {
            Road road = this.roads[i];
            float roadLength = road.getLengthInKilometers();
            float convoySpeed = road.getRoadClass().getConvoySpeed();
            float timeToTraverse = roadLength / convoySpeed;
            hours += timeToTraverse;
            ++i;
        }
        return (long)(hours * MSEC_PER_HOUR);
    }

    public LatLonPoint location(long time) {
        float hours = (float)time / MSEC_PER_HOUR;
        Intersection from = this.startWithFirstIntersection ? this.roads[0].getFirstIntersection() : this.roads[0].getSecondIntersection();
        int i = 0;
        while (i < this.roads.length) {
            float convoySpeed;
            Road road = this.roads[i];
            boolean forward = road.getFirstIntersection() == from;
            float roadLength = road.getLengthInKilometers();
            float timeToTraverse = roadLength / (convoySpeed = road.getRoadClass().getConvoySpeed());
            if (timeToTraverse > hours) {
                float fraction = hours / timeToTraverse;
                if (!forward) {
                    fraction = 1.0f - fraction;
                }
                return road.getLocationAtKilometer(roadLength * fraction);
            }
            hours -= timeToTraverse;
            from = forward ? road.getSecondIntersection() : road.getFirstIntersection();
            ++i;
        }
        return from.getLocation();
    }

    static class NodeInfo {
        Intersection intersection;
        Road bestRoad = null;
        float time;
        float crowsPathHours;

        NodeInfo(Intersection intersection, Road road, float time, float crowsPathHours) {
            this.intersection = intersection;
            this.bestRoad = road;
            this.time = time;
            this.crowsPathHours = crowsPathHours;
        }
    }
}

