/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.drawing;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.InformationDelegator;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.MapHandler;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.PaintListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.OMToolComponent;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.EditableOMGraphicList;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.editable.GraphicUndefinedState;
import com.bbn.openmap.omGraphics.event.EOMGEvent;
import com.bbn.openmap.omGraphics.event.EOMGListener;
import com.bbn.openmap.omGraphics.event.SelectionListener;
import com.bbn.openmap.omGraphics.event.SelectionProvider;
import com.bbn.openmap.omGraphics.event.SelectionSupport;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.tools.drawing.DrawingTool;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.DrawingToolRequestorList;
import com.bbn.openmap.tools.drawing.EditToolLoader;
import com.bbn.openmap.tools.drawing.OMDrawingToolMouseMode;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class OMDrawingTool
extends OMToolComponent
implements DrawingTool,
Serializable,
PropertyChangeListener,
ProjectionListener,
EOMGListener,
PaintListener,
SelectionProvider {
    I18n i18n = Environment.getI18n();
    protected GraphicAttributes graphicAttributes = GraphicAttributes.getGADefaultClone();
    protected EditableOMGraphic currentEditable;
    protected MouseDelegator mouseDelegator;
    protected MapMouseMode formerMouseMode = null;
    protected JComponent canvas;
    protected Hashtable loaders = new Hashtable();
    protected Vector rawLoaders = new Vector();
    protected OMDrawingToolMouseMode dtmm;
    protected DrawingToolRequestor requestor = null;
    protected Projection projection = null;
    protected SelectionSupport selectionSupport = null;
    public static final int SHOW_GUI_BEHAVIOR_MASK = 1;
    public static final int GUI_VIA_POPUP_BEHAVIOR_MASK = 2;
    public static final int USE_POPUP_BEHAVIOR_MASK = 4;
    public static final int ALT_POPUP_BEHAVIOR_MASK = 8;
    public static final int PASSIVE_MOUSE_EVENT_BEHAVIOR_MASK = 16;
    public static final int DEACTIVATE_ASAP_BEHAVIOR_MASK = 32;
    public static final int DEFAULT_BEHAVIOR_MASK = 11;
    public static final int QUICK_CHANGE_BEHAVIOR_MASK = 10;
    protected int behaviorMask = 11;
    public static final String LoadersProperty = "OMDrawingTool.loaders";
    protected boolean DEBUG = false;
    protected InformationDelegator informationDelegator = null;
    protected Vector possibleEditableClasses = null;
    protected boolean activated = false;
    protected boolean visibleWhenInactive = true;
    public static final String VisibleWhenInactiveProperty = "visibleWhenInactive";
    protected boolean resetGUIWhenDeactivated = true;
    String lastRemarks = "";
    JPopupMenu popup = null;
    int windowx;
    int windowy;
    static /* synthetic */ Class class$com$bbn$openmap$tools$drawing$OMDrawingTool;
    static /* synthetic */ Class class$java$awt$Frame;

    public OMDrawingTool() {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.DEBUG = Debug.debugging("drawingtool");
        this.selectionSupport = new SelectionSupport(this);
        this.setAttributes(new GraphicAttributes());
        this.setMouseMode(this.createMouseMode());
        this.setUseAsTool(false);
    }

    protected OMDrawingToolMouseMode createMouseMode() {
        return new OMDrawingToolMouseMode(this);
    }

    public OMGraphic create(String classname, DrawingToolRequestor requestor) {
        return this.create(classname, null, requestor);
    }

    public OMGraphic create(String classname, GraphicAttributes ga, DrawingToolRequestor requestor) {
        return this.create(classname, ga, requestor, this.isMask(1));
    }

    public OMGraphic create(String classname, GraphicAttributes ga, DrawingToolRequestor requestor, boolean showGUI) {
        if (this.getCurrentEditable() != null) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit(): can't create " + classname + ", drawing tool busy with another graphic.");
            }
            return null;
        }
        if (this.DEBUG) {
            Debug.output("OMDrawingTool.create(" + classname + ")");
        }
        if (showGUI) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.create(): showing GUI per request");
            }
            this.setMask(1);
        } else {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.create(): NOT showing GUI per request");
            }
            this.unsetMask(1);
        }
        EditableOMGraphic eomg = this.getEditableGraphic(classname, ga);
        if (eomg == null || eomg.getGraphic() == null) {
            return null;
        }
        this.setAttributes(ga);
        eomg.setShowGUI(this.isMask(1));
        eomg.setActionMask(64);
        return this.edit(eomg, requestor);
    }

    public OMGraphic edit(OMGraphic g, DrawingToolRequestor requestor) {
        return this.edit(g, requestor, g.getShowEditablePalette());
    }

    public OMGraphic edit(OMGraphic g, DrawingToolRequestor requestor, boolean showGUI) {
        if (g == null) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit(): can't edit null OMGraphic.");
            }
            return null;
        }
        if (this.getCurrentEditable() != null) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit(): can't edit " + g.getClass().getName() + ", drawing tool busy with another graphic.");
            }
            return null;
        }
        this.requestor = requestor;
        if (showGUI) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit(): showing GUI per request");
            }
            this.setMask(1);
        } else {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit(): NOT showing GUI per request");
            }
            this.unsetMask(1);
        }
        EditableOMGraphic eomg = this.getEditableGraphic(g);
        if (eomg != null) {
            eomg.setShowGUI(this.isMask(1));
            eomg.setActionMask(128);
            return this.edit(eomg, requestor);
        }
        return null;
    }

    public OMGraphic edit(EditableOMGraphic eomg, DrawingToolRequestor requestor) {
        if (this.setCurrentEditable(eomg)) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.edit success");
            }
            this.requestor = requestor;
            if (this.currentEditable != null) {
                this.graphicAttributes.setFrom(this.currentEditable.getGraphic());
                this.activate();
                if (this.currentEditable != null) {
                    return this.currentEditable.getGraphic();
                }
            }
        }
        if (this.DEBUG) {
            Debug.output("OMDrawingTool.edit(): can't edit " + eomg.getClass().getName() + ", drawing tool busy with another graphic.");
        }
        return null;
    }

    public OMGraphic edit(OMGraphic g, DrawingToolRequestor requestor, MouseEvent e) {
        EditableOMGraphic eomg;
        OMGraphic ret = null;
        if (this.getCurrentEditable() == null && (eomg = this.getEditableGraphic(g)) != null) {
            ret = this.edit(eomg, requestor, e);
        }
        return ret;
    }

    public OMGraphic edit(EditableOMGraphic eomg, DrawingToolRequestor requestor, MouseEvent e) {
        OMGraphic ret = null;
        if (eomg != null) {
            eomg.setActionMask(128);
            ret = this.edit(eomg, requestor);
            if (ret != null) {
                this.currentEditable.handleInitialMouseEvent(e);
            }
        }
        return ret;
    }

    public boolean isEditing(OMGraphic omg) {
        boolean ret = false;
        EditableOMGraphic eomg = this.getCurrentEditable();
        if (eomg != null && eomg.getGraphic() == omg || eomg instanceof EditableOMGraphicList && ((OMGraphicList)((EditableOMGraphicList)eomg).getGraphic()).contains(omg)) {
            ret = true;
        }
        return ret;
    }

    public void deselect(OMGraphic omg) {
        if (this.DEBUG) {
            Debug.output("OMDrawingTool.deselect()");
        }
        if (this.getCurrentEditable() != null) {
            if (this.currentEditable.getGraphic() == omg) {
                this.deactivate();
            } else if (this.currentEditable instanceof EditableOMGraphicList) {
                ((EditableOMGraphicList)this.currentEditable).remove(omg);
                this.canvas.repaint();
            }
        }
    }

    public boolean select(OMGraphic omg, DrawingToolRequestor req, MouseEvent e) {
        boolean currentlyEditing;
        if (this.DEBUG) {
            Debug.output("OMDrawingTool.select()");
        }
        OMGraphic ret = null;
        boolean bl = currentlyEditing = this.getCurrentEditable() != null;
        if (currentlyEditing) {
            boolean repaintCanvas = true;
            if (!(this.currentEditable instanceof EditableOMGraphicList)) {
                if (this.DEBUG) {
                    Debug.output("OMDrawingTool.select:  already working on OMGraphic, creating an EditableOMGraphicList for selection mode");
                }
                EditableOMGraphicList eomgl = new EditableOMGraphicList(new OMGraphicList());
                eomgl.setProjection(this.getProjection());
                DrawingToolRequestorList rl = new DrawingToolRequestorList();
                rl.add(this.currentEditable.getGraphic(), this.requestor);
                eomgl.add(this.currentEditable);
                this.currentEditable.removeEOMGListener(this);
                this.setCurrentEditable(null);
                this.requestor = rl;
                this.setCurrentEditable(eomgl);
                if (this.DEBUG) {
                    EditableOMGraphic ce = this.getCurrentEditable();
                    Debug.output("OMDrawingTool: current editable is: " + (ce == null ? "null" : ce.getClass().getName()));
                }
                this.activate(false);
                repaintCanvas = false;
            } else if (this.DEBUG) {
                Debug.output("OMDrawingTool.select:  already working on EditableOMGraphicList");
            }
            EditableOMGraphic addedEditable = ((EditableOMGraphicList)this.currentEditable).add(omg, this);
            if (this.requestor instanceof DrawingToolRequestorList) {
                ((DrawingToolRequestorList)this.requestor).add(omg, req);
            } else {
                Debug.error("OHHHH, THE HORRORS!");
                Thread.dumpStack();
            }
            ((EditableOMGraphicList)this.currentEditable).handleInitialMouseEvent(e);
            ret = this.currentEditable.getGraphic();
            if (repaintCanvas && this.canvas != null) {
                this.canvas.repaint();
            }
        } else {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.select:  activating for: " + omg.getClass().getName());
            }
            ret = this.edit(omg, req, e);
        }
        return ret != null;
    }

    public EditableOMGraphic getEditableGraphic(String classname, GraphicAttributes ga) {
        EditableOMGraphic eomg = null;
        EditToolLoader loader = (EditToolLoader)this.loaders.get(classname);
        if (loader == null) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.getEditableGraphic(" + classname + ") - rechecking loaders");
            }
            Iterator things = this.loaders.values().iterator();
            while (things.hasNext()) {
                EditToolLoader ldr = (EditToolLoader)things.next();
                eomg = ldr.getEditableGraphic(classname, ga);
                if (eomg == null) {
                    continue;
                }
                break;
            }
        } else {
            eomg = loader.getEditableGraphic(classname, ga);
        }
        if (eomg instanceof EditableOMGraphicList) {
            ((EditableOMGraphicList)eomg).init(this);
        }
        return eomg;
    }

    public EditableOMGraphic getEditableGraphic(OMGraphic g) {
        Set keys = this.loaders.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.getEditableGraphic(" + g.getClass().getName() + "): looking at (" + key + ") loader.");
            }
            try {
                Class<?> kc = Class.forName(key);
                Class<?> gc = g.getClass();
                if (kc != gc && !kc.isAssignableFrom(gc)) continue;
                EditToolLoader loader = (EditToolLoader)this.loaders.get(key);
                if (loader == null) {
                    return null;
                }
                this.generateOMGraphic(g);
                EditableOMGraphic eomg = loader.getEditableGraphic(g);
                if (this.DEBUG) {
                    Debug.output("OMDrawingTool.getEditableGraphic(" + g.getClass().getName() + "): found one.");
                }
                return eomg;
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.DEBUG) continue;
                Debug.output("OMDrawingTool.getEditableGraphic(" + g.getClass().getName() + ") comparision couldn't find class for " + key);
            }
        }
        return null;
    }

    public boolean canEdit(Class omgc) {
        Iterator<Object> iterator;
        if (this.possibleEditableClasses == null) {
            Set keys = this.loaders.keySet();
            this.possibleEditableClasses = new Vector(keys.size());
            iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                try {
                    this.possibleEditableClasses.add(Class.forName(key));
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
            }
        }
        iterator = this.possibleEditableClasses.iterator();
        while (iterator.hasNext()) {
            Class kc = (Class)iterator.next();
            if (kc != omgc && !kc.isAssignableFrom(omgc)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean setCurrentEditable(EditableOMGraphic eomg) {
        if (this.currentEditable == null || eomg == null) {
            if (this.selectionSupport != null) {
                if (eomg == null && this.currentEditable != null) {
                    this.selectionSupport.fireSelection(this.currentEditable.getGraphic(), this.requestor, false);
                } else if (eomg != null) {
                    this.selectionSupport.fireSelection(eomg.getGraphic(), this.requestor, true);
                }
            }
            this.currentEditable = eomg;
            if (this.currentEditable != null) {
                return true;
            }
        }
        return false;
    }

    public EditableOMGraphic getCurrentEditable() {
        return this.currentEditable;
    }

    public void setMouseMode(OMDrawingToolMouseMode adtmm) {
        this.dtmm = adtmm;
    }

    public OMDrawingToolMouseMode getMouseMode() {
        return this.dtmm;
    }

    public void addLoader(EditToolLoader loader) {
        String[] classnames = loader.getEditableClasses();
        this.rawLoaders.add(loader);
        if (classnames != null) {
            int i = 0;
            while (i < classnames.length) {
                this.loaders.put(classnames[i].intern(), loader);
                ++i;
            }
            this.possibleEditableClasses = null;
        }
        this.firePropertyChange(LoadersProperty, null, this.rawLoaders);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            super.addPropertyChangeListener(listener);
            listener.propertyChange(new PropertyChangeEvent(this, LoadersProperty, null, this.rawLoaders));
        }
    }

    public void removeLoader(EditToolLoader loader) {
        String[] classnames = loader.getEditableClasses();
        if (classnames != null) {
            int i = 0;
            while (i < classnames.length) {
                EditToolLoader etl = (EditToolLoader)this.loaders.get(classnames[i].intern());
                if (etl == loader) {
                    this.loaders.remove(classnames[i]);
                } else if (this.DEBUG) {
                    Debug.output("DrawingTool.removeLoader: loader to be removed isn't the current loader for " + classnames[i] + ", ignored.");
                }
                ++i;
            }
            this.rawLoaders.remove(loader);
            this.firePropertyChange(LoadersProperty, null, this.rawLoaders);
            this.possibleEditableClasses = null;
        }
    }

    public EditToolLoader[] getLoaders() {
        Set keys = this.loaders.keySet();
        EditToolLoader[] etls = new EditToolLoader[keys.size()];
        Iterator iterator = keys.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            etls[count++] = (EditToolLoader)this.loaders.get(iterator.next());
        }
        return etls;
    }

    public void setLoaders(EditToolLoader[] etls) {
        this.loaders.clear();
        this.rawLoaders.clear();
        int i = 0;
        while (i < etls.length) {
            this.addLoader(etls[i]);
            ++i;
        }
    }

    public void resetGUIWhenDeactivated(boolean value) {
        this.resetGUIWhenDeactivated = value;
    }

    public Component getGUI() {
        if (!this.resetGUIWhenDeactivated) {
            return this;
        }
        this.removeAll();
        Component eomgc = null;
        this.graphicAttributes.setLineMenuAdditions(null);
        if (this.currentEditable != null && (eomgc = this.currentEditable.getGUI(this.graphicAttributes)) != null) {
            this.add(eomgc);
        }
        if (eomgc == null) {
            this.add(this.graphicAttributes.getGUI());
        }
        this.revalidate();
        return this;
    }

    public void setInformationDelegator(InformationDelegator id) {
        this.informationDelegator = id;
    }

    public InformationDelegator getInformationDelegator() {
        return this.informationDelegator;
    }

    public void setRemarks(String message) {
        if (this.informationDelegator != null) {
            this.informationDelegator.displayInfoLine(message, 0);
        }
    }

    public boolean isActivated() {
        return this.activated;
    }

    protected synchronized void activate() {
        this.activate(true);
    }

    protected synchronized void activate(boolean completeHookup) {
        this.activated = true;
        if (this.DEBUG) {
            Debug.output("OMDrawingTool: activate()");
        }
        if (this.currentEditable != null && this.graphicAttributes != null) {
            if (completeHookup) {
                this.graphicAttributes.setTo(this.currentEditable.getGraphic());
                this.currentEditable.getGraphic().setVisible(false);
            }
            this.currentEditable.addEOMGListener(this);
        }
        if (!this.isMask(16) && completeHookup) {
            if (this.mouseDelegator != null) {
                if (Debug.debugging("drawingtooldetail")) {
                    Debug.output("OMDrawingTool.activate() mousemode connecting to MouseDelegator");
                }
                this.formerMouseMode = this.mouseDelegator.getActiveMouseMode();
                this.mouseDelegator.setActiveMouseMode(this.dtmm);
            } else if (this.canvas != null) {
                if (Debug.debugging("drawingtooldetail")) {
                    Debug.output("OMDrawingTool.activate() mousemode connecting directly to canvas");
                }
                this.canvas.addMouseListener(this.dtmm);
                this.canvas.addMouseMotionListener(this.dtmm);
            } else {
                Debug.error("Drawing Tool can't find a map to work with");
            }
        }
        if (this.canvas != null) {
            if (this.canvas instanceof MapBean && completeHookup) {
                ((MapBean)this.canvas).addPaintListener(this);
                ((MapBean)this.canvas).addProjectionListener(this);
            }
            this.canvas.repaint();
        }
        if (completeHookup) {
            this.showPalette();
        }
    }

    public void deactivate() {
        int actionMask = 0;
        if (this.currentEditable != null) {
            actionMask = this.currentEditable.getActionMask();
        }
        this.deactivate(actionMask);
    }

    public synchronized void deactivate(int actionToDoWithOMGraphic) {
        if (this.DEBUG) {
            Debug.output("OMDrawingTool: deactivate(" + (this.activated ? "while active" : "while inactive") + ")");
        }
        if (!this.activated) {
            return;
        }
        if (!this.isMask(16)) {
            if (this.mouseDelegator != null) {
                this.mouseDelegator.setActiveMouseMode(this.formerMouseMode);
                this.mouseDelegator.removeMouseMode(this.dtmm);
            } else if (this.canvas != null) {
                this.canvas.removeMouseListener(this.dtmm);
                this.canvas.removeMouseMotionListener(this.dtmm);
            }
        }
        if (this.canvas != null && this.canvas instanceof MapBean) {
            ((MapBean)this.canvas).removeProjectionListener(this);
            ((MapBean)this.canvas).removePaintListener(this);
        }
        OMGraphic g = null;
        if (this.currentEditable != null) {
            if (!(this.currentEditable.getStateMachine().getState() instanceof GraphicUndefinedState)) {
                g = this.currentEditable.getGraphic();
            }
            this.currentEditable.removeEOMGListener(this);
        }
        this.setCurrentEditable(null);
        this.hidePalette();
        this.unsetMask(32);
        this.popup = null;
        this.activated = false;
        if (g != null && this.requestor != null) {
            g.setVisible(true);
            OMAction action = new OMAction();
            action.setMask(actionToDoWithOMGraphic);
            this.generateOMGraphic(g);
            this.notifyListener(g, action);
        }
        this.getGUI();
    }

    protected void generateOMGraphic(OMGraphic g) {
        if (g != null && g.getNeedToRegenerate()) {
            Projection proj = this.getProjection();
            if (proj != null) {
                g.generate(proj);
            } else if (this.DEBUG) {
                Debug.output("OMDrawingTool: graphic needs generation: " + g.getNeedToRegenerate());
            }
        }
    }

    public void notifyListener(OMGraphic graphic, OMAction action) {
        if (this.requestor != null) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool: notifying requestor, graphic with action");
            }
            this.requestor.drawingComplete(graphic, action);
        }
        if (this.canvas != null) {
            this.canvas.repaint();
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        this.setProjection(e.getProjection().makeClone());
    }

    public void setProjection(Projection proj) {
        this.projection = proj;
        if (this.currentEditable != null) {
            this.currentEditable.setProjection(this.projection);
        }
    }

    public Projection getProjection() {
        if (this.projection == null && this.canvas instanceof MapBean) {
            this.projection = ((MapBean)this.canvas).getProjection();
        }
        return this.projection;
    }

    public void setAttributes(GraphicAttributes da) {
        if (this.graphicAttributes != null) {
            this.graphicAttributes.getPropertyChangeSupport().removePropertyChangeListener(this);
        }
        this.graphicAttributes = da == null ? GraphicAttributes.DEFAULT : da;
        this.graphicAttributes.getPropertyChangeSupport().addPropertyChangeListener(this);
        if (this.currentEditable != null) {
            this.graphicAttributes.setTo(this.currentEditable.getGraphic());
        }
    }

    public GraphicAttributes getAttributes() {
        return this.graphicAttributes;
    }

    public void listenerPaint(Graphics g) {
        if (this.currentEditable != null) {
            this.currentEditable.repaintRender(g.create());
        }
    }

    public void setMouseDelegator(MouseDelegator md) {
        this.mouseDelegator = md;
    }

    public MouseDelegator getMouseDelegator() {
        return this.mouseDelegator;
    }

    public void setCursor(Cursor cursor) {
        if (this.canvas != null) {
            this.canvas.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.canvas != null) {
            return this.canvas.getCursor();
        }
        return null;
    }

    public void setCanvas(JComponent can) {
        this.canvas = can;
    }

    public JComponent getCanvas() {
        return this.canvas;
    }

    public void setUseAsTool(boolean value) {
        super.setUseAsTool(value);
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof InformationDelegator) {
            if (this.DEBUG) {
                Debug.output("DrawingTool: found InformationDelegator");
            }
            if (this.dtmm != null) {
                this.dtmm.setInfoDelegator((InformationDelegator)someObj);
            }
            this.setInformationDelegator((InformationDelegator)someObj);
        }
        if (someObj instanceof MouseDelegator) {
            if (this.DEBUG) {
                Debug.output("DrawingTool: found MouseDelegator.");
            }
            this.setMouseDelegator((MouseDelegator)someObj);
        }
        if (someObj instanceof MapBean) {
            if (this.DEBUG) {
                Debug.output("DrawingTool: found MapBean.");
            }
            this.setCanvas((JComponent)someObj);
        }
        if (someObj instanceof EditToolLoader) {
            if (this.DEBUG) {
                Debug.output("DrawingTool: found EditToolLoader: " + someObj.getClass().getName());
            }
            this.addLoader((EditToolLoader)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj == this.getInformationDelegator()) {
            if (this.dtmm != null && this.dtmm.getInfoDelegator() == (InformationDelegator)someObj) {
                this.dtmm.setInfoDelegator(null);
            }
            this.setInformationDelegator(null);
        }
        if (someObj == this.getMouseDelegator()) {
            this.setMouseDelegator(null);
        }
        if (someObj == this.getCanvas()) {
            this.setCanvas(null);
        }
        if (someObj instanceof EditToolLoader) {
            this.removeLoader((EditToolLoader)someObj);
        }
    }

    public void showPalette() {
        Debug.message("drawingtool", "OMDrawingTool.showPalette()");
        this.resetGUIWhenDeactivated = true;
        this.getGUI();
        boolean shouldBeVisible = !this.getUseAsTool() || this.isMask(1) && this.getUseAsTool();
        this.setVisible(shouldBeVisible);
    }

    public void hidePalette() {
        Debug.message("drawingtool", "OMDrawingTool.hidePalette()");
        this.setVisible(this.visibleWhenInactive);
        WindowSupport ws = this.getWindowSupport();
        if (ws != null) {
            ws.killWindow();
        }
    }

    public void showInWindow() {
        WindowSupport ws;
        if (!this.getUseAsTool() && this.getWindowSupport() == null) {
            this.setWindowSupport(new WindowSupport(this.getGUI(), this.i18n.get(class$com$bbn$openmap$tools$drawing$OMDrawingTool == null ? (class$com$bbn$openmap$tools$drawing$OMDrawingTool = OMDrawingTool.class$("com.bbn.openmap.tools.drawing.OMDrawingTool")) : class$com$bbn$openmap$tools$drawing$OMDrawingTool, "drawingtool", "Drawing Tool")));
        }
        if ((ws = this.getWindowSupport()) != null && !this.getUseAsTool()) {
            MapHandler mh = (MapHandler)this.getBeanContext();
            Frame frame = null;
            int xoffset = 0;
            int yoffset = 0;
            if (mh != null && (frame = (Frame)mh.get(class$java$awt$Frame == null ? (class$java$awt$Frame = OMDrawingTool.class$("java.awt.Frame")) : class$java$awt$Frame)) != null) {
                xoffset = frame.getX();
                yoffset = frame.getY();
            }
            ws.displayInWindow(frame, this.windowx + xoffset, this.windowy + yoffset, -1, -1);
        } else {
            Debug.output("OMDrawingTool.showPalette(): NOT showing palette, ws == null:" + (ws == null) + ", used as tool:" + this.getUseAsTool());
        }
    }

    public void setBehaviorMask(int mask) {
        this.behaviorMask = mask;
    }

    public int getBehaviorMask() {
        return this.behaviorMask;
    }

    public void resetBehaviorMask() {
        this.behaviorMask = 11;
    }

    public int setMask(int mask) {
        this.behaviorMask = OMAction.setMask(this.behaviorMask, mask);
        return this.behaviorMask;
    }

    public int unsetMask(int mask) {
        this.behaviorMask = OMAction.unsetMask(this.behaviorMask, mask);
        return this.behaviorMask;
    }

    public boolean isMask(int mask) {
        return OMAction.isMask(this.behaviorMask, mask);
    }

    public void propertyChange(PropertyChangeEvent pce) {
        Object source = pce.getSource();
        if (source instanceof DrawingAttributes && this.currentEditable != null) {
            this.graphicAttributes.setTo(this.currentEditable.getGraphic());
            if (this.projection != null) {
                this.currentEditable.regenerate(this.projection);
            }
            if (this.canvas != null) {
                this.canvas.repaint();
            }
        }
    }

    public void eomgChanged(EOMGEvent event) {
        String message;
        Cursor cursor;
        if (Debug.debugging("drawingtooldetail")) {
            Debug.output("OMDrawingTool.eomgChanged()");
        }
        if ((cursor = event.getCursor()) != null) {
            this.setCursor(cursor);
        }
        if ((message = event.getMessage()) != null && !message.equals(this.lastRemarks)) {
            this.lastRemarks = message;
            this.setRemarks(message);
        }
        if (event.shouldShowGUI() && this.isMask(8)) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.eomgChanged(): try for menu.");
            }
            MouseEvent me = event.getMouseEvent();
            if (this.currentEditable != null) {
                this.currentEditable.getStateMachine().setSelected();
                this.currentEditable.redraw(me, true);
                GeneralPath ces = this.currentEditable.getGraphic().getShape();
                if (ces != null) {
                    Rectangle rect = ces.getBounds();
                    this.windowx = (int)rect.getX();
                    this.windowy = (int)rect.getY() - 50;
                }
            }
            this.doPopup(me.getX(), me.getY(), null);
        } else if (event.shouldDeactivate()) {
            if (this.DEBUG) {
                Debug.output("OMDrawingTool.eomgChanged(): omdt being told to deactivate");
            }
            if (this.isMask(4) && !this.getUseAsTool()) {
                EditableOMGraphic eomg = this.getCurrentEditable();
                if (eomg != null) {
                    GeneralPath shape = eomg.getGraphic().getShape();
                    Rectangle rect = shape.getBounds();
                    Vector<JComponent> vec = new Vector<JComponent>();
                    vec.add(new JSeparator());
                    JMenuItem done = new JMenuItem("Done");
                    done.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent ae) {
                            OMDrawingTool.this.deactivate();
                        }
                    });
                    vec.add(done);
                    if (!this.doPopup((int)(rect.getX() + rect.getWidth()), (int)(rect.getY() + rect.getHeight()), vec)) {
                        this.deactivate();
                    }
                }
            } else {
                this.deactivate();
            }
        }
    }

    protected boolean doPopup(int x, int y, List additionalOptions) {
        boolean showPopup;
        if (additionalOptions != null && additionalOptions.size() > 0) {
            this.popup = null;
        }
        boolean bl = showPopup = this.popup != null;
        if (this.popup == null && !this.getUseAsTool()) {
            this.popup = this.createPopupMenu();
            if (additionalOptions != null && additionalOptions.size() > 0 && this.popup != null) {
                Iterator it = additionalOptions.iterator();
                while (it.hasNext()) {
                    Object obj = it.next();
                    if (!(obj instanceof JMenuItem)) continue;
                    this.popup.add((JMenuItem)obj);
                }
            }
            boolean bl2 = showPopup = this.popup != null;
        }
        if (showPopup) {
            JComponent map = null;
            if (this.mouseDelegator != null) {
                map = this.mouseDelegator.getMap();
            } else if (this.canvas != null) {
                map = this.canvas;
            }
            if (map != null && x >= 0 && y >= 0) {
                this.popup.show(map, x, y);
            } else {
                Debug.error("OMDrawingTool: no " + (map == null ? "/component" : "/") + (x < 0 || y < 0 ? "location/" : "/") + " to show popup on!");
            }
            return true;
        }
        return false;
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pum = new JPopupMenu();
        JMenuItem delete = new JMenuItem("Delete");
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                OMGraphic g;
                OMAction action = new OMAction();
                action.setMask(4);
                EditableOMGraphic eomg = OMDrawingTool.this.getCurrentEditable();
                if (eomg != null && (g = eomg.getGraphic()) != null) {
                    OMDrawingTool.this.notifyListener(g, action);
                }
                OMDrawingTool.this.setCurrentEditable(null);
                OMDrawingTool.this.deactivate();
            }
        });
        JMenuItem gui = new JMenuItem("Change Appearance");
        gui.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                EditableOMGraphic eomg = OMDrawingTool.this.getCurrentEditable();
                if (eomg != null) {
                    boolean previous = eomg.getShowGUI();
                    eomg.setShowGUI(true);
                    OMDrawingTool.this.setVisible(true);
                    if (!OMDrawingTool.this.getUseAsTool()) {
                        OMDrawingTool.this.showInWindow();
                    }
                    eomg.setShowGUI(previous);
                    eomg.getStateMachine().setSelected();
                }
            }
        });
        if (this.isMask(3) && !this.getUseAsTool()) {
            pum.add(gui);
        } else {
            Debug.output("Not adding Change Appearance to popup: guiViaPopup(" + this.isMask(1) + ") isTool(" + this.getUseAsTool() + ")");
        }
        pum.add(delete);
        return pum;
    }

    public void addSelectionListener(SelectionListener list) {
        if (this.selectionSupport != null) {
            this.selectionSupport.addSelectionListener(list);
        }
    }

    public void removeSelectionListener(SelectionListener list) {
        if (this.selectionSupport != null) {
            this.selectionSupport.removeSelectionListener(list);
        }
    }

    public void clearSelectionListeners() {
        if (this.selectionSupport != null) {
            this.selectionSupport.clearSelectionListeners();
        }
    }

    public static void main(String[] args) {
        OMDrawingTool omdt = new OMDrawingTool();
        omdt.showPalette();
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.visibleWhenInactive = PropUtils.booleanFromProperties(props, prefix + VisibleWhenInactiveProperty, this.visibleWhenInactive);
        this.getGUI();
        this.setVisible(this.visibleWhenInactive);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

