/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.meteo;

import com.bbn.openmap.omGraphics.awt.AbstractShapeDecoration;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class IceAreaShapeDecoration
extends AbstractShapeDecoration {
    public static Color COLOR = new Color(102, 51, 0);
    private boolean filled = false;

    public IceAreaShapeDecoration(int length, int width, int orientation) {
        super(length, width, orientation);
        this.setPaint(COLOR);
    }

    public void draw(Graphics g, Point2D[] points, boolean complete) {
        Graphics2D g2D = (Graphics2D)g;
        this.setGraphics(g);
        int nbpts = points.length;
        double xcoord1 = points[0].getX();
        double ycoord1 = points[0].getY();
        double xcoord2 = points[nbpts - 1].getX();
        double ycoord2 = points[nbpts - 1].getY();
        g.drawLine((int)xcoord1, (int)ycoord1, (int)xcoord2, (int)ycoord2);
        if (complete) {
            int orient = this.getOrientation() == 2 ? -1 : 1;
            double dx = xcoord2 - xcoord1;
            double dy = ycoord2 - ycoord1;
            double norm = Math.sqrt(dx * dx + dy * dy);
            double rcos = dx / norm;
            double rsin = dy / norm;
            double r = (double)this.getLength() / 2.0;
            double w = (float)orient * this.getWidth();
            int x2 = (int)(xcoord1 + r * rcos);
            int y2 = (int)(ycoord1 + r * rsin);
            int x1 = (int)((double)x2 - w * rsin);
            int y1 = (int)((double)y2 + w * rcos);
            g.drawLine(x2, y2, x1, y1);
        }
        this.restoreGraphics(g);
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }
}

