/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.geom;

import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.geom.BasicGeometry;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.util.ArrayList;

public abstract class PolygonGeometry
extends BasicGeometry
implements Serializable,
OMGeometry {
    protected int[][] xpoints = new int[0][0];
    protected int[][] ypoints = new int[0][0];
    protected boolean isPolygon = true;
    protected boolean doShapes = true;

    protected PolygonGeometry() {
    }

    public void setDoShapes(boolean set) {
        this.doShapes = set;
    }

    public boolean getDoShapes() {
        return this.doShapes;
    }

    protected void setIsPolygon(boolean set) {
        this.isPolygon = set;
    }

    public boolean getIsPolygon() {
        return this.isPolygon;
    }

    protected abstract void createShape();

    public float distance(int x, int y) {
        if (this.shape != null) {
            return super.distance(x, y);
        }
        float distance = Float.POSITIVE_INFINITY;
        if (this.getNeedToRegenerate()) {
            return distance;
        }
        int[][] xpts = this.xpoints;
        int[][] ypts = this.ypoints;
        int len = xpts.length;
        int i = 0;
        while (i < len) {
            int[] _x = xpts[i];
            int[] _y = ypts[i];
            if (DrawUtil.inside_polygon(_x, _y, x, y)) {
                return 0.0f;
            }
            float temp = DrawUtil.closestPolyDistance(_x, _y, x, y, false);
            if (temp < distance) {
                distance = temp;
            }
            ++i;
        }
        return distance;
    }

    public GeneralPath getShape() {
        if (this.shape == null && !this.getNeedToRegenerate() && !this.doShapes) {
            this.createShape();
        }
        return this.shape;
    }

    public static class Offset
    extends XY {
        public static final int COORDMODE_ORIGIN = 0;
        public static final int COORDMODE_PREVIOUS = 1;
        protected float lat = 0.0f;
        protected float lon = 0.0f;
        protected int coordMode = 0;

        public Offset(float latPoint, float lonPoint, int[] xypoints, int cMode) {
            this.setLocation(latPoint, lonPoint, 0, xypoints);
            this.setCoordMode(cMode);
        }

        public Offset(float latPoint, float lonPoint, int[] xPoints, int[] yPoints, int cMode) {
            this.setLocation(latPoint, lonPoint, 0, xPoints, yPoints);
            this.setCoordMode(cMode);
        }

        public void setLocation(float latPoint, float lonPoint, int units, int[] xypoints) {
            if (units == 0) {
                this.lat = ProjMath.degToRad(latPoint);
                this.lon = ProjMath.degToRad(lonPoint);
            } else {
                this.lat = latPoint;
                this.lon = lonPoint;
            }
            int end = xypoints.length >> 1;
            this.xs = new int[end];
            this.ys = new int[end];
            int i = 0;
            int j = 0;
            while (i < end) {
                this.xs[i] = xypoints[j];
                this.ys[i] = xypoints[j + 1];
                ++i;
                j += 2;
            }
            this.setNeedToRegenerate(true);
        }

        public void setLocation(float latPoint, float lonPoint, int units, int[] xPoints, int[] yPoints) {
            if (units == 0) {
                this.lat = ProjMath.degToRad(latPoint);
                this.lon = ProjMath.degToRad(lonPoint);
            } else {
                this.lat = latPoint;
                this.lon = lonPoint;
            }
            this.xs = xPoints;
            this.ys = yPoints;
            this.setNeedToRegenerate(true);
        }

        public void setCoordMode(int coordMode) {
            this.coordMode = coordMode;
        }

        public int getCoordMode() {
            return this.coordMode;
        }

        public void setLat(float lat) {
            this.lat = ProjMath.degToRad(lat);
            this.setNeedToRegenerate(true);
        }

        public float getLat() {
            return ProjMath.radToDeg(this.lat);
        }

        public void setLon(float lon) {
            this.lon = ProjMath.degToRad(lon);
            this.setNeedToRegenerate(true);
        }

        public float getLon() {
            return ProjMath.radToDeg(this.lon);
        }

        public boolean generate(Projection proj) {
            this.shape = null;
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                return false;
            }
            if (this.xs == null) {
                Debug.message("omgraphic", "OMPoly offset rendertype null coordinates");
                return false;
            }
            int npts = this.xs.length;
            int[] _x = new int[npts];
            int[] _y = new int[npts];
            Point origin = proj.forward(this.lat, this.lon, new Point(0, 0), true);
            if (this.coordMode == 0) {
                int i = 0;
                while (i < npts) {
                    _x[i] = this.xs[i] + origin.x;
                    _y[i] = this.ys[i] + origin.y;
                    ++i;
                }
            } else {
                _x[0] = this.xs[0] + origin.x;
                _y[0] = this.ys[0] + origin.y;
                int i = 1;
                while (i < npts) {
                    _x[i] = this.xs[i] + _x[i - 1];
                    _y[i] = this.ys[i] + _y[i - 1];
                    ++i;
                }
            }
            this.xpoints = new int[1][0];
            this.xpoints[0] = _x;
            this.ypoints = new int[1][0];
            this.ypoints[0] = _y;
            if (this.doShapes) {
                this.createShape();
            }
            this.setNeedToRegenerate(false);
            return true;
        }

        public int getRenderType() {
            return 3;
        }
    }

    public static class XY
    extends PolygonGeometry {
        protected int[] xs = null;
        protected int[] ys = null;

        protected XY() {
        }

        public XY(int[] xypoints) {
            this.setLocation(xypoints);
        }

        public XY(int[] xPoints, int[] yPoints) {
            this.setLocation(xPoints, yPoints);
        }

        public void setLocation(int[] xypoints) {
            int end = xypoints.length >> 1;
            this.xs = new int[end];
            this.ys = new int[end];
            int i = 0;
            int j = 0;
            while (i < end) {
                this.xs[i] = xypoints[j];
                this.ys[i] = xypoints[j + 1];
                ++i;
                j += 2;
            }
            this.setNeedToRegenerate(true);
        }

        public void setLocation(int[] xPoints, int[] yPoints) {
            this.xs = xPoints;
            this.ys = yPoints;
            this.setNeedToRegenerate(true);
        }

        public void setXs(int[] x) {
            this.xs = x;
            this.setNeedToRegenerate(true);
        }

        public int[] getXs() {
            return this.xs;
        }

        public void setYs(int[] y) {
            this.ys = y;
            this.setNeedToRegenerate(true);
        }

        public int[] getYs() {
            return this.ys;
        }

        public boolean generate(Projection proj) {
            this.shape = null;
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                return false;
            }
            if (this.xs == null) {
                Debug.message("omgraphic", "OMPoly x/y rendertype null coordinates");
                return false;
            }
            int npts = this.xs.length;
            this.xpoints = new int[1][0];
            this.xpoints[0] = this.xs;
            this.ypoints = new int[1][0];
            this.ypoints[0] = this.ys;
            if (this.doShapes) {
                this.createShape();
            }
            this.setNeedToRegenerate(false);
            return true;
        }

        protected void createShape() {
            if (this.getNeedToRegenerate()) {
                return;
            }
            this.shape = BasicGeometry.createShape(this.xpoints[0], this.ypoints[0], this.isPolygon);
        }

        public int getRenderType() {
            return 2;
        }
    }

    public static class LL
    extends PolygonGeometry {
        protected float[] rawllpts = null;
        protected int nsegs = -1;

        public LL(float[] llPoints, int units, int lType, int nsegs) {
            this.setLineType(lType);
            this.setLocation(llPoints, units);
            this.setNumSegs(nsegs);
        }

        public LL(float[] llPoints, int units, int lType) {
            this(llPoints, units, lType, -1);
        }

        public void setLocation(float[] llPoints, int units) {
            if (units == 0) {
                ProjMath.arrayDegToRad(llPoints);
            }
            this.rawllpts = llPoints;
            this.setNeedToRegenerate(true);
        }

        public float[] getLatLonArray() {
            return this.rawllpts;
        }

        public void setNumSegs(int nsegs) {
            this.nsegs = nsegs;
        }

        public int getNumSegs() {
            return this.nsegs;
        }

        public boolean generate(Projection proj) {
            this.shape = null;
            if (proj == null) {
                Debug.message("omgraphic", "OMPoly: null projection in generate!");
                return false;
            }
            ArrayList vector = proj.forwardPoly(this.rawllpts, this.lineType, this.nsegs, this.isPolygon);
            int size = vector.size();
            if (!this.doShapes) {
                this.xpoints = new int[size / 2][0];
                this.ypoints = new int[this.xpoints.length][0];
            }
            int i = 0;
            int j = 0;
            while (i < size) {
                if (this.doShapes) {
                    GeneralPath gp = BasicGeometry.createShape((int[])vector.get(i), (int[])vector.get(i + 1), this.isPolygon);
                    if (this.shape == null) {
                        this.shape = gp;
                    } else {
                        this.shape.append(gp, false);
                    }
                } else {
                    this.xpoints[j] = (int[])vector.get(i);
                    this.ypoints[j] = (int[])vector.get(i + 1);
                }
                i += 2;
                ++j;
            }
            this.setNeedToRegenerate(false);
            return true;
        }

        protected void createShape() {
            if (this.getNeedToRegenerate()) {
                return;
            }
            int size = this.xpoints.length;
            int i = 0;
            while (i < size) {
                GeneralPath gp = BasicGeometry.createShape(this.xpoints[i], this.ypoints[i], this.isPolygon);
                if (this.shape == null) {
                    this.shape = gp;
                } else {
                    this.shape.append(gp, false);
                }
                ++i;
            }
        }

        public int getRenderType() {
            return 1;
        }
    }
}

