/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.dataAccess.shape.EsriShapeExport;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.shape.ShapeFile;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFLayer;
import com.bbn.openmap.layer.vpf.VPFLayerDCWWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.SinkGraphic;
import com.bbn.openmap.proj.DrawUtil;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class VMAP2Shape {
    protected static String vmaptype = "bnd";
    protected static String propsFileName = System.getProperty("user.home") + System.getProperty("file.separator") + "openmap.properties";
    protected static String prefix = "vmapref";
    protected static boolean doThinning = false;
    protected static float fan_eps = 0.1f;
    protected static float zero_eps = 1.0E-4f;
    protected static float threshold = 0.5f;
    protected LibrarySelectionTable lst;
    protected transient LayerGraphicWarehouseSupport warehouse;

    public void writeShapeFile(String shapeFileName, OMGraphicList graphics) {
        OMGraphicList saveGraphics = new OMGraphicList();
        try {
            OMGraphic omg;
            ShapeFile s = new ShapeFile(shapeFileName);
            int nGraphics = graphics.size();
            boolean nDumped = false;
            if (nGraphics > 0 && (omg = graphics.getOMGraphicAt(0)) instanceof OMPoly && omg.getRenderType() == 1) {
                int shapeType = ((OMPoly)omg).isPolygon() ? 5 : 3;
                System.out.println("shapeType=" + shapeType);
                s.setShapeType(shapeType);
            }
            System.out.println(nGraphics + " candidates.");
            int i = 0;
            while (i < nGraphics) {
                OMGraphic omg2 = graphics.getOMGraphicAt(i);
                if (omg2 instanceof OMPoly && omg2.getRenderType() == 1) {
                    OMPoly poly = (OMPoly)omg2;
                    if (!doThinning || !this.maybeThrowAwayPoly(poly)) {
                        saveGraphics.addOMGraphic(poly);
                    }
                } else {
                    System.out.println("Skipping candidate: " + omg2.getClass().toString() + ", " + omg2.getRenderType());
                }
                ++i;
            }
            graphics = saveGraphics;
            if (doThinning) {
                nGraphics = graphics.size();
                System.out.println(nGraphics + " candidates.");
                graphics = VMAP2Shape.joinCommonLines(graphics);
            }
            EsriShapeExport ese = new EsriShapeExport(graphics, (Projection)null, shapeFileName);
            ese.export();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static OMGraphicList joinCommonLines(OMGraphicList list) {
        OMGraphic obj;
        int size = list.size();
        OMGraphicList newGraphics = new OMGraphicList();
        OMGraphicList plineGraphics = new OMGraphicList();
        System.out.println("finding polylines...");
        int i = 0;
        while (i < size) {
            obj = list.getOMGraphicAt(i);
            if (obj instanceof OMPoly && !((OMPoly)obj).isPolygon()) {
                plineGraphics.addOMGraphic(obj);
            } else {
                newGraphics.addOMGraphic(obj);
            }
            ++i;
        }
        size = plineGraphics.size();
        System.out.println("maybe joining " + size + " polylines...");
        int i2 = 0;
        while (i2 < size) {
            if (i2 % 500 == 0) {
                System.out.println("checking pline i=" + i2);
            }
            int j = 0;
            while (j < size) {
                if (i2 != j && !((obj = plineGraphics.getOMGraphicAt(i2)) instanceof SinkGraphic)) {
                    OMPoly poly1 = (OMPoly)obj;
                    float[] rads1 = poly1.getLatLonArray();
                    int len1 = rads1.length;
                    float lat1 = ProjMath.radToDeg(rads1[len1 - 2]);
                    float lon1 = ProjMath.radToDeg(rads1[len1 - 1]);
                    obj = plineGraphics.getOMGraphicAt(j);
                    if (!(obj instanceof SinkGraphic)) {
                        OMPoly poly2 = (OMPoly)obj;
                        float[] rads2 = poly2.getLatLonArray();
                        int len2 = rads2.length;
                        float lat2 = ProjMath.radToDeg(rads2[0]);
                        float lon2 = ProjMath.radToDeg(rads2[1]);
                        if (MoreMath.approximately_equal(lat1, lat2, zero_eps) && MoreMath.approximately_equal(lon1, lon2, zero_eps)) {
                            float[] radians = new float[len1 + len2 - 2];
                            System.arraycopy(rads1, 0, radians, 0, len1);
                            System.arraycopy(rads2, 0, radians, len1 - 2, len2);
                            poly1.setLocation(radians, 1);
                            plineGraphics.setOMGraphicAt(SinkGraphic.getSharedInstance(), j);
                            j = -1;
                        }
                    }
                }
                ++j;
            }
            ++i2;
        }
        size = plineGraphics.size();
        int i3 = 0;
        while (i3 < size) {
            obj = plineGraphics.getOMGraphicAt(i3);
            if (obj instanceof OMPoly) {
                newGraphics.addOMGraphic(obj);
            }
            ++i3;
        }
        return newGraphics;
    }

    public static float[] coalesce_points(float[] radians, float eps, boolean ispolyg) {
        int write = 2;
        int len = radians.length;
        int i = write - 2;
        int j = write;
        while (j < len) {
            float lat1 = ProjMath.radToDeg(radians[i]);
            float lon1 = ProjMath.radToDeg(radians[i + 1]);
            float lat2 = ProjMath.radToDeg(radians[j]);
            float lon2 = ProjMath.radToDeg(radians[j + 1]);
            if (!MoreMath.approximately_equal(lat1, lat2, eps) || !MoreMath.approximately_equal(lon1, lon2, eps)) {
                i = write;
                radians[write++] = radians[j];
                radians[write++] = radians[j + 1];
            }
            j += 2;
        }
        if (ispolyg && write == 6 && MoreMath.approximately_equal(radians[0], radians[4], eps) && MoreMath.approximately_equal(radians[1], radians[5], eps)) {
            write -= 2;
        }
        float[] newrads = new float[write];
        System.arraycopy(radians, 0, newrads, 0, write);
        return newrads;
    }

    protected boolean maybeThrowAwayPoly(OMPoly poly) {
        float[] radians = poly.getLatLonArray();
        float thresh = ProjMath.degToRad(threshold);
        radians = VMAP2Shape.coalesce_points(radians, 1.0E-4f, poly.isPolygon());
        poly.setLocation(radians, 1);
        if (radians.length < 4) {
            return true;
        }
        if (poly.isPolygon() && radians.length < 6) {
            return true;
        }
        int len = radians.length;
        int i = 0;
        while (i < len) {
            float lat = ProjMath.radToDeg(radians[i]);
            float lon = ProjMath.radToDeg(radians[i + 1]);
            if (MoreMath.approximately_equal(lat, Math.round(lat), zero_eps)) {
                return false;
            }
            if (MoreMath.approximately_equal(lon, Math.round(lon), zero_eps)) {
                return false;
            }
            int j = i + 2;
            while (j < radians.length) {
                float d = DrawUtil.distance(radians[i], radians[i + 1], radians[j], radians[j + 1]);
                if (!MoreMath.approximately_equal(d, 0.0f, thresh)) {
                    return false;
                }
                j += 2;
            }
            i += 2;
        }
        if (poly.isPolygon()) {
            return true;
        }
        return MoreMath.approximately_equal(ProjMath.radToDeg(radians[0]), ProjMath.radToDeg(radians[radians.length - 2]), zero_eps) && MoreMath.approximately_equal(ProjMath.radToDeg(radians[1]), ProjMath.radToDeg(radians[radians.length - 1]), zero_eps);
    }

    protected Properties loadProperties() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propsFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return props;
    }

    protected void setProperties(String prefix, Properties props) {
        String coverage;
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String[] paths = LayerUtils.initPathsFromProperties(props, realPrefix + "vpfPath");
        String defaultProperty = props.getProperty(realPrefix + "defaultLayer");
        if (defaultProperty != null) {
            System.out.println("defaultProperty=" + defaultProperty);
            realPrefix = defaultProperty + ".";
            props = VPFLayer.getDefaultProperties();
        }
        if ((coverage = props.getProperty(realPrefix + "coverageType")) != null) {
            vmaptype = coverage;
            System.out.println("vmaptype=" + vmaptype);
        }
        this.initLST(paths);
        if (this.lst.getDatabaseName().equals("DCW")) {
            System.out.println("creating VPFLayerDCWWarehouse");
            this.warehouse = new VPFLayerDCWWarehouse();
        } else {
            System.out.println("creating VPFLayerGraphicWarehouse");
            this.warehouse = new VPFLayerGraphicWarehouse();
        }
        LayerGraphicWarehouseSupport.setDoThinning(doThinning);
        LayerGraphicWarehouseSupport.setFanEpsilon(fan_eps);
        this.warehouse.setProperties(realPrefix, props);
    }

    protected void initLST(String[] paths) {
        try {
            if (this.lst == null) {
                this.lst = new LibrarySelectionTable(paths);
            }
        }
        catch (FormatException f) {
            throw new IllegalArgumentException(f.getMessage());
        }
    }

    public OMGraphicList getRectangle() {
        int scale = 30000000;
        int width = 640;
        int height = 480;
        LatLonPoint upperLeft = new LatLonPoint(90.0f, -180.0f);
        LatLonPoint lowerRight = new LatLonPoint(-90.0f, 180.0f);
        this.warehouse.clear();
        System.out.println("VMAP2Shape.getRectangle(): calling drawTile with boundaries: " + upperLeft + lowerRight);
        long start = System.currentTimeMillis();
        this.lst.drawTile(scale, width, height, vmaptype, this.warehouse, upperLeft, lowerRight);
        long stop = System.currentTimeMillis();
        System.out.println("VMAP2Shape.getRectangle(): read time: " + (double)(stop - start) / 1000.0 + " seconds");
        return this.warehouse.getGraphics();
    }

    public static void usage() {
        System.out.println("Usage: java VMAP2Shape [args] <outfile.shp>");
        System.out.println("Arguments:");
        System.out.println("\t-props <path>             path to properties file");
        System.out.println("                            default: " + propsFileName);
        System.out.println("\t-prefix <identifier>      vmap properties prefix");
        System.out.println("                            default: " + prefix);
        System.out.println("\t-thin <eps> <thresh>      do thinning");
        System.out.println("                            default eps=" + fan_eps + " thresh=" + threshold);
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length == 1 && args[0].startsWith("-")) {
            VMAP2Shape.usage();
        }
        Debug.init(System.getProperties());
        VMAP2Shape c = new VMAP2Shape();
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equalsIgnoreCase("-props")) {
                propsFileName = args[++i];
            } else if (args[i].equalsIgnoreCase("-prefix")) {
                prefix = args[++i];
            } else if (args[i].equalsIgnoreCase("-thin")) {
                doThinning = true;
                fan_eps = Float.valueOf(args[++i]).floatValue();
                threshold = Float.valueOf(args[++i]).floatValue();
            } else {
                VMAP2Shape.usage();
            }
            ++i;
        }
        c.setProperties(prefix, c.loadProperties());
        c.writeShapeFile(args[args.length - 1], c.getRectangle());
    }
}

