/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.util.http;

import com.bbn.openmap.layer.util.http.HttpRequestEvent;
import com.bbn.openmap.layer.util.http.HttpServer;
import com.bbn.openmap.util.Debug;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.StringTokenizer;

public class HttpConnection
extends Thread {
    protected HttpServer server;
    protected Socket client;
    protected BufferedReader in;
    protected OutputStream out;
    protected boolean isConnectionOpen = true;
    public static final String CONTENT_JPEG = "image/jpeg";
    public static final String CONTENT_GIF = "image/gif";
    public static final String CONTENT_PPM = "image/ppm";
    public static final String CONTENT_PNG = "image/png";
    public static final String CONTENT_HTML = "text/html";
    public static final String CONTENT_MOV = "video/quicktime";
    public static final String CONTENT_PLAIN = "text/plain";
    public static final String CONTENT_XML = "text/xml";

    public HttpConnection(Socket client_socket, HttpServer server) {
        this.client = client_socket;
        this.server = server;
        try {
            InputStreamReader isr = new InputStreamReader(this.client.getInputStream());
            this.in = new BufferedReader(isr);
            this.out = this.client.getOutputStream();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            System.err.println("Exception while getting socket streams: " + e);
            return;
        }
        this.start();
    }

    public static String[] getAllContentTypes() {
        return new String[]{CONTENT_JPEG, CONTENT_GIF, CONTENT_HTML, CONTENT_MOV, CONTENT_PLAIN, CONTENT_XML, CONTENT_PPM};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block9: {
            while (this.isConnectionOpen) {
                String line = this.in.readLine();
                if (line == null) break;
                this.processLine(line);
            }
            Object var6_2 = null;
            try {
                this.close();
            }
            catch (IOException e2) {}
            break block9;
            {
                catch (IOException e) {
                    Object var6_3 = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                try {
                    this.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        Debug.message("httpconnection", "Connection closed. Exiting thread");
    }

    protected void processLine(String line) throws IOException {
        if (Debug.debugging("httpconnection")) {
            Debug.output("HttpConnection | processLine -- Processing command " + line);
        }
        if (line.startsWith("GET")) {
            this.processGetCommand(line);
        } else if (line.startsWith("POST")) {
            Debug.message("httpconnection", "handling POST");
            this.handlePost();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void handlePost() throws IOException {
        block10: {
            Debug.message("httpconnection", "HttpConnection | handlePost");
            boolean nEnvarVariables = false;
            int contentLength = 0;
            while (this.isConnectionOpen) {
                String line = this.in.readLine();
                Debug.message("httpconnection", line);
                if (line == null) break;
                String lineupp = line.toUpperCase();
                if (lineupp.startsWith("CONTENT-LENGTH")) {
                    contentLength = this.readContentLength(line);
                    Debug.message("httpconnection", "HttpConnection -- Contentlength = " + contentLength);
                }
                if (!line.equals("")) continue;
                this.readContent(contentLength);
            }
            Object var6_6 = null;
            try {
                this.close();
            }
            catch (IOException e2) {}
            break block10;
            {
                catch (IOException e) {
                    Object var6_7 = null;
                    try {
                        this.close();
                    }
                    catch (IOException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    this.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    protected int readContentLength(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, ":");
        tokenizer.nextToken();
        String strLength = tokenizer.nextToken();
        int length = Integer.parseInt(strLength.trim());
        return length;
    }

    protected boolean isEnvarLine(String line) {
        return line.indexOf(":") != -1;
    }

    protected void readContent(int length) throws IOException {
        HttpRequestEvent event;
        char[] c_content = new char[length];
        int nread = 0;
        int remaining = length;
        try {
            while (nread < length) {
                int tmp = this.in.read(c_content, nread, remaining);
                Debug.message("httpconnection", "Length of content read " + (nread += tmp) + " length=" + length + " remaining=" + (remaining -= tmp));
            }
        }
        catch (IOException ioe) {
            Debug.error("HttpConnection | readContent -- Exception while reading content(key-values from POST) " + ioe.getMessage());
        }
        String content = new String(c_content);
        content = content.trim();
        if (Debug.debugging("httpconnection")) {
            Debug.output("HttpConection showing Content :-- " + content);
        }
        if ((event = this.server.fireHttpRequestEvent(content, this.out)).isWriterUsed()) {
            Writer writer = event.getWriter();
            String result = writer.toString();
            HttpConnection.writeHttpResponse(this.out, null, result);
        }
        this.out.flush();
        this.close();
    }

    protected void processGetCommand(String cmd) throws IOException {
        String location = cmd.substring(4);
        int locationEnd = location.indexOf(" ");
        Object contentType = (location = location.substring(0, locationEnd)).endsWith(".gif") || location.endsWith(".GIF") ? CONTENT_GIF : (location.endsWith(".htm") || location.endsWith(".html") || location.endsWith(".HTM") || location.endsWith(".HTML") ? CONTENT_HTML : (location.endsWith(".jpg") || location.endsWith(".JPG") || location.endsWith(".jpeg") || location.endsWith(".JPEG") ? CONTENT_JPEG : (location.endsWith(".mov") || location.endsWith(".MOV") ? CONTENT_MOV : (location.indexOf(63) != -1 ? null : CONTENT_PLAIN))));
        HttpRequestEvent event = this.server.fireHttpRequestEvent(location, this.out);
        if (event.isWriterUsed()) {
            Writer writer = event.getWriter();
            String result = writer.toString();
            HttpConnection.writeHttpResponse(this.out, (String)contentType, result);
        }
        this.out.flush();
        this.close();
    }

    public static void writeHttpResponseHeader(Writer out, String contentType, int contentLength) throws IOException {
        out.write("HTTP/1.0 200 \n");
        out.write("Content-type: " + contentType + "\n");
        out.write("Content-Length: " + contentLength + "\n");
        out.write("\n");
    }

    public static void writeHttpResponse(OutputStream out, String contentType, String response) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out);
        HttpConnection.writeHttpResponseHeader(osw, contentType, response.length());
        osw.write(response);
        osw.flush();
    }

    public static void writeHttpResponse(OutputStream out, String contentType, byte[] response) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(out);
        HttpConnection.writeHttpResponseHeader(osw, contentType, response.length);
        osw.flush();
        out.write(response, 0, response.length);
        osw.flush();
    }

    public void close() throws IOException {
        this.client.close();
        this.isConnectionOpen = false;
    }
}

