/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.layer.rpf.RpfColortable;
import com.bbn.openmap.layer.rpf.RpfCoverageBox;
import com.bbn.openmap.layer.rpf.RpfFrame;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfFrameProvider;
import com.bbn.openmap.layer.rpf.RpfIndexedImageData;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfTocHandler;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.layer.util.cacheHandler.CacheHandler;
import com.bbn.openmap.layer.util.cacheHandler.CacheObject;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.Debug;
import java.util.List;
import java.util.Vector;

public class RpfFrameCacheHandler
extends CacheHandler
implements RpfFrameProvider {
    public static final int FRAME_CACHE_SIZE = 5;
    protected RpfColortable colortable;
    protected boolean Dchum = true;
    protected boolean outlineChum = false;
    protected RpfTocHandler[] tocs;
    protected RpfViewAttributes viewAttributes = new RpfViewAttributes();

    public RpfFrameCacheHandler(String[] RpfPaths) {
        this(RpfPaths, 5);
    }

    public RpfFrameCacheHandler(String[] RpfPaths, int max_size) {
        super(max_size);
        this.tocs = RpfFrameCacheHandler.createTocHandlers(RpfPaths);
        this.colortable = new RpfColortable();
    }

    public RpfFrameCacheHandler(RpfTocHandler[] tocHandlers) {
        this.tocs = tocHandlers;
        this.colortable = new RpfColortable();
    }

    public boolean needViewAttributeUpdates() {
        return false;
    }

    public void setViewAttributes(RpfViewAttributes va) {
        this.viewAttributes = va;
        if (va != null && this.colortable != null) {
            this.colortable.setOpaqueness(va.opaqueness);
            this.colortable.setNumColors(va.numberOfColors);
        }
    }

    public Vector getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, String chartSeries) {
        Vector coverages = new Vector();
        int i = 0;
        while (i < this.tocs.length) {
            if (this.tocs[i].hasChanged()) {
                this.tocs[i].reload();
            }
            if (this.tocs[i].isValid()) {
                this.tocs[i].getCatalogCoverage(ullat, ullon, lrlat, lrlon, proj, chartSeries, coverages);
            }
            ++i;
        }
        return coverages;
    }

    public float getCalculatedCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG p, String chartSeries) {
        int x;
        int y;
        RpfCoverageBox rcb;
        if (chartSeries.equalsIgnoreCase("ANY")) {
            return 0.0f;
        }
        Vector results = this.getCatalogCoverage(ullat, ullon, lrlat, lrlon, p, chartSeries);
        int size = results.size();
        if (size == 0) {
            return 0.0f;
        }
        int pZone = p.getZone();
        double frameLatInterval = Double.MAX_VALUE;
        double frameLonInterval = Double.MAX_VALUE;
        int i = 0;
        while (i < size) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.subframeLatInterval < frameLatInterval) {
                frameLatInterval = rcb.subframeLatInterval;
            }
            if (rcb.subframeLonInterval < frameLonInterval) {
                frameLonInterval = rcb.subframeLonInterval;
            }
            ++i;
        }
        if (frameLatInterval == Double.MAX_VALUE || frameLonInterval == Double.MAX_VALUE) {
            return 0.0f;
        }
        int numHFrames = (int)Math.ceil((double)(lrlon - ullon) / frameLonInterval);
        int numVFrames = (int)Math.ceil((double)(ullat - lrlat) / frameLatInterval);
        boolean[][] coverage = new boolean[numHFrames][numVFrames];
        i = 0;
        while (i < size) {
            rcb = (RpfCoverageBox)results.elementAt(i);
            if (rcb.percentCoverage == 100.0f) {
                return 1.0f;
            }
            y = 0;
            while (y < numVFrames) {
                x = 0;
                while (x < numHFrames) {
                    float yFrameLoc = (float)((double)lrlat + (double)y * frameLatInterval);
                    float xFrameLoc = (float)((double)ullon + (double)x * frameLonInterval);
                    if (!coverage[x][y] && rcb.within(yFrameLoc, xFrameLoc)) {
                        coverage[x][y] = true;
                    }
                    ++x;
                }
                ++y;
            }
            ++i;
        }
        float count = 0.0f;
        y = 0;
        while (y < numVFrames) {
            x = 0;
            while (x < numHFrames) {
                if (coverage[x][y]) {
                    count += 1.0f;
                }
                ++x;
            }
            ++y;
        }
        return count / (float)(numHFrames * numVFrames);
    }

    public Vector getCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj) {
        Debug.message("rpf", "RpfFrameCacheHandler: getCoverage()");
        Vector<RpfCoverageBox> coverageBoxes = new Vector<RpfCoverageBox>();
        int i = 0;
        while (i < this.tocs.length) {
            if (this.tocs[i].hasChanged()) {
                this.tocs[i].reload();
            }
            if (this.tocs[i].isValid()) {
                List coverageEntries = this.tocs[i].getBestCoverageEntry(ullat, ullon, lrlat, lrlon, proj, this.viewAttributes);
                int k = 0;
                while (k < coverageEntries.size()) {
                    RpfTocEntry currentEntry = (RpfTocEntry)coverageEntries.get(k);
                    if (currentEntry != null) {
                        if (Debug.debugging("rpftoc")) {
                            System.out.println("RFCH: Toc " + i + " returned an entry");
                        }
                        RpfCoverageBox currentCoverage = currentEntry.coverage;
                        Object[] coverageArray = new Object[coverageBoxes.size()];
                        coverageBoxes.copyInto(coverageArray);
                        coverageBoxes.removeAllElements();
                        int size = coverageArray.length;
                        if (size == 0) {
                            coverageBoxes.addElement(currentCoverage);
                        } else {
                            boolean addedCurrent = false;
                            boolean okToAddCurrent = true;
                            int j = 0;
                            while (j < size) {
                                RpfCoverageBox rcb = (RpfCoverageBox)coverageArray[j];
                                if (!addedCurrent) {
                                    if (j == 0) {
                                        if (RpfFrameCacheHandler.scaleDifference(proj, currentCoverage) <= RpfFrameCacheHandler.scaleDifference(proj, rcb) && currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                            coverageBoxes.addElement(currentCoverage);
                                            addedCurrent = true;
                                            if (currentCoverage.scale != rcb.scale) break;
                                            coverageBoxes.addElement(rcb);
                                        } else {
                                            coverageBoxes.addElement(rcb);
                                        }
                                    } else if (currentCoverage.percentCoverage >= rcb.percentCoverage) {
                                        if (((RpfCoverageBox)coverageBoxes.get((int)0)).scale == currentCoverage.scale) {
                                            coverageBoxes.add(currentCoverage);
                                            addedCurrent = true;
                                        } else {
                                            okToAddCurrent = false;
                                        }
                                        coverageBoxes.add(rcb);
                                    } else {
                                        coverageBoxes.add(rcb);
                                    }
                                } else if (((RpfCoverageBox)coverageBoxes.get((int)0)).scale == rcb.scale) {
                                    coverageBoxes.add(rcb);
                                }
                                ++j;
                            }
                            if (!addedCurrent && okToAddCurrent && ((RpfCoverageBox)coverageBoxes.get((int)0)).scale == currentCoverage.scale) {
                                coverageBoxes.add(currentCoverage);
                            }
                        }
                    } else if (Debug.debugging("rpftoc")) {
                        System.out.println("RFCH: Toc " + i + " did NOT return an entry");
                    }
                    ++k;
                }
            }
            ++i;
        }
        return coverageBoxes;
    }

    public String getSubframeAttributes(int tocNumber, int entryNumber, int x, int y) {
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        RpfFrameEntry frameEntry = entry.frames[y / 6][x / 6];
        RpfFrame frame = (RpfFrame)this.get(frameEntry);
        if (frame == null) {
            return null;
        }
        return frame.getReport(x, y, frameEntry, entry.Cib);
    }

    public int[] getSubframeData(int tocNumber, int entryNumber, int x, int y) {
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        RpfFrameEntry frameEntry = entry.frames[y / 6][x / 6];
        RpfFrame frame = (RpfFrame)this.get(frameEntry);
        if (frame == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        return frame.decompressSubframe(x, y, this.colortable);
    }

    public RpfIndexedImageData getRawSubframeData(int tocNumber, int entryNumber, int x, int y) {
        if (!this.tocs[tocNumber].isValid()) {
            return null;
        }
        RpfTocEntry entry = this.tocs[tocNumber].entries[entryNumber];
        if (y < 0 || x < 0 || entry == null || y >= entry.vertFrames * 6 || x >= entry.horizFrames * 6) {
            return null;
        }
        RpfFrameEntry frameEntry = entry.frames[y / 6][x / 6];
        RpfFrame frame = (RpfFrame)this.get(frameEntry);
        if (frame == null) {
            return null;
        }
        this.checkColortable(frame, frameEntry, entry, tocNumber, entryNumber);
        RpfIndexedImageData riid = new RpfIndexedImageData();
        riid.imageData = frame.decompressSubframe(x, y);
        riid.colortable = this.colortable.colors;
        return riid;
    }

    protected void checkColortable(RpfFrame frame, RpfFrameEntry frameEntry, RpfTocEntry entry, int tocNumber, int entryNumber) {
        if (Debug.debugging("rpf")) {
            Debug.output("RpfFrameCacheHandler: getting new colors");
            Debug.output("RpfFrameCacheHandler: getting CIB colors = " + entry.Cib);
        }
        this.colortable.setCib(entry.Cib);
        this.colortable.setATOCIndexes(tocNumber, entryNumber);
        this.colortable = frame.getColortable();
        this.colortable.zone = entry.zone;
        this.colortable.seriesCode = entry.info.seriesCode;
        if (this.viewAttributes != null) {
            this.colortable.setOpaqueness(this.viewAttributes.opaqueness);
        }
    }

    public static RpfTocHandler[] createTocHandlers(String[] RpfPaths) {
        RpfTocHandler[] tocs = new RpfTocHandler[RpfPaths != null ? RpfPaths.length : 0];
        int i = 0;
        while (i < tocs.length) {
            tocs[i] = new RpfTocHandler(RpfPaths[i], i);
            ++i;
        }
        return tocs;
    }

    public CacheObject load(String RpfFramePath) {
        RpfFrame frame = new RpfFrame(RpfFramePath);
        if (frame.isValid()) {
            CacheObject obj = new CacheObject(RpfFramePath, frame);
            return obj;
        }
        return null;
    }

    public Object get(RpfFrameEntry rfe) {
        CacheObject ret = this.searchCache(rfe.framePath);
        if (ret != null) {
            return ret.obj;
        }
        ret = this.load(rfe);
        if (ret == null) {
            return null;
        }
        if (Debug.debugging("rpfdetail")) {
            System.out.println(rfe);
        }
        this.replaceLeastUsed(ret);
        return ret.obj;
    }

    public CacheObject load(RpfFrameEntry rfe) {
        RpfFrame frame;
        if (!rfe.exists) {
            if (Debug.debugging("rpf")) {
                System.out.println("RpfFrameCacheHandler: Frame doesn't exist!: " + rfe.framePath);
            }
            return null;
        }
        if (Debug.debugging("rpf")) {
            Debug.output("RpfFrameCacheHandler: Loading Frame " + rfe.framePath);
        }
        if ((frame = new RpfFrame(rfe)).isValid()) {
            CacheObject obj = new CacheObject(rfe.framePath, frame);
            return obj;
        }
        if (Debug.debugging("rpf")) {
            Debug.error("RpfFrameCacheHandler:  Couldn't find frame /" + rfe.framePath + "/ (" + rfe.framePath.length() + " chars)");
        }
        rfe.exists = false;
        return null;
    }

    public void resizeCache(int max_size) {
        this.resetCache(max_size);
    }

    public void resetCache() {
        super.resetCache();
        Debug.message("rpf", "RpfFrameCacheHandler: reset frame cache.");
    }

    public static float scaleDifference(CADRG proj, RpfCoverageBox box) {
        return Math.abs(proj.getScale() - box.scale);
    }

    public RpfColortable getColortable() {
        return this.colortable;
    }
}

