/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;

public class TimerLocationLayer
extends LocationLayer {
    protected Timer timer;
    public static final String UpdateTimerIntervalProperty = "updateTimerInterval";
    public static final String AutoTimerProperty = "automaticTimer";
    protected boolean autoTimer = true;
    private final Layer layer = this;
    protected JCheckBox timerButton = null;
    protected JCheckBox autoTimerButton = null;
    protected int updateInterval = 10000;

    public TimerLocationLayer() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                if (e.getComponent() == TimerLocationLayer.this.layer && TimerLocationLayer.this.getAutoTimer() && TimerLocationLayer.this.timerButton != null && !TimerLocationLayer.this.timerButton.isSelected()) {
                    TimerLocationLayer.this.timerButton.doClick();
                }
            }

            public void componentHidden(ComponentEvent e) {
                if (e.getComponent() == TimerLocationLayer.this.layer && TimerLocationLayer.this.getAutoTimer() && TimerLocationLayer.this.timerButton != null && TimerLocationLayer.this.timerButton.isSelected()) {
                    TimerLocationLayer.this.timerButton.doClick();
                }
            }
        });
    }

    public void projectionChanged(ProjectionEvent e) {
        super.projectionChanged(e);
        if (this.autoTimer && this.timer != null && (this.timerButton != null && this.timerButton.isSelected() || this.timerButton == null && this.getUpdateInterval() > 0)) {
            this.timer.restart();
            this.updateTimerButton();
        }
    }

    public void removed(Container cont) {
        if (this.autoTimer) {
            this.timer.stop();
            this.updateTimerButton();
        }
    }

    public Component getGUI() {
        this.box = null;
        this.box = (Box)super.getGUI();
        if (this.getTimer() != null) {
            if (this.timerButton == null) {
                String bTitle = "Run Update Timer";
                int interval = this.getUpdateInterval();
                if (interval > 0) {
                    bTitle = "Reload Data (" + interval / 1000 + " sec)";
                }
                this.timerButton = new JCheckBox(bTitle, this.getTimer().isRunning());
                this.timerButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        JCheckBox check = (JCheckBox)ae.getSource();
                        Timer t = TimerLocationLayer.this.getTimer();
                        if (t != null) {
                            if (check.isSelected()) {
                                t.restart();
                            } else {
                                t.stop();
                            }
                        }
                    }
                });
                this.timerButton.setToolTipText("<HTML><BODY>Reload the map data from the original source at specified intervals.</BODY></HTML>");
            }
            if (this.autoTimerButton == null) {
                this.autoTimerButton = new JCheckBox("Reload Only When Visible", this.getAutoTimer());
                this.autoTimerButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ae) {
                        JCheckBox check = (JCheckBox)ae.getSource();
                        TimerLocationLayer.this.setAutoTimer(check.isSelected());
                    }
                });
                this.autoTimerButton.setToolTipText("<HTML><BODY>Only run the timer when the layer is active on the map.</BODY></HTML>");
            }
            JPanel tbp = new JPanel(new GridLayout(0, 1));
            tbp.add(this.timerButton);
            tbp.add(this.autoTimerButton);
            this.box.add(tbp);
        }
        return this.box;
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        String realPrefix = "";
        if (prefix != null) {
            realPrefix = prefix + ".";
        }
        this.setUpdateInterval(PropUtils.intFromProperties(properties, realPrefix + UpdateTimerIntervalProperty, this.updateInterval));
        this.setAutoTimer(PropUtils.booleanFromProperties(properties, realPrefix + AutoTimerProperty, this.autoTimer));
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + UpdateTimerIntervalProperty, Integer.toString(this.updateInterval));
        props.put(prefix + AutoTimerProperty, new Boolean(this.autoTimer).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(UpdateTimerIntervalProperty, "Number of milliseconds for automatic file reloading.");
        list.put(AutoTimerProperty, "Flag to start/stop timer automatically when layer is on map.");
        list.put("automaticTimer.editor", "com.bbn.openmap.util.propertyEditor.OnOffPropertyEditor");
        return list;
    }

    public void setAutoTimer(boolean value) {
        this.autoTimer = value;
        if (this.autoTimerButton != null) {
            this.autoTimerButton.setSelected(this.getAutoTimer());
        }
        if (!this.isVisible()) {
            if (!value && this.getProjection() != null) {
                this.timer.restart();
            } else if (value) {
                this.timer.stop();
            }
        }
    }

    public boolean getAutoTimer() {
        return this.autoTimer;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.timer = t;
        this.updateTimerButton();
    }

    public void timerPing() {
        this.reloadData();
        if (this.isVisible()) {
            this.doPrepare();
        }
    }

    public void createTimer() {
        Timer t = new Timer(this.updateInterval, new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                TimerLocationLayer.this.timerPing();
            }
        });
        t.setInitialDelay(0);
        this.setTimer(t);
    }

    public void setUpdateInterval(int delay) {
        if (delay > 0) {
            this.updateInterval = delay;
            if (this.timer == null) {
                this.createTimer();
            }
            this.timer.setDelay(this.updateInterval);
            if (this.timer.isRunning()) {
                this.timer.restart();
            }
        } else if (this.timer != null) {
            this.timer.stop();
        }
        this.updateTimerButton();
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    protected void updateTimerButton() {
        if (this.timerButton != null) {
            this.timerButton.setEnabled(this.timer != null);
            this.timerButton.setSelected(this.timer != null && this.timer.isRunning());
        }
    }
}

