/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.layer.DeclutterMatrix;
import com.bbn.openmap.layer.location.Location;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.omGraphics.OMRasterObject;
import com.bbn.openmap.proj.Projection;
import java.awt.Point;
import javax.swing.ImageIcon;

public class ByteRasterLocation
extends Location {
    public int SPACING = 0;

    public ByteRasterLocation(float latitude, float longitude, String name, byte[] bytearr) {
        super(latitude, longitude, name, (OMGraphic)ByteRasterLocation.getIconRaster(latitude, longitude, bytearr));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public ByteRasterLocation(int x, int y, String name, byte[] bytearr) {
        super(x, y, name, (OMGraphic)ByteRasterLocation.getIconRaster(x, y, bytearr));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public ByteRasterLocation(float latitude, float longitude, int xOffset, int yOffset, String name, byte[] bytearr) {
        super(latitude, longitude, xOffset, yOffset, name, ByteRasterLocation.getIconRaster(latitude, longitude, xOffset, yOffset, bytearr));
        if (this.location instanceof OMRaster) {
            this.setHorizontalLabelBuffer(((OMRaster)this.location).getWidth() / 2 + this.SPACING);
        }
    }

    public static OMRaster getIconRaster(float lat, float lon, byte[] bytearr) {
        ImageIcon icon = ByteRasterLocation.getIconRaster(bytearr);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(lat, lon, -offX, -offY, icon);
    }

    public static OMRaster getIconRaster(int x, int y, byte[] bytearr) {
        ImageIcon icon = ByteRasterLocation.getIconRaster(bytearr);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(x - offX, y - offY, icon);
    }

    public static OMRaster getIconRaster(float lat, float lon, int x, int y, byte[] bytearr) {
        ImageIcon icon = ByteRasterLocation.getIconRaster(bytearr);
        if (icon == null) {
            return null;
        }
        int offX = icon.getIconWidth() / 2;
        int offY = icon.getIconHeight() / 2;
        return new OMRaster(lat, lon, x - offX, y - offY, icon);
    }

    public static ImageIcon getIconRaster(byte[] bytearr) {
        if (bytearr == null) {
            return null;
        }
        ImageIcon icon = new ImageIcon(bytearr);
        return icon;
    }

    protected void declutterLabel(DeclutterMatrix declutter, Projection proj) {
        Point lp;
        super.declutterLabel(declutter, proj);
        if (this.isShowLocation() && this.location instanceof OMRasterObject && (lp = ((OMRasterObject)this.location).getMapLocation()) != null) {
            int locHeight = ((OMRasterObject)this.location).getHeight();
            int locWidth = ((OMRasterObject)this.location).getWidth();
            lp.y += locHeight;
            declutter.setTaken(lp, locWidth, locHeight);
            lp.y -= locHeight;
        }
    }

    public void setGraphicLocations(float latitude, float longitude) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setLat(latitude);
            ras.setLon(longitude);
            this.label.setLat(latitude);
            this.label.setLon(longitude);
            this.setHorizontalLabelBuffer(ras.getWidth() / 2 + this.SPACING);
        }
    }

    public void setGraphicLocations(int x, int y) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setX(x);
            ras.setY(y);
            this.label.setX(x);
            this.label.setY(y);
            this.setHorizontalLabelBuffer(ras.getWidth() / 2 + this.SPACING);
        }
    }

    public void setGraphicLocations(float latitude, float longitude, int offsetX, int offsetY) {
        if (this.location instanceof OMRaster) {
            OMRaster ras = (OMRaster)this.location;
            ras.setLat(latitude);
            ras.setLon(longitude);
            ras.setX(offsetX);
            ras.setY(offsetY);
            this.label.setLat(latitude);
            this.label.setLon(longitude);
            this.label.setX(offsetX);
            this.label.setY(offsetY);
            this.setHorizontalLabelBuffer(ras.getWidth() / 2 + this.SPACING);
        }
    }
}

